/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.AppTopics;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.EditorWindowImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.util.FileContentUtil;
import com.intellij.util.Processor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDocumentManagerImpl
extends PsiDocumentManagerBase
implements SettingsSavingComponent {
    private final DocumentCommitProcessor myDocumentCommitThread;
    private final boolean myUnitTestMode;

    public PsiDocumentManagerImpl(final @NotNull Project project2, @NotNull PsiManager psiManager, @NotNull EditorFactory editorFactory, @NotNull MessageBus bus, final @NonNls @NotNull DocumentCommitProcessor documentCommitThread) {
        if (project2 == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(0);
        }
        if (psiManager == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(1);
        }
        if (editorFactory == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(2);
        }
        if (bus == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(3);
        }
        if (documentCommitThread == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(4);
        }
        super(project2, psiManager, bus, documentCommitThread);
        this.myUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        this.myDocumentCommitThread = documentCommitThread;
        editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)this, (Disposable)project2);
        MessageBusConnection connection = bus.connect();
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileContentLoaded(@NotNull VirtualFile virtualFile, @NotNull Document document) {
                if (virtualFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiFile psiFile = (PsiFile)ReadAction.compute(() -> {
                    if (virtualFile == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return PsiDocumentManagerImpl.this.myProject.isDisposed() || !virtualFile.isValid() ? null : PsiDocumentManagerImpl.this.getCachedPsiFile(virtualFile);
                });
                PsiDocumentManagerImpl.this.fireDocumentCreated(document, psiFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "virtualFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/PsiDocumentManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileContentLoaded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$fileContentLoaded$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateFinished(@NotNull Document doc) {
                if (doc == null) {
                    2.$$$reportNull$$$0(0);
                }
                documentCommitThread.commitAsynchronously(project2, doc, "Bulk update finished", TransactionGuard.getInstance().getContextTransaction());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/PsiDocumentManagerImpl$2", "updateFinished"));
            }
        });
        Disposer.register((Disposable)project2, () -> {
            if (project2 == null) {
                PsiDocumentManagerImpl.$$$reportNull$$$0(15);
            }
            ((DocumentCommitThread)this.myDocumentCommitThread).cancelTasksOnProjectDispose(project2);
        });
    }

    @Override
    @Nullable
    public PsiFile getPsiFile(@NotNull Document document) {
        Collection projects;
        VirtualFile virtualFile;
        if (document == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(5);
        }
        PsiFile psiFile = super.getPsiFile(document);
        if (this.myUnitTestMode && (virtualFile = FileDocumentManager.getInstance().getFile(document)) != null && virtualFile.isValid() && !(projects = ProjectLocator.getInstance().getProjectsForFile(virtualFile)).isEmpty() && !projects.contains(this.myProject)) {
            LOG.error("Trying to get PSI for an alien project. VirtualFile=" + virtualFile + ";\n myProject=" + this.myProject + ";\n projects returned: " + projects);
        }
        return psiFile;
    }

    @Override
    public void documentChanged(DocumentEvent event) {
        super.documentChanged(event);
        if (this.isUncommited(event.getDocument()) && FileDocumentManagerImpl.areTooManyDocumentsInTheQueue(this.myUncommittedDocuments)) {
            if (this.myUnitTestMode) {
                this.myStopTrackingDocuments = true;
                try {
                    LOG.error("Too many uncommitted documents for " + this.myProject + "(" + this.myUncommittedDocuments.size() + "):\n" + StringUtil.join((Iterable)this.myUncommittedDocuments, (String)"\n") + "\n\n Project creation trace: " + (String)this.myProject.getUserData(ProjectImpl.CREATION_TRACE));
                }
                finally {
                    this.clearUncommittedDocuments();
                }
            }
            if (PomModelImpl.isAllowPsiModification() && ApplicationManager.getApplication().isWriteAccessAllowed()) {
                for (Document document : this.myUncommittedDocuments) {
                    if (document == event.getDocument()) continue;
                    this.doCommitWithoutReparse(document);
                    break;
                }
            }
        }
    }

    @VisibleForTesting
    public void doCommitWithoutReparse(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(6);
        }
        this.finishCommitInWriteAction(document, Collections.emptyList(), true, true);
    }

    @Override
    protected void beforeDocumentChangeOnUnlockedDocument(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(7);
        }
        PostprocessReformattingAspect.getInstance(this.myProject).assertDocumentChangeIsAllowed(viewProvider);
        super.beforeDocumentChangeOnUnlockedDocument(viewProvider);
    }

    @Override
    protected boolean finishCommitInWriteAction(@NotNull Document document, @NotNull List<Processor<Document>> finishProcessors, boolean synchronously, boolean forceNoPsiCommit) {
        if (document == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(8);
        }
        if (finishProcessors == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(9);
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            EditorWindowImpl.disposeInvalidEditors();
        }
        return super.finishCommitInWriteAction(document, finishProcessors, synchronously, forceNoPsiCommit);
    }

    @Override
    public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
        FileViewProvider viewProvider;
        if (doc == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(10);
        }
        return (viewProvider = this.getCachedViewProvider(doc)) != null && PostprocessReformattingAspect.getInstance(this.myProject).isViewProviderLocked(viewProvider);
    }

    @Override
    public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
        if (doc == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(11);
        }
        if (doc instanceof DocumentWindow) {
            doc = ((DocumentWindow)doc).getDelegate();
        }
        PostprocessReformattingAspect component = (PostprocessReformattingAspect)this.myProject.getComponent(PostprocessReformattingAspect.class);
        FileViewProvider viewProvider = this.getCachedViewProvider(doc);
        if (viewProvider != null && component != null) {
            component.doPostponedFormatting(viewProvider);
        }
    }

    public void save() {
        try {
            this.commitAllDocuments();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void clearUncommittedDocuments() {
        super.clearUncommittedDocuments();
        ((DocumentCommitThread)this.myDocumentCommitThread).clearQueue();
    }

    @NonNls
    public String toString() {
        return super.toString() + " for the project " + this.myProject + ".";
    }

    @Override
    public void reparseFiles(@NotNull Collection<VirtualFile> files, boolean includeOpenFiles) {
        if (files == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(12);
        }
        FileContentUtil.reparseFiles((Project)this.myProject, files, (boolean)includeOpenFiles);
    }

    @Override
    @NotNull
    protected DocumentWindow freezeWindow(@NotNull DocumentWindow document) {
        if (document == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(13);
        }
        DocumentWindow documentWindow = MultiHostRegistrarImpl.freezeWindow((DocumentWindowImpl)document);
        if (documentWindow == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(14);
        }
        return documentWindow;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentCommitThread";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishProcessors";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiDocumentManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiDocumentManagerImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "freezeWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doCommitWithoutReparse";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChangeOnUnlockedDocument";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "finishCommitInWriteAction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentBlockedByPsi";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doPostponedOperationsAndUnblockDocument";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reparseFiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "freezeWindow";
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

