/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileFactoryImpl
extends PsiFileFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiFileFactoryImpl");
    private final PsiManager myManager;

    public PsiFileFactoryImpl(PsiManager manager) {
        this.myManager = manager;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiFile createFileFromText(@NotNull String name2, @NotNull FileType fileType, @NotNull CharSequence text2, long modificationStamp, boolean bl) {
        void eventSystemEnabled;
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(0);
        }
        if (fileType == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(1);
        }
        if (text2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(2);
        }
        PsiFile psiFile = this.createFileFromText(name2, fileType, text2, modificationStamp, (boolean)eventSystemEnabled, true);
        if (psiFile == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(3);
        }
        return psiFile;
    }

    public PsiFile createFileFromText(@NotNull String name2, @NotNull Language language, @NotNull CharSequence text2) {
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(4);
        }
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(6);
        }
        return this.createFileFromText(name2, language, text2, true, true);
    }

    public PsiFile createFileFromText(@NotNull String name2, @NotNull Language language, @NotNull CharSequence text2, boolean eventSystemEnabled, boolean markAsCopy) {
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(7);
        }
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(9);
        }
        return this.createFileFromText(name2, language, text2, eventSystemEnabled, markAsCopy, false);
    }

    public PsiFile createFileFromText(@NotNull String name2, @NotNull Language language, @NotNull CharSequence text2, boolean eventSystemEnabled, boolean markAsCopy, boolean noSizeLimit) {
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(10);
        }
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(12);
        }
        return this.createFileFromText(name2, language, text2, eventSystemEnabled, markAsCopy, noSizeLimit, null);
    }

    public PsiFile createFileFromText(@NotNull String name2, @NotNull Language language, @NotNull CharSequence text2, boolean eventSystemEnabled, boolean markAsCopy, boolean noSizeLimit, @Nullable VirtualFile original) {
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(13);
        }
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(14);
        }
        if (text2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(15);
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name2, language, text2);
        if (original != null) {
            virtualFile.setOriginalFile(original);
            virtualFile.setFileType(original.getFileType());
        }
        if (noSizeLimit) {
            SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)virtualFile);
        }
        return this.trySetupPsiForFile(virtualFile, language, eventSystemEnabled, markAsCopy);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiFile createFileFromText(@NotNull String name2, @NotNull FileType fileType, @NotNull CharSequence text2, long modificationStamp, boolean eventSystemEnabled, boolean bl) {
        void markAsCopy;
        Language language;
        PsiFile file2;
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(16);
        }
        if (fileType == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(17);
        }
        if (text2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(18);
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name2, fileType, text2, modificationStamp);
        if (fileType instanceof LanguageFileType && (file2 = this.trySetupPsiForFile(virtualFile, language = LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)fileType).getLanguage(), (VirtualFile)virtualFile, this.myManager.getProject()), eventSystemEnabled, (boolean)markAsCopy)) != null) {
            PsiFile psiFile = file2;
            if (psiFile == null) {
                PsiFileFactoryImpl.$$$reportNull$$$0(19);
            }
            return psiFile;
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, (VirtualFile)virtualFile, eventSystemEnabled);
        PsiPlainTextFileImpl plainTextFile = new PsiPlainTextFileImpl(singleRootFileViewProvider);
        if (markAsCopy != false) {
            CodeEditUtil.setNodeGenerated((ASTNode)plainTextFile.getNode(), true);
        }
        PsiPlainTextFileImpl psiPlainTextFileImpl = plainTextFile;
        if (psiPlainTextFileImpl == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(20);
        }
        return psiPlainTextFileImpl;
    }

    @Nullable
    public PsiFile trySetupPsiForFile(@NotNull LightVirtualFile virtualFile, @NotNull Language language, boolean physical, boolean markAsCopy) {
        PsiFile psiFile;
        ParserDefinition parserDefinition;
        FileViewProviderFactory factory;
        FileViewProvider viewProvider;
        if (virtualFile == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(21);
        }
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(22);
        }
        FileViewProvider fileViewProvider = viewProvider = (factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language)) != null ? factory.createFileViewProvider((VirtualFile)virtualFile, language, this.myManager, physical) : null;
        if (viewProvider == null) {
            viewProvider = new SingleRootFileViewProvider(this.myManager, (VirtualFile)virtualFile, physical);
        }
        if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language = viewProvider.getBaseLanguage())) != null && (psiFile = viewProvider.getPsi(language)) != null) {
            if (markAsCopy) {
                if (psiFile.getNode() == null) {
                    throw new AssertionError((Object)("No node for file " + psiFile + "; language=" + language));
                }
                PsiFileFactoryImpl.markGenerated((PsiElement)psiFile);
            }
            return psiFile;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiFile createFileFromText(@NotNull String name2, @NotNull FileType fileType, Language language, @NotNull Language targetLanguage, @NotNull CharSequence text2, long modificationStamp, boolean physical, boolean bl) {
        void markAsCopy;
        PsiFile psiFile;
        FileViewProvider viewProvider;
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(23);
        }
        if (fileType == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(24);
        }
        if (targetLanguage == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(25);
        }
        if (text2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(26);
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name2, fileType, text2, modificationStamp);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        FileViewProviderFactory factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        FileViewProvider fileViewProvider = viewProvider = factory != null ? factory.createFileViewProvider((VirtualFile)virtualFile, language, this.myManager, physical) : null;
        if (viewProvider == null) {
            viewProvider = new SingleRootFileViewProvider(this.myManager, (VirtualFile)virtualFile, physical);
        }
        if (parserDefinition != null && (psiFile = viewProvider.getPsi(targetLanguage)) != null) {
            if (markAsCopy != false) {
                PsiFileFactoryImpl.markGenerated((PsiElement)psiFile);
            }
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null) {
                PsiFileFactoryImpl.$$$reportNull$$$0(27);
            }
            return psiFile2;
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, (VirtualFile)virtualFile, physical);
        PsiPlainTextFileImpl plainTextFile = new PsiPlainTextFileImpl(singleRootFileViewProvider);
        if (markAsCopy != false) {
            CodeEditUtil.setNodeGenerated((ASTNode)plainTextFile.getNode(), true);
        }
        PsiPlainTextFileImpl psiPlainTextFileImpl = plainTextFile;
        if (psiPlainTextFileImpl == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(28);
        }
        return psiPlainTextFileImpl;
    }

    @NotNull
    public PsiFile createFileFromText(@NotNull String name2, @NotNull FileType fileType, @NotNull CharSequence text2) {
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(29);
        }
        if (fileType == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(30);
        }
        if (text2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(31);
        }
        PsiFile psiFile = this.createFileFromText(name2, fileType, text2, LocalTimeCounter.currentTime(), false);
        if (psiFile == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(32);
        }
        return psiFile;
    }

    @NotNull
    public PsiFile createFileFromText(@NotNull String name2, @NotNull String text2) {
        FileType type2;
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(33);
        }
        if (text2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(34);
        }
        if ((type2 = FileTypeRegistry.getInstance().getFileTypeByFileName(name2)).isBinary()) {
            throw new RuntimeException("Cannot create binary files from text: name " + name2 + ", file type " + type2);
        }
        PsiFile psiFile = this.createFileFromText(name2, type2, (CharSequence)text2);
        if (psiFile == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(35);
        }
        return psiFile;
    }

    public PsiFile createFileFromText(FileType fileType, String fileName, CharSequence chars, int startOffset, int endOffset) {
        LOG.assertTrue(!fileType.isBinary());
        Object text2 = startOffset == 0 && endOffset == chars.length() ? chars : new CharSequenceSubSequence(chars, startOffset, endOffset);
        return this.createFileFromText(fileName, fileType, (CharSequence)text2);
    }

    @Nullable
    public PsiFile createFileFromText(@NotNull CharSequence chars, @NotNull PsiFile original) {
        PsiFile file2;
        if (chars == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(36);
        }
        if (original == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(37);
        }
        if ((file2 = this.createFileFromText(original.getName(), original.getLanguage(), chars, false, true)) != null) {
            file2.putUserData(ORIGINAL_FILE, (Object)original);
        }
        return file2;
    }

    @Nullable
    public PsiElement createElementFromText(@Nullable String text2, @NotNull Language language, @NotNull IElementType type2, @Nullable PsiElement context) {
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(38);
        }
        if (type2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(39);
        }
        if (text2 == null) {
            return null;
        }
        DummyHolder result2 = DummyHolderFactory.createHolder(this.myManager, language, context);
        FileElement holder = result2.getTreeElement();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parserDefinition == null) {
            throw new AssertionError((Object)("No parser definition for " + language));
        }
        Project project2 = this.myManager.getProject();
        Lexer lexer = parserDefinition.createLexer(project2);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project2, (ASTNode)holder, lexer, language, (CharSequence)text2);
        ASTNode node = parserDefinition.createParser(project2).parse(type2, builder);
        holder.rawAddChildren((TreeElement)node);
        PsiFileFactoryImpl.markGenerated((PsiElement)result2);
        return node.getPsi();
    }

    public static void markGenerated(PsiElement element) {
        TreeElement node = (TreeElement)element.getNode();
        assert (node != null);
        node.acceptTree(new GeneratedMarkerVisitor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 32: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 32: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 17: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 26: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiFileFactoryImpl";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 22: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLanguage";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiFileFactoryImpl";
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 32: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 32: 
            case 35: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "trySetupPsiForFile";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createElementFromText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 32: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

