/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightElement;
import org.jetbrains.annotations.NotNull;

public class LightReferenceParameterList
extends LightElement
implements PsiReferenceParameterList {
    private final PsiTypeElement[] myTypeElements;
    private final String myText;

    public LightReferenceParameterList(PsiManager manager, PsiTypeElement[] referenceElements) {
        super(manager, (Language)JavaLanguage.INSTANCE);
        this.myTypeElements = referenceElements;
        this.myText = this.calculateText();
    }

    private String calculateText() {
        if (this.myTypeElements.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<");
        for (int i = 0; i < this.myTypeElements.length; ++i) {
            PsiTypeElement type2 = this.myTypeElements[i];
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(type2.getText());
        }
        buffer.append(">");
        return buffer.toString();
    }

    @Override
    public String toString() {
        return "PsiReferenceParameterList";
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            LightReferenceParameterList.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceParameterList((PsiReferenceParameterList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public PsiElement copy() {
        PsiTypeElement[] elements = new PsiTypeElement[this.myTypeElements.length];
        for (int i = 0; i < this.myTypeElements.length; ++i) {
            PsiTypeElement typeElement = this.myTypeElements[i];
            elements[i] = (PsiTypeElement)typeElement.copy();
        }
        return new LightReferenceParameterList(this.myManager, elements);
    }

    @NotNull
    public PsiTypeElement[] getTypeParameterElements() {
        if (this.myTypeElements == null) {
            LightReferenceParameterList.$$$reportNull$$$0(1);
        }
        return this.myTypeElements;
    }

    @NotNull
    public PsiType[] getTypeArguments() {
        PsiType[] psiTypeArray = PsiImplUtil.typesByTypeElements(this.myTypeElements);
        if (psiTypeArray == null) {
            LightReferenceParameterList.$$$reportNull$$$0(2);
        }
        return psiTypeArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/light/LightReferenceParameterList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/light/LightReferenceParameterList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

