/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AnnotatedElementsSearcher
implements QueryExecutor<PsiModifierListOwner, AnnotatedElementsSearch.Parameters> {
    public boolean execute(@NotNull AnnotatedElementsSearch.Parameters p, @NotNull Processor<PsiModifierListOwner> consumer) {
        PsiClass annClass;
        if (p == null) {
            AnnotatedElementsSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            AnnotatedElementsSearcher.$$$reportNull$$$0(1);
        }
        if (!(annClass = p.getAnnotationClass()).isAnnotationType()) {
            throw new IllegalArgumentException("Annotation type should be passed to annotated members search but got: " + annClass);
        }
        String annotationFQN = (String)ReadAction.compute(() -> annClass.getQualifiedName());
        if (annotationFQN == null) {
            throw new IllegalArgumentException("FQN is null for " + annClass);
        }
        PsiManager psiManager = (PsiManager)ReadAction.compute(() -> annClass.getManager());
        SearchScope useScope = p.getScope();
        Class[] types = p.getTypes();
        for (PsiAnnotation ann : AnnotatedElementsSearcher.getAnnotationCandidates(annClass, useScope, psiManager.getProject())) {
            PsiModifierListOwner candidate = (PsiModifierListOwner)ReadAction.compute(() -> {
                PsiElement parent;
                if (p == null) {
                    AnnotatedElementsSearcher.$$$reportNull$$$0(10);
                }
                if (!((parent = ann.getContext()) instanceof PsiModifierList)) {
                    return null;
                }
                PsiElement owner2 = parent.getParent();
                if (!AnnotatedElementsSearcher.isInstanceof(owner2, types)) {
                    return null;
                }
                if (p.isApproximate()) {
                    return (PsiModifierListOwner)owner2;
                }
                PsiJavaCodeReferenceElement ref = ann.getNameReferenceElement();
                if (ref == null || !psiManager.areElementsEquivalent(ref.resolve(), (PsiElement)annClass)) {
                    return null;
                }
                return (PsiModifierListOwner)owner2;
            });
            if (candidate == null || consumer.process((Object)candidate)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Collection<PsiAnnotation> getAnnotationCandidates(@NotNull PsiClass annClass, @NotNull SearchScope useScope, @NotNull Project project2) {
        if (annClass == null) {
            AnnotatedElementsSearcher.$$$reportNull$$$0(2);
        }
        if (useScope == null) {
            AnnotatedElementsSearcher.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            AnnotatedElementsSearcher.$$$reportNull$$$0(4);
        }
        Collection collection = (Collection)ReadAction.compute(() -> {
            if (useScope == null) {
                AnnotatedElementsSearcher.$$$reportNull$$$0(7);
            }
            if (annClass == null) {
                AnnotatedElementsSearcher.$$$reportNull$$$0(8);
            }
            if (project2 == null) {
                AnnotatedElementsSearcher.$$$reportNull$$$0(9);
            }
            if (useScope instanceof GlobalSearchScope) {
                return JavaAnnotationIndex.getInstance().get(annClass.getName(), project2, (GlobalSearchScope)useScope);
            }
            ArrayList result2 = new ArrayList();
            for (PsiElement element : ((LocalSearchScope)useScope).getScope()) {
                result2.addAll(PsiTreeUtil.findChildrenOfType((PsiElement)element, PsiAnnotation.class));
            }
            return result2;
        });
        if (collection == null) {
            AnnotatedElementsSearcher.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public static boolean isInstanceof(PsiElement owner2, @NotNull Class<? extends PsiModifierListOwner>[] types) {
        if (types == null) {
            AnnotatedElementsSearcher.$$$reportNull$$$0(6);
        }
        for (Class<? extends PsiModifierListOwner> type2 : types) {
            if (!type2.isInstance(owner2)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annClass";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useScope";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/AnnotatedElementsSearcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/AnnotatedElementsSearcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationCandidates";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceof";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAnnotationCandidates$3";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

