/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.impl.search.JavaOverridingMethodsSearcher;
import com.intellij.psi.impl.search.LazyConcurrentCollection;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.Predicate;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class JavaClassInheritorsSearcher
extends QueryExecutorBase<PsiClass, ClassInheritorsSearch.SearchParameters> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQuery(@NotNull ClassInheritorsSearch.SearchParameters parameters2, @NotNull Processor<PsiClass> consumer) {
        if (parameters2 == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(1);
        }
        PsiClass baseClass = parameters2.getClassToProcess();
        assert (parameters2.isCheckDeep());
        assert (parameters2.isCheckInheritance());
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress != null) {
            progress.pushState();
            String className = (String)ReadAction.compute(() -> ((PsiClass)baseClass).getName());
            progress.setText(className != null ? PsiBundle.message((String)"psi.search.inheritors.of.class.progress", (Object[])new Object[]{className}) : PsiBundle.message((String)"psi.search.inheritors.progress", (Object[])new Object[0]));
        }
        try {
            JavaClassInheritorsSearcher.processInheritors(parameters2, consumer);
        }
        finally {
            if (progress != null) {
                progress.popState();
            }
        }
    }

    private static void processInheritors(@NotNull ClassInheritorsSearch.SearchParameters parameters2, @NotNull Processor<PsiClass> consumer) {
        PsiClass baseClass;
        if (parameters2 == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(3);
        }
        if ((baseClass = parameters2.getClassToProcess()) instanceof PsiAnonymousClass || JavaClassInheritorsSearcher.isFinal(baseClass)) {
            return;
        }
        SearchScope searchScope = parameters2.getScope();
        Project project2 = PsiUtilCore.getProjectInReadAction((PsiElement)baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            AllClassesSearch.search((SearchScope)searchScope, (Project)project2, (Condition)parameters2.getNameCondition()).forEach(aClass -> {
                if (consumer == null) {
                    JavaClassInheritorsSearcher.$$$reportNull$$$0(22);
                }
                ProgressManager.checkCanceled();
                return JavaClassInheritorsSearcher.isJavaLangObject(aClass) || consumer.process(aClass);
            });
            return;
        }
        if (searchScope instanceof LocalSearchScope && JavaOverridingMethodsSearcher.isJavaOnlyScope(((LocalSearchScope)searchScope).getVirtualFiles())) {
            JavaClassInheritorsSearcher.processLocalScope(project2, parameters2, (LocalSearchScope)searchScope, baseClass, consumer);
            return;
        }
        Iterable<PsiClass> cached = JavaClassInheritorsSearcher.getOrComputeSubClasses(project2, baseClass, searchScope);
        for (PsiClass subClass : cached) {
            ProgressManager.checkCanceled();
            if (subClass instanceof PsiAnonymousClass && !parameters2.isIncludeAnonymous() || !((Boolean)ReadAction.compute(() -> {
                if (parameters2 == null) {
                    JavaClassInheritorsSearcher.$$$reportNull$$$0(20);
                }
                if (consumer == null) {
                    JavaClassInheritorsSearcher.$$$reportNull$$$0(21);
                }
                return JavaClassInheritorsSearcher.checkCandidate(subClass, parameters2) && !consumer.process((Object)subClass);
            })).booleanValue()) continue;
            return;
        }
    }

    @NotNull
    private static Iterable<PsiClass> getOrComputeSubClasses(@NotNull Project project2, @NotNull PsiClass baseClass, @NotNull SearchScope searchScopeForNonPhysical) {
        ConcurrentMap<PsiClass, Iterable<PsiClass>> map;
        LazyConcurrentCollection<PsiAnchor, PsiClass> cached;
        if (project2 == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(4);
        }
        if (baseClass == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(5);
        }
        if (searchScopeForNonPhysical == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(6);
        }
        if ((cached = (LazyConcurrentCollection<PsiAnchor, PsiClass>)(map = HighlightingCaches.getInstance((Project)project2).ALL_SUB_CLASSES).get(baseClass)) == null) {
            Function converter2 = anchor -> (PsiClass)ReadAction.compute(() -> (PsiClass)anchor.retrieve());
            Predicate applicableFilter = candidate -> !(candidate instanceof PsiAnonymousClass) && candidate != null && !candidate.hasModifierProperty("final");
            boolean isPhysical = (Boolean)ReadAction.compute(() -> ((PsiClass)baseClass).isPhysical());
            SearchScope scopeToUse = isPhysical ? GlobalSearchScope.allScope((Project)project2) : searchScopeForNonPhysical;
            LazyConcurrentCollection.MoreElementsGenerator generator = (candidate, processor2) -> DirectClassInheritorsSearch.search((PsiClass)candidate, (SearchScope)scopeToUse).forEach(subClass -> {
                ProgressManager.checkCanceled();
                PsiAnchor pointer = (PsiAnchor)ReadAction.compute(() -> PsiAnchor.create((PsiElement)subClass));
                processor2.consume((Object)pointer);
                return true;
            });
            PsiAnchor seed = (PsiAnchor)ReadAction.compute(() -> {
                if (baseClass == null) {
                    JavaClassInheritorsSearcher.$$$reportNull$$$0(19);
                }
                return PsiAnchor.create((PsiElement)baseClass);
            });
            LazyConcurrentCollection<PsiAnchor, PsiClass> computed = new LazyConcurrentCollection<PsiAnchor, PsiClass>(seed, converter2, applicableFilter, generator);
            cached = isPhysical ? (Iterable)ConcurrencyUtil.cacheOrGet(map, (Object)baseClass, computed) : computed;
        }
        LazyConcurrentCollection<PsiAnchor, PsiClass> lazyConcurrentCollection = cached;
        if (lazyConcurrentCollection == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(7);
        }
        return lazyConcurrentCollection;
    }

    private static void processLocalScope(final @NotNull Project project2, final @NotNull ClassInheritorsSearch.SearchParameters parameters2, @NotNull LocalSearchScope searchScope, final @NotNull PsiClass baseClass, final @NotNull Processor<PsiClass> consumer) {
        if (project2 == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(8);
        }
        if (parameters2 == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(10);
        }
        if (baseClass == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(12);
        }
        VirtualFile[] virtualFiles = searchScope.getVirtualFiles();
        final boolean[] success = new boolean[]{true};
        for (final VirtualFile virtualFile : virtualFiles) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
                    if (psiFile != null) {
                        psiFile.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                            public void visitClass(PsiClass candidate) {
                                ProgressManager.checkCanceled();
                                if (!success[0]) {
                                    return;
                                }
                                if (candidate.isInheritor(baseClass, true) && JavaClassInheritorsSearcher.checkCandidate(candidate, parameters2) && !consumer.process((Object)candidate)) {
                                    success[0] = false;
                                    return;
                                }
                                super.visitClass(candidate);
                            }
                        });
                    }
                }
            });
        }
    }

    private static boolean checkCandidate(@NotNull PsiClass candidate, @NotNull ClassInheritorsSearch.SearchParameters parameters2) {
        if (candidate == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(13);
        }
        if (parameters2 == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(14);
        }
        SearchScope searchScope = parameters2.getScope();
        ProgressManager.checkCanceled();
        if (!PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)candidate)) {
            return false;
        }
        if (candidate instanceof PsiAnonymousClass) {
            return true;
        }
        String name2 = candidate.getName();
        return name2 != null && parameters2.getNameCondition().value((Object)name2);
    }

    static boolean isJavaLangObject(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(15);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (baseClass == null) {
                JavaClassInheritorsSearcher.$$$reportNull$$$0(18);
            }
            return baseClass.isValid() && "java.lang.Object".equals(baseClass.getQualifiedName());
        });
    }

    private static boolean isFinal(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(16);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (baseClass == null) {
                JavaClassInheritorsSearcher.$$$reportNull$$$0(17);
            }
            return baseClass.hasModifierProperty("final");
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScopeForNonPhysical";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/JavaClassInheritorsSearcher";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/JavaClassInheritorsSearcher";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrComputeSubClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processInheritors";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrComputeSubClasses";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processLocalScope";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkCandidate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isJavaLangObject";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isFinal";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isFinal$10";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isJavaLangObject$9";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOrComputeSubClasses$8";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processInheritors$1";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processInheritors$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

