/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.java.stubs.index.JavaAnonymousClassBaseRefOccurenceIndex;
import com.intellij.psi.impl.java.stubs.index.JavaSuperClassNameOccurenceIndex;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.impl.search.JavaClassInheritorsSearcher;
import com.intellij.psi.impl.search.StubHierarchyInheritorSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class JavaDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters parameters2, @NotNull Processor<PsiClass> consumer) {
        SearchScope useScope;
        SearchScope scope;
        if (parameters2 == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(1);
        }
        PsiClass baseClass = JavaDirectInheritorsSearcher.getClassToSearch(parameters2);
        assert (parameters2.isCheckInheritance());
        Project project2 = PsiUtilCore.getProjectInReadAction((PsiElement)baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            SearchScope useScope2 = (SearchScope)ReadAction.compute(() -> ((PsiClass)baseClass).getUseScope());
            return AllClassesSearch.search((SearchScope)useScope2, (Project)project2).forEach(psiClass -> {
                if (consumer == null) {
                    JavaDirectInheritorsSearcher.$$$reportNull$$$0(40);
                }
                ProgressManager.checkCanceled();
                if (psiClass.isInterface()) {
                    return consumer.process(psiClass);
                }
                PsiClass superClass = psiClass.getSuperClass();
                return superClass == null || !JavaClassInheritorsSearcher.isJavaLangObject(superClass) || consumer.process(psiClass);
            });
        }
        CompilerDirectHierarchyInfo info = JavaDirectInheritorsSearcher.performSearchUsingCompilerIndices(parameters2, parameters2.getScope(), project2);
        if (info == null) {
            scope = parameters2.getScope();
            useScope = (SearchScope)ReadAction.compute(() -> ((PsiClass)baseClass).getUseScope());
        } else {
            if (!JavaDirectInheritorsSearcher.processInheritorCandidates(info.getHierarchyChildren(), consumer, parameters2.includeAnonymous())) {
                return false;
            }
            scope = (SearchScope)ReadAction.compute(() -> {
                if (parameters2 == null) {
                    JavaDirectInheritorsSearcher.$$$reportNull$$$0(39);
                }
                return parameters2.getScope().intersectWith((SearchScope)info.getDirtyScope());
            });
            useScope = (SearchScope)ReadAction.compute(() -> baseClass.getUseScope().intersectWith((SearchScope)info.getDirtyScope()));
        }
        PsiClass[] cache = JavaDirectInheritorsSearcher.getOrCalculateDirectSubClasses(project2, baseClass, useScope);
        if (cache.length == 0) {
            return true;
        }
        VirtualFile baseClassJarFile = null;
        int groupStart = 0;
        boolean sameJarClassFound = false;
        String currentFQN = null;
        boolean[] isOutOfScope = new boolean[cache.length];
        for (int i = 0; i <= cache.length; ++i) {
            String fqn;
            PsiClass subClass;
            ProgressManager.checkCanceled();
            PsiClass psiClass2 = subClass = i == cache.length ? null : cache[i];
            if (subClass instanceof PsiAnonymousClass && !parameters2.includeAnonymous()) {
                return true;
            }
            if (i != cache.length && !JavaDirectInheritorsSearcher.isInScope(scope, subClass)) {
                isOutOfScope[i] = true;
                continue;
            }
            String string = fqn = i == cache.length ? null : (String)ReadAction.compute(() -> ((PsiClass)subClass).getQualifiedName());
            if (currentFQN != null && Comparing.equal((String)fqn, (String)currentFQN)) {
                boolean fromSameJar;
                VirtualFile currentJarFile = JavaDirectInheritorsSearcher.getJarFile(subClass);
                if (baseClassJarFile == null) {
                    baseClassJarFile = JavaDirectInheritorsSearcher.getJarFile(baseClass);
                }
                if (!(fromSameJar = Comparing.equal((Object)currentJarFile, (Object)baseClassJarFile))) continue;
                if (!consumer.process((Object)subClass)) {
                    return false;
                }
                sameJarClassFound = true;
                continue;
            }
            currentFQN = fqn;
            if (!sameJarClassFound) {
                for (int g = groupStart; g < i; ++g) {
                    PsiClass subClassCandidate;
                    ProgressManager.checkCanceled();
                    if (isOutOfScope[g] || consumer.process((Object)(subClassCandidate = cache[g]))) continue;
                    return false;
                }
            }
            groupStart = i;
            sameJarClassFound = false;
        }
        return true;
    }

    private static PsiClass getClassToSearch(@NotNull DirectClassInheritorsSearch.SearchParameters parameters2) {
        if (parameters2 == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(2);
        }
        return (PsiClass)ReadAction.compute(() -> {
            if (parameters2 == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(38);
            }
            return (PsiClass)PsiUtil.preferCompiledElement((PsiModifierListOwner)parameters2.getClassToProcess());
        });
    }

    private static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiClass subClass) {
        if (scope == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(3);
        }
        if (subClass == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(4);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (scope == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(36);
            }
            if (subClass == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(37);
            }
            return PsiSearchScopeUtil.isInScope((SearchScope)scope, (PsiElement)subClass);
        });
    }

    @NotNull
    private static PsiClass[] getOrCalculateDirectSubClasses(@NotNull Project project2, @NotNull PsiClass baseClass, @NotNull SearchScope useScope) {
        ConcurrentMap<PsiClass, PsiClass[]> map;
        PsiClass[] cache;
        if (project2 == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(5);
        }
        if (baseClass == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(6);
        }
        if (useScope == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(7);
        }
        if ((cache = (PsiClass[])(map = HighlightingCaches.getInstance((Project)project2).DIRECT_SUB_CLASSES).get(baseClass)) != null) {
            if (cache == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(8);
            }
            return cache;
        }
        String baseClassName = (String)ReadAction.compute(() -> ((PsiClass)baseClass).getName());
        if (StringUtil.isEmpty((String)baseClassName)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(9);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        cache = JavaDirectInheritorsSearcher.calculateDirectSubClasses(project2, baseClass, baseClassName, useScope);
        if (((Boolean)ReadAction.compute(() -> ((PsiClass)baseClass).isPhysical())).booleanValue()) {
            cache = (PsiClass[])ConcurrencyUtil.cacheOrGet(map, (Object)baseClass, (Object)cache);
        }
        if (cache == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(10);
        }
        return cache;
    }

    private static <T> boolean processConcurrentlyIfTooMany(@NotNull Collection<T> collection, @NotNull Processor<? super T> processor2) {
        int size;
        if (collection == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(11);
        }
        if (processor2 == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(12);
        }
        if ((size = collection.size()) == 0) {
            return true;
        }
        if (size > 100) {
            return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<T>(collection), ProgressIndicatorProvider.getGlobalProgressIndicator(), true, processor2);
        }
        return ContainerUtil.process(collection, processor2);
    }

    @NotNull
    private static PsiClass[] calculateDirectSubClasses(@NotNull Project project2, @NotNull PsiClass baseClass, @NotNull String baseClassName, @NotNull SearchScope useScope) {
        if (project2 == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(13);
        }
        if (baseClass == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(14);
        }
        if (baseClassName == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(15);
        }
        if (useScope == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(16);
        }
        DumbService dumbService = DumbService.getInstance((Project)project2);
        GlobalSearchScope globalUseScope = (GlobalSearchScope)dumbService.runReadActionInSmartMode(() -> {
            if (useScope == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(34);
            }
            if (project2 == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(35);
            }
            return StubHierarchyInheritorSearcher.restrictScope(GlobalSearchScopeUtil.toGlobalSearchScope(useScope, project2));
        });
        Collection candidates = (Collection)dumbService.runReadActionInSmartMode(() -> {
            if (baseClassName == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(32);
            }
            if (project2 == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(33);
            }
            return JavaSuperClassNameOccurenceIndex.getInstance().get(baseClassName, project2, globalUseScope);
        });
        HashMap classesWithFqn = new HashMap();
        JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(candidates, arg_0 -> JavaDirectInheritorsSearcher.lambda$calculateDirectSubClasses$8(baseClass, (Map)classesWithFqn, arg_0));
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (Object value2 : classesWithFqn.values()) {
            if (value2 instanceof PsiClass) {
                result2.add((PsiClass)value2);
                continue;
            }
            List list2 = (List)value2;
            result2.addAll(list2);
        }
        Collection anonymousCandidates = (Collection)dumbService.runReadActionInSmartMode(() -> {
            if (baseClassName == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(28);
            }
            if (project2 == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(29);
            }
            return JavaAnonymousClassBaseRefOccurenceIndex.getInstance().get(baseClassName, project2, globalUseScope);
        });
        JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(anonymousCandidates, candidate -> {
            boolean isInheritor;
            if (baseClass == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(26);
            }
            if (isInheritor = ((Boolean)dumbService.runReadActionInSmartMode(() -> {
                if (baseClass == null) {
                    JavaDirectInheritorsSearcher.$$$reportNull$$$0(27);
                }
                return candidate.isInheritor(baseClass, false);
            })).booleanValue()) {
                List list2 = result2;
                synchronized (list2) {
                    result2.add(candidate);
                }
            }
            return true;
        });
        boolean isEnum = (Boolean)ReadAction.compute(() -> ((PsiClass)baseClass).isEnum());
        if (isEnum) {
            PsiField[] fields;
            for (PsiField field : fields = (PsiField[])ReadAction.compute(() -> ((PsiClass)baseClass).getFields())) {
                ProgressManager.checkCanceled();
                if (!(field instanceof PsiEnumConstant)) continue;
                PsiEnumConstantInitializer initializingClass2 = (PsiEnumConstantInitializer)ReadAction.compute(() -> ((PsiEnumConstant)((PsiEnumConstant)field)).getInitializingClass());
                if (initializingClass2 == null) continue;
                result2.add(initializingClass2);
            }
        }
        PsiClass[] psiClassArray = result2.isEmpty() ? PsiClass.EMPTY_ARRAY : result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(17);
        }
        return psiClassArray;
    }

    private static VirtualFile getJarFile(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(18);
        }
        return (VirtualFile)ReadAction.compute(() -> {
            if (aClass == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(25);
            }
            return PsiUtil.getJarFile((PsiElement)aClass);
        });
    }

    private static CompilerDirectHierarchyInfo performSearchUsingCompilerIndices(@NotNull DirectClassInheritorsSearch.SearchParameters parameters2, @NotNull SearchScope useScope, @NotNull Project project2) {
        if (parameters2 == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(19);
        }
        if (useScope == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(20);
        }
        if (project2 == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(21);
        }
        if (!(useScope instanceof GlobalSearchScope)) {
            return null;
        }
        SearchScope scope = parameters2.getScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return null;
        }
        CompilerReferenceService compilerReferenceService = CompilerReferenceService.getInstance(project2);
        return compilerReferenceService.getDirectInheritors((PsiNamedElement)JavaDirectInheritorsSearcher.getClassToSearch(parameters2), (GlobalSearchScope)useScope, (GlobalSearchScope)scope, (FileType)JavaFileType.INSTANCE);
    }

    private static boolean processInheritorCandidates(@NotNull Stream<PsiElement> classStream, @NotNull Processor<PsiClass> consumer, boolean acceptAnonymous) {
        if (classStream == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(22);
        }
        if (consumer == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(23);
        }
        if (!acceptAnonymous) {
            classStream = classStream.filter(c -> !(c instanceof PsiAnonymousClass));
        }
        return ContainerUtil.process(classStream.iterator(), e -> {
            if (consumer == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(24);
            }
            ProgressManager.checkCanceled();
            PsiClass c = (PsiClass)e;
            return consumer.process((Object)c);
        });
    }

    private static /* synthetic */ boolean lambda$calculateDirectSubClasses$8(@NotNull PsiClass baseClass, Map classesWithFqn, PsiReferenceList referenceList) {
        if (baseClass == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(30);
        }
        ProgressManager.checkCanceled();
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass candidate;
            boolean isInheritor;
            if (baseClass == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(31);
            }
            if (isInheritor = (candidate = (PsiClass)referenceList.getParent()).isInheritor(baseClass, false)) {
                String fqn = candidate.getQualifiedName();
                Map map = classesWithFqn;
                synchronized (map) {
                    Object value2 = classesWithFqn.get(fqn);
                    if (value2 == null) {
                        classesWithFqn.put(fqn, candidate);
                    } else if (value2 instanceof PsiClass) {
                        ArrayList<PsiClass> list2 = new ArrayList<PsiClass>();
                        list2.add((PsiClass)value2);
                        list2.add(candidate);
                        classesWithFqn.put(fqn, list2);
                    } else {
                        List list3 = (List)value2;
                        list3.add(candidate);
                    }
                }
            }
        });
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 23: 
            case 24: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 5: 
            case 13: 
            case 21: 
            case 29: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 14: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 7: 
            case 16: 
            case 20: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useScope";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 15: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassName";
                break;
            }
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCalculateDirectSubClasses";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDirectSubClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClassToSearch";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCalculateDirectSubClasses";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processConcurrentlyIfTooMany";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calculateDirectSubClasses";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getJarFile";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "performSearchUsingCompilerIndices";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processInheritorCandidates";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processInheritorCandidates$14";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getJarFile$12";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calculateDirectSubClasses$11";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$10";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calculateDirectSubClasses$9";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calculateDirectSubClasses$8";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$7";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calculateDirectSubClasses$6";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calculateDirectSubClasses$5";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isInScope$4";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getClassToSearch$3";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$1";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

