/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.java.FunExprOccurrence;
import com.intellij.psi.impl.java.JavaFunctionalExpressionIndex;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionKey;
import com.intellij.psi.impl.java.stubs.index.JavaMethodParameterTypesIndex;
import com.intellij.psi.impl.search.ApproximateResolver;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFunctionalExpressionSearcher
extends QueryExecutorBase<PsiFunctionalExpression, FunctionalExpressionSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.JavaFunctionalExpressionSearcher");
    public static final int SMART_SEARCH_THRESHOLD = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQuery(@NotNull FunctionalExpressionSearch.SearchParameters p, @NotNull Processor<PsiFunctionalExpression> consumer) {
        if (p == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(1);
        }
        List<SamDescriptor> descriptors = JavaFunctionalExpressionSearcher.calcDescriptors(p);
        Project project2 = PsiUtilCore.getProjectInReadAction((PsiElement)p.getElementToSearch());
        if (project2 == null) {
            return;
        }
        SearchScope searchScope = (SearchScope)ReadAction.compute(() -> {
            if (p == null) {
                JavaFunctionalExpressionSearcher.$$$reportNull$$$0(23);
            }
            return p.getEffectiveSearchScope();
        });
        if (searchScope instanceof GlobalSearchScope && !JavaFunctionalExpressionSearcher.performSearchUsingCompilerIndices(descriptors, (GlobalSearchScope)searchScope, project2, consumer)) {
            return;
        }
        AtomicInteger exprCount = new AtomicInteger();
        AtomicInteger fileCount = new AtomicInteger();
        PsiManager manager = (PsiManager)ReadAction.compute(() -> {
            if (p == null) {
                JavaFunctionalExpressionSearcher.$$$reportNull$$$0(22);
            }
            return p.getElementToSearch().getManager();
        });
        manager.startBatchFilesProcessingMode();
        try {
            JavaFunctionalExpressionSearcher.processOffsets(descriptors, project2, (PairProcessor<VirtualFile, List<Integer>>)((PairProcessor)(file2, offsets) -> {
                if (consumer == null) {
                    JavaFunctionalExpressionSearcher.$$$reportNull$$$0(21);
                }
                fileCount.incrementAndGet();
                exprCount.addAndGet(offsets.size());
                return JavaFunctionalExpressionSearcher.processFile(consumer, descriptors, file2, offsets);
            }));
        }
        finally {
            manager.finishBatchFilesProcessingMode();
        }
        if (exprCount.get() > 0) {
            LOG.debug("Loaded " + exprCount.get() + " fun-expressions in " + fileCount.get() + " files");
        }
    }

    public static Set<VirtualFile> getFilesToSearchInPsi(PsiClass samClass) {
        HashSet result2 = new HashSet();
        JavaFunctionalExpressionSearcher.processOffsets(JavaFunctionalExpressionSearcher.calcDescriptors(new FunctionalExpressionSearch.SearchParameters(samClass, samClass.getUseScope())), samClass.getProject(), (PairProcessor<VirtualFile, List<Integer>>)((PairProcessor)(arg_0, arg_1) -> JavaFunctionalExpressionSearcher.lambda$getFilesToSearchInPsi$3((Set)result2, arg_0, arg_1)));
        return result2;
    }

    @NotNull
    private static List<SamDescriptor> calcDescriptors(@NotNull FunctionalExpressionSearch.SearchParameters queryParameters) {
        if (queryParameters == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(2);
        }
        ArrayList<SamDescriptor> descriptors = new ArrayList<SamDescriptor>();
        ReadAction.run(() -> {
            PsiClass aClass;
            if (queryParameters == null) {
                JavaFunctionalExpressionSearcher.$$$reportNull$$$0(20);
            }
            if (!(aClass = queryParameters.getElementToSearch()).isValid() || !aClass.isInterface()) {
                return;
            }
            Project project2 = aClass.getProject();
            if (InjectedLanguageManager.getInstance((Project)project2).isInjectedFragment(aClass.getContainingFile()) || !JavaFunctionalExpressionSearcher.hasJava8Modules(project2)) {
                return;
            }
            for (PsiClass samClass : JavaFunctionalExpressionSearcher.processSubInterfaces(aClass)) {
                PsiMethod saMethod;
                PsiType samType;
                if (!LambdaUtil.isFunctionalClass((PsiClass)samClass) || (samType = (saMethod = (PsiMethod)ObjectUtils.assertNotNull((Object)LambdaUtil.getFunctionalInterfaceMethod((PsiClass)samClass))).getReturnType()) == null) continue;
                SearchScope scope = samClass.getUseScope().intersectWith(queryParameters.getEffectiveSearchScope());
                descriptors.add(new SamDescriptor(samClass, saMethod, samType, GlobalSearchScopeUtil.toGlobalSearchScope(scope, project2)));
            }
        });
        ArrayList<SamDescriptor> arrayList = descriptors;
        if (arrayList == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private static Set<VirtualFile> getLikelyFiles(List<SamDescriptor> descriptors, Collection<VirtualFile> candidateFiles, Project project2) {
        GlobalSearchScope candidateFilesScope = GlobalSearchScope.filesScope((Project)project2, candidateFiles);
        Set set2 = JBIterable.from(descriptors).flatMap(descriptor2 -> ((SamDescriptor)descriptor2).getMostLikelyFiles(candidateFilesScope)).toSet();
        if (set2 == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(4);
        }
        return set2;
    }

    @NotNull
    private static MultiMap<VirtualFile, FunExprOccurrence> getAllOccurrences(List<SamDescriptor> descriptors) {
        MultiMap result2 = MultiMap.createLinkedSet();
        for (SamDescriptor descriptor2 : descriptors) {
            descriptor2.dumbService.runReadActionInSmartMode(() -> {
                for (FunctionalExpressionKey key2 : descriptor2.generateKeys()) {
                    FileBasedIndex.getInstance().processValues(JavaFunctionalExpressionIndex.INDEX_ID, (Object)key2, null, (file2, infos) -> {
                        ProgressManager.checkCanceled();
                        result2.putValues((Object)file2, (Collection)infos);
                        return true;
                    }, (GlobalSearchScope)new JavaSourceFilterScope(descriptor2.effectiveUseScope));
                }
            });
        }
        LOG.debug("Found " + result2.values().size() + " fun-expressions in " + result2.keySet().size() + " files");
        MultiMap multiMap = result2;
        if (multiMap == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(5);
        }
        return multiMap;
    }

    private static void processOffsets(List<SamDescriptor> descriptors, Project project2, PairProcessor<VirtualFile, List<Integer>> processor2) {
        if (descriptors.isEmpty()) {
            return;
        }
        List samClasses = ContainerUtil.map(descriptors, d -> d.samClass);
        MultiMap<VirtualFile, FunExprOccurrence> allCandidates = JavaFunctionalExpressionSearcher.getAllOccurrences(descriptors);
        if (allCandidates.isEmpty()) {
            return;
        }
        for (VirtualFile vFile : JavaFunctionalExpressionSearcher.putLikelyFilesFirst(descriptors, allCandidates.keySet(), project2)) {
            List<FunExprOccurrence> toLoad = JavaFunctionalExpressionSearcher.filterInapplicable(samClasses, vFile, allCandidates.get((Object)vFile), project2);
            if (toLoad.isEmpty()) continue;
            LOG.trace("To load " + vFile.getPath() + " with values: " + toLoad);
            if (processor2.process((Object)vFile, (Object)ContainerUtil.map(toLoad, it -> it.funExprOffset))) continue;
            return;
        }
    }

    @NotNull
    private static Set<VirtualFile> putLikelyFilesFirst(List<SamDescriptor> descriptors, Set<VirtualFile> allFiles, Project project2) {
        LinkedHashSet<VirtualFile> orderedFiles = new LinkedHashSet<VirtualFile>(allFiles.size());
        orderedFiles.addAll(JavaFunctionalExpressionSearcher.getLikelyFiles(descriptors, allFiles, project2));
        orderedFiles.addAll(allFiles);
        LinkedHashSet<VirtualFile> linkedHashSet = orderedFiles;
        if (linkedHashSet == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    @NotNull
    private static List<FunExprOccurrence> filterInapplicable(List<PsiClass> samClasses, VirtualFile vFile, Collection<FunExprOccurrence> occurrences, Project project2) {
        List list2 = (List)DumbService.getInstance((Project)project2).runReadActionInSmartMode(() -> project2.isDisposed() ? Collections.emptyList() : ContainerUtil.filter((Collection)occurrences, it -> it.canHaveType(samClasses, vFile)));
        if (list2 == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(7);
        }
        return list2;
    }

    private static boolean processFile(@NotNull Processor<PsiFunctionalExpression> consumer, List<SamDescriptor> descriptors, VirtualFile vFile, Collection<Integer> offsets) {
        if (consumer == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(8);
        }
        return (Boolean)ReadAction.compute(() -> {
            PsiFile file2;
            if (consumer == null) {
                JavaFunctionalExpressionSearcher.$$$reportNull$$$0(19);
            }
            if (!((file2 = ((SamDescriptor)descriptors.get((int)0)).samClass.getManager().findFile(vFile)) instanceof PsiJavaFile)) {
                LOG.error("Non-java file " + file2 + "; " + vFile);
                return true;
            }
            for (Integer offset : offsets) {
                PsiFunctionalExpression expression2 = (PsiFunctionalExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)offset, PsiFunctionalExpression.class, (boolean)false);
                if (expression2 == null || expression2.getTextRange().getStartOffset() != offset.intValue()) {
                    LOG.error("Fun expression not found in " + file2 + " at " + offset);
                    continue;
                }
                if (!JavaFunctionalExpressionSearcher.hasType(descriptors, expression2) || consumer.process((Object)expression2)) continue;
                return false;
            }
            return true;
        });
    }

    private static boolean hasType(List<SamDescriptor> descriptors, PsiFunctionalExpression expression2) {
        if (!JavaFunctionalExpressionSearcher.canHaveType(expression2, ContainerUtil.map(descriptors, d -> d.samClass))) {
            return false;
        }
        PsiClass actualClass = PsiUtil.resolveClassInType((PsiType)expression2.getFunctionalInterfaceType());
        return ContainerUtil.exists(descriptors, d -> InheritanceUtil.isInheritorOrSelf((PsiClass)actualClass, (PsiClass)d.samClass, (boolean)true));
    }

    private static boolean canHaveType(PsiFunctionalExpression expression2, List<PsiClass> samClasses) {
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiMethodCallExpression) {
            PsiExpression[] args = ((PsiExpressionList)parent).getExpressions();
            int argIndex = Arrays.asList(args).indexOf(expression2);
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)parent.getParent()).getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            String methodName = methodExpression.getReferenceName();
            if (qualifier != null && methodName != null && argIndex >= 0) {
                Set<PsiClass> approximateTypes = ApproximateResolver.getPossibleTypes(qualifier, 10);
                List<PsiMethod> methods = approximateTypes == null ? null : ApproximateResolver.getPossibleMethods(approximateTypes, methodName, args.length);
                return methods == null || ContainerUtil.exists(methods, m -> FunExprOccurrence.hasCompatibleParameter(m, argIndex, samClasses));
            }
        }
        return true;
    }

    private static boolean hasJava8Modules(Project project2) {
        boolean projectLevelIsHigh = PsiUtil.getLanguageLevel((Project)project2).isAtLeast(LanguageLevel.JDK_1_8);
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            LanguageLevel level;
            LanguageLevelModuleExtension extension = (LanguageLevelModuleExtension)ModuleRootManager.getInstance((Module)module2).getModuleExtension(LanguageLevelModuleExtension.class);
            if (extension == null || ((level = extension.getLanguageLevel()) != null || !projectLevelIsHigh) && (level == null || !level.isAtLeast(LanguageLevel.JDK_1_8))) continue;
            return true;
        }
        return false;
    }

    private static Set<PsiClass> processSubInterfaces(PsiClass base) {
        HashSet result2 = new HashSet();
        new Object((Set)result2){
            final /* synthetic */ Set val$result;
            {
                this.val$result = set2;
            }

            void visit(PsiClass c) {
                if (!this.val$result.add(c)) {
                    return;
                }
                DirectClassInheritorsSearch.search((PsiClass)c).forEach(candidate -> {
                    if (candidate.isInterface()) {
                        this.visit((PsiClass)candidate);
                    }
                    return true;
                });
            }
        }.visit(base);
        return result2;
    }

    private static boolean performSearchUsingCompilerIndices(@NotNull List<SamDescriptor> descriptors, @NotNull GlobalSearchScope searchScope, @NotNull Project project2, @NotNull Processor<PsiFunctionalExpression> consumer) {
        if (descriptors == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(10);
        }
        if (project2 == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(12);
        }
        CompilerReferenceService compilerReferenceService = CompilerReferenceService.getInstance(project2);
        for (SamDescriptor descriptor2 : descriptors) {
            if (JavaFunctionalExpressionSearcher.processFunctionalExpressions(JavaFunctionalExpressionSearcher.performSearchUsingCompilerIndices(descriptor2, searchScope, compilerReferenceService), descriptor2, consumer)) continue;
            return false;
        }
        return true;
    }

    private static CompilerDirectHierarchyInfo performSearchUsingCompilerIndices(@NotNull SamDescriptor descriptor2, @NotNull GlobalSearchScope searchScope, @NotNull CompilerReferenceService service) {
        if (descriptor2 == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(13);
        }
        if (searchScope == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(14);
        }
        if (service == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(15);
        }
        return service.getFunExpressions((PsiNamedElement)descriptor2.samClass, descriptor2.effectiveUseScope, searchScope, (FileType)JavaFileType.INSTANCE);
    }

    private static boolean processFunctionalExpressions(@Nullable CompilerDirectHierarchyInfo funExprInfo, @NotNull SamDescriptor descriptor2, @NotNull Processor<PsiFunctionalExpression> consumer) {
        if (descriptor2 == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(16);
        }
        if (consumer == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(17);
        }
        if (funExprInfo != null) {
            if (!ContainerUtil.process(funExprInfo.getHierarchyChildren().iterator(), fe -> {
                if (consumer == null) {
                    JavaFunctionalExpressionSearcher.$$$reportNull$$$0(18);
                }
                return consumer.process((Object)((PsiFunctionalExpression)fe));
            })) {
                return false;
            }
            GlobalSearchScope dirtyScope = funExprInfo.getDirtyScope();
            descriptor2.effectiveUseScope = descriptor2.effectiveUseScope.intersectWith(dirtyScope);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getFilesToSearchInPsi$3(Set result2, VirtualFile file2, List offsets) {
        return result2.add(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLikelyFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOccurrences";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "putLikelyFilesFirst";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "filterInapplicable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processQuery";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcDescriptors";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "performSearchUsingCompilerIndices";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processFunctionalExpressions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processFunctionalExpressions$16";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processFile$12";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calcDescriptors$4";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processQuery$2";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processQuery$1";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processQuery$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SamDescriptor {
        final PsiClass samClass;
        final int samParamCount;
        final boolean booleanCompatible;
        final boolean isVoid;
        final DumbService dumbService;
        GlobalSearchScope effectiveUseScope;

        SamDescriptor(PsiClass samClass, PsiMethod samMethod, PsiType samType, GlobalSearchScope useScope) {
            this.samClass = samClass;
            this.effectiveUseScope = useScope;
            this.samParamCount = samMethod.getParameterList().getParametersCount();
            this.booleanCompatible = FunctionalExpressionKey.isBooleanCompatible(samType);
            this.isVoid = PsiType.VOID.equals((Object)samType);
            this.dumbService = DumbService.getInstance((Project)samClass.getProject());
        }

        List<FunctionalExpressionKey> generateKeys() {
            String name2;
            String string = name2 = this.samClass.isValid() ? this.samClass.getName() : null;
            if (name2 == null) {
                return Collections.emptyList();
            }
            ArrayList<FunctionalExpressionKey> result2 = new ArrayList<FunctionalExpressionKey>();
            for (String lambdaType : new String[]{(String)ObjectUtils.assertNotNull((Object)name2), ""}) {
                for (int lambdaParamCount : new int[]{-1, this.samParamCount}) {
                    result2.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.UNKNOWN, lambdaType));
                    if (this.isVoid) {
                        result2.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.VOID, lambdaType));
                        continue;
                    }
                    if (this.booleanCompatible) {
                        result2.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.BOOLEAN, lambdaType));
                    }
                    result2.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.NON_VOID, lambdaType));
                }
            }
            return result2;
        }

        @NotNull
        private Set<VirtualFile> getMostLikelyFiles(GlobalSearchScope searchScope) {
            LinkedHashSet files = ContainerUtil.newLinkedHashSet();
            this.dumbService.runReadActionInSmartMode(() -> {
                if (!this.samClass.isValid()) {
                    return;
                }
                String className = this.samClass.getName();
                Project project2 = this.samClass.getProject();
                if (className == null) {
                    return;
                }
                LinkedHashSet likelyNames = ContainerUtil.newLinkedHashSet((Object[])new String[]{className});
                StubIndex.getInstance().processElements(JavaMethodParameterTypesIndex.getInstance().getKey(), (Object)className, project2, this.effectiveUseScope, PsiMethod.class, method -> {
                    ProgressManager.checkCanceled();
                    likelyNames.add(method.getName());
                    return true;
                });
                PsiSearchHelperImpl helper = (PsiSearchHelperImpl)PsiSearchHelper.SERVICE.getInstance((Project)project2);
                Processor processor2 = Processors.cancelableCollectProcessor((Collection)files);
                for (String word : likelyNames) {
                    helper.processFilesWithText(searchScope, (short)1, true, word, (Processor<VirtualFile>)processor2);
                }
            });
            LinkedHashSet linkedHashSet = files;
            if (linkedHashSet == null) {
                SamDescriptor.$$$reportNull$$$0(0);
            }
            return linkedHashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher$SamDescriptor", "getMostLikelyFiles"));
        }
    }
}

