/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.psi.jsp.JavaJspRecursiveElementVisitor;
import com.intellij.psi.jsp.JspFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class BraceEnforcer
extends JavaJspRecursiveElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.BraceEnforcer");
    private final PostFormatProcessorHelper myPostProcessor;

    public BraceEnforcer(CodeStyleSettings settings) {
        this.myPostProcessor = new PostFormatProcessorHelper(settings.getCommonSettings((Language)JavaLanguage.INSTANCE));
    }

    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        this.visitElement((PsiElement)expression2);
    }

    public void visitIfStatement(PsiIfStatement statement2) {
        if (this.checkElementContainsRange((PsiElement)statement2)) {
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)statement2.getProject()).createSmartPsiElementPointer((PsiElement)statement2);
            super.visitIfStatement(statement2);
            statement2 = (PsiIfStatement)pointer.getElement();
            if (statement2 == null) {
                return;
            }
            this.processStatement((PsiStatement)statement2, statement2.getThenBranch(), this.myPostProcessor.getSettings().IF_BRACE_FORCE);
            PsiStatement elseBranch = statement2.getElseBranch();
            if (!(elseBranch instanceof PsiIfStatement) || !this.myPostProcessor.getSettings().SPECIAL_ELSE_IF_TREATMENT) {
                this.processStatement((PsiStatement)statement2, elseBranch, this.myPostProcessor.getSettings().IF_BRACE_FORCE);
            }
        }
    }

    public void visitForStatement(PsiForStatement statement2) {
        if (this.checkElementContainsRange((PsiElement)statement2)) {
            super.visitForStatement(statement2);
            this.processStatement((PsiStatement)statement2, statement2.getBody(), this.myPostProcessor.getSettings().FOR_BRACE_FORCE);
        }
    }

    public void visitForeachStatement(PsiForeachStatement statement2) {
        if (this.checkElementContainsRange((PsiElement)statement2)) {
            super.visitForeachStatement(statement2);
            this.processStatement((PsiStatement)statement2, statement2.getBody(), this.myPostProcessor.getSettings().FOR_BRACE_FORCE);
        }
    }

    public void visitWhileStatement(PsiWhileStatement statement2) {
        if (this.checkElementContainsRange((PsiElement)statement2)) {
            super.visitWhileStatement(statement2);
            this.processStatement((PsiStatement)statement2, statement2.getBody(), this.myPostProcessor.getSettings().WHILE_BRACE_FORCE);
        }
    }

    public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
        if (this.checkElementContainsRange((PsiElement)statement2)) {
            super.visitDoWhileStatement(statement2);
            this.processStatement((PsiStatement)statement2, statement2.getBody(), this.myPostProcessor.getSettings().DOWHILE_BRACE_FORCE);
        }
    }

    public void visitJspFile(JspFile file2) {
        PsiClass javaRoot = file2.getJavaClass();
        if (javaRoot != null) {
            javaRoot.accept((PsiElementVisitor)this);
        }
    }

    private void processStatement(PsiStatement statement2, PsiStatement blockCandidate, int options) {
        if (blockCandidate instanceof PsiBlockStatement || blockCandidate == null) {
            return;
        }
        if (options == 3 || options == 1 && PostFormatProcessorHelper.isMultiline((PsiElement)statement2)) {
            this.replaceWithBlock(statement2, blockCandidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceWithBlock(@NotNull PsiStatement statement2, PsiStatement blockCandidate) {
        if (statement2 == null) {
            BraceEnforcer.$$$reportNull$$$0(0);
        }
        if (!statement2.isValid()) {
            LOG.assertTrue(false);
        }
        if (!this.checkRangeContainsElement((PsiElement)blockCandidate)) {
            return;
        }
        PsiManager manager = statement2.getManager();
        LOG.assertTrue(manager != null);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        String oldText = blockCandidate.getText();
        int lastLineFeedIndex = oldText.lastIndexOf("\n");
        lastLineFeedIndex = Math.max(0, lastLineFeedIndex);
        int lastLineCommentIndex = oldText.indexOf("//", lastLineFeedIndex);
        StringBuilder buf = new StringBuilder(oldText.length() + 5);
        buf.append("{ ").append(oldText);
        if (lastLineCommentIndex >= 0) {
            buf.append("\n");
        }
        buf.append(" }");
        int oldTextLength = statement2.getTextLength();
        try {
            CodeEditUtil.replaceChild(SourceTreeToPsiMap.psiElementToTree((PsiElement)statement2), SourceTreeToPsiMap.psiElementToTree((PsiElement)blockCandidate), SourceTreeToPsiMap.psiElementToTree((PsiElement)factory.createStatementFromText(buf.toString(), null)));
            CodeStyleManager.getInstance((Project)statement2.getProject()).reformat((PsiElement)statement2, true);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.updateResultRange(oldTextLength, statement2.getTextLength());
        }
    }

    protected void updateResultRange(int oldTextLength, int newTextLength) {
        this.myPostProcessor.updateResultRange(oldTextLength, newTextLength);
    }

    protected boolean checkElementContainsRange(PsiElement element) {
        return this.myPostProcessor.isElementPartlyInRange(element);
    }

    protected boolean checkRangeContainsElement(PsiElement element) {
        return this.myPostProcessor.isElementFullyInRange(element);
    }

    public PsiElement process(PsiElement formatted) {
        LOG.assertTrue(formatted.isValid());
        formatted.accept((PsiElementVisitor)this);
        return formatted;
    }

    public TextRange processText(PsiFile source, TextRange rangeToReformat) {
        this.myPostProcessor.setResultTextRange(rangeToReformat);
        source.accept((PsiElementVisitor)this);
        return this.myPostProcessor.getResultTextRange();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/psi/impl/source/codeStyle/BraceEnforcer", "replaceWithBlock"));
    }
}

