/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.PsiBasedFormattingModel;
import com.intellij.psi.impl.source.codeStyle.ShiftIndentInsideHelper;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class PsiBasedFormatterModelWithShiftIndentInside
extends PsiBasedFormattingModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.PsiBasedFormatterModelWithShiftIndentInside");
    private final Project myProject;

    public PsiBasedFormatterModelWithShiftIndentInside(PsiFile file2, @NotNull Block rootBlock, FormattingDocumentModelImpl documentModel) {
        if (rootBlock == null) {
            PsiBasedFormatterModelWithShiftIndentInside.$$$reportNull$$$0(0);
        }
        super(file2, rootBlock, documentModel);
        this.myProject = file2.getProject();
    }

    @Override
    public TextRange shiftIndentInsideRange(ASTNode node, TextRange textRange, int shift) {
        return this.shiftIndentInsideWithPsi(node, textRange, shift);
    }

    private TextRange shiftIndentInsideWithPsi(ASTNode node, TextRange textRange, int shift) {
        if (node != null && node.getTextRange().equals((Object)textRange) && ShiftIndentInsideHelper.mayShiftIndentInside(node)) {
            return new ShiftIndentInsideHelper((FileType)StdFileTypes.JAVA, this.myProject).shiftIndentInside(node, shift).getTextRange();
        }
        return textRange;
    }

    @Override
    protected String replaceWithPsiInLeaf(TextRange textRange, String whiteSpace, ASTNode leafElement) {
        if (!this.myCanModifyAllWhiteSpaces) {
            if (leafElement.getElementType() == TokenType.WHITE_SPACE) {
                return null;
            }
            ASTNode prevNode = TreeUtil.prevLeaf(leafElement);
            if (prevNode != null) {
                IElementType type2 = prevNode.getElementType();
                if (type2 == TokenType.WHITE_SPACE) {
                    String text2 = prevNode.getText();
                    String cdataStartMarker = "<![CDATA[";
                    int cdataPos = text2.indexOf("<![CDATA[");
                    if (cdataPos != -1 && whiteSpace.indexOf("<![CDATA[") == -1 && (whiteSpace = DocumentBasedFormattingModel.mergeWsWithCdataMarker(whiteSpace, text2, cdataPos)) == null) {
                        return null;
                    }
                    type2 = (prevNode = TreeUtil.prevLeaf(prevNode)) != null ? prevNode.getElementType() : null;
                }
                String cdataEndMarker = "]]>";
                if (type2 == XmlTokenType.XML_CDATA_END && whiteSpace.indexOf("]]>") == -1) {
                    ASTNode at = this.findElementAt(prevNode.getStartOffset());
                    if (at != null && at.getPsi() instanceof PsiWhiteSpace) {
                        String s = at.getText();
                        int cdataEndPos = s.indexOf("]]>");
                        whiteSpace = DocumentBasedFormattingModel.mergeWsWithCdataMarker(whiteSpace, s, cdataEndPos);
                        leafElement = at;
                    } else {
                        whiteSpace = null;
                    }
                    if (whiteSpace == null) {
                        return null;
                    }
                }
            }
        }
        FormatterUtil.replaceWhiteSpace(whiteSpace, leafElement, TokenType.WHITE_SPACE, textRange);
        return whiteSpace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootBlock", "com/intellij/psi/impl/source/codeStyle/PsiBasedFormatterModelWithShiftIndentInside", "<init>"));
    }
}

