/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.util.PsiUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class InputOutputConstraintFormula
implements ConstraintFormula {
    public abstract PsiExpression getExpression();

    protected abstract PsiType getT();

    protected abstract void setT(PsiType var1);

    protected abstract InputOutputConstraintFormula createSelfConstraint(PsiType var1, PsiExpression var2);

    protected abstract void collectReturnTypeVariables(InferenceSession var1, PsiExpression var2, PsiType var3, Set<InferenceVariable> var4);

    public Set<InferenceVariable> getInputVariables(InferenceSession session2) {
        PsiExpression psiExpression = this.getExpression();
        PsiType type2 = this.getT();
        if (psiExpression instanceof PsiFunctionalExpression) {
            PsiType functionType;
            PsiClassType.ClassResolveResult resolveResult;
            PsiMethod interfaceMethod;
            InferenceVariable inferenceVariable = session2.getInferenceVariable(type2);
            if (inferenceVariable != null) {
                HashSet<InferenceVariable> result2 = new HashSet<InferenceVariable>();
                result2.add(inferenceVariable);
                return result2;
            }
            if (LambdaUtil.isFunctionalType((PsiType)type2) && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)(resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)(functionType = psiExpression instanceof PsiLambdaExpression ? FunctionalInterfaceParameterizationUtil.getGroundTargetType(type2, (PsiLambdaExpression)psiExpression, false) : type2))))) != null) {
                PsiType returnType;
                HashSet<InferenceVariable> result3 = new HashSet<InferenceVariable>();
                PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult);
                if (psiExpression instanceof PsiLambdaExpression && !((PsiLambdaExpression)psiExpression).hasFormalParameterTypes() || psiExpression instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)psiExpression).isExact()) {
                    for (PsiParameter parameter2 : interfaceMethod.getParameterList().getParameters()) {
                        session2.collectDependencies(substitutor.substitute(parameter2.getType()), result3);
                    }
                }
                if ((returnType = interfaceMethod.getReturnType()) != null) {
                    this.collectReturnTypeVariables(session2, psiExpression, substitutor.substitute(returnType), result3);
                }
                return result3;
            }
        }
        if (psiExpression instanceof PsiParenthesizedExpression) {
            PsiExpression expression2 = ((PsiParenthesizedExpression)psiExpression).getExpression();
            return expression2 != null ? this.createSelfConstraint(type2, expression2).getInputVariables(session2) : null;
        }
        if (psiExpression instanceof PsiConditionalExpression) {
            Set<InferenceVariable> elseResult;
            PsiExpression thenExpression2 = ((PsiConditionalExpression)psiExpression).getThenExpression();
            PsiExpression elseExpression2 = ((PsiConditionalExpression)psiExpression).getElseExpression();
            Set<InferenceVariable> thenResult = thenExpression2 != null ? this.createSelfConstraint(type2, thenExpression2).getInputVariables(session2) : null;
            Set<InferenceVariable> set2 = elseResult = elseExpression2 != null ? this.createSelfConstraint(type2, elseExpression2).getInputVariables(session2) : null;
            if (thenResult == null) {
                return elseResult;
            }
            if (elseResult == null) {
                return thenResult;
            }
            thenResult.addAll(elseResult);
            return thenResult;
        }
        return null;
    }

    @Nullable
    public Set<InferenceVariable> getOutputVariables(Set<InferenceVariable> inputVariables, InferenceSession session2) {
        HashSet<InferenceVariable> mentionedVariables = new HashSet<InferenceVariable>();
        session2.collectDependencies(this.getT(), mentionedVariables);
        if (inputVariables != null) {
            mentionedVariables.removeAll(inputVariables);
        }
        return mentionedVariables.isEmpty() ? null : mentionedVariables;
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache) {
        this.setT(substitutor.substitute(this.getT()));
        if (cache) {
            LambdaUtil.getFunctionalTypeMap().put(this.getExpression(), this.getT());
        }
    }

    public String toString() {
        return this.getExpression().getText() + " -> " + this.getT().getPresentableText();
    }
}

