/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.GenericReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassKind;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassReferenceProvider
extends GenericReferenceProvider
implements CustomizableReferenceProvider {
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> RESOLVE_QUALIFIED_CLASS_NAME = new CustomizableReferenceProvider.CustomizationKey(PsiBundle.message((String)"qualified.resolve.class.reference.provider.option", (Object[])new Object[0]));
    public static final CustomizableReferenceProvider.CustomizationKey<String[]> EXTEND_CLASS_NAMES = new CustomizableReferenceProvider.CustomizationKey("EXTEND_CLASS_NAMES");
    public static final CustomizableReferenceProvider.CustomizationKey<String> CLASS_TEMPLATE = new CustomizableReferenceProvider.CustomizationKey("CLASS_TEMPLATE");
    public static final CustomizableReferenceProvider.CustomizationKey<ClassKind> CLASS_KIND = new CustomizableReferenceProvider.CustomizationKey("CLASS_KIND");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> INSTANTIATABLE = new CustomizableReferenceProvider.CustomizationKey("INSTANTIATABLE");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> CONCRETE = new CustomizableReferenceProvider.CustomizationKey("CONCRETE");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> NOT_INTERFACE = new CustomizableReferenceProvider.CustomizationKey("NOT_INTERFACE");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> NOT_ENUM = new CustomizableReferenceProvider.CustomizationKey("NOT_ENUM");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> ADVANCED_RESOLVE = new CustomizableReferenceProvider.CustomizationKey("RESOLVE_ONLY_CLASSES");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> JVM_FORMAT = new CustomizableReferenceProvider.CustomizationKey("JVM_FORMAT");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> ALLOW_DOLLAR_NAMES = new CustomizableReferenceProvider.CustomizationKey("ALLOW_DOLLAR_NAMES");
    public static final CustomizableReferenceProvider.CustomizationKey<String> DEFAULT_PACKAGE = new CustomizableReferenceProvider.CustomizationKey("DEFAULT_PACKAGE");
    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> myOptions;
    private boolean myAllowEmpty;
    private final ParameterizedCachedValueProvider<List<PsiElement>, Project> myProvider = new ParameterizedCachedValueProvider<List<PsiElement>, Project>(){

        public CachedValueProvider.Result<List<PsiElement>> compute(Project project2) {
            PsiPackage rootPackage;
            PsiPackage defaultPackage;
            ArrayList psiPackages = new ArrayList();
            String defPackageName = DEFAULT_PACKAGE.getValue(JavaClassReferenceProvider.this.myOptions);
            if (StringUtil.isNotEmpty((String)defPackageName) && (defaultPackage = JavaPsiFacade.getInstance((Project)project2).findPackage(defPackageName)) != null) {
                psiPackages.addAll(JavaClassReferenceProvider.getSubPackages(defaultPackage));
            }
            if ((rootPackage = JavaPsiFacade.getInstance((Project)project2).findPackage("")) != null) {
                psiPackages.addAll(JavaClassReferenceProvider.getSubPackages(rootPackage));
            }
            return CachedValueProvider.Result.createSingleDependency(psiPackages, (Object)PsiModificationTracker.MODIFICATION_COUNT);
        }
    };
    private final Key<ParameterizedCachedValue<List<PsiElement>, Project>> myKey = Key.create((String)"default packages");

    public <T> void setOption(CustomizableReferenceProvider.CustomizationKey<T> option, T value2) {
        if (this.myOptions == null) {
            this.myOptions = new THashMap();
        }
        option.putValue(this.myOptions, value2);
    }

    @Nullable
    public <T> T getOption(CustomizableReferenceProvider.CustomizationKey<T> option) {
        return (T)(this.myOptions == null ? null : this.myOptions.get(option));
    }

    @Nullable
    public GlobalSearchScope getScope(Project project2) {
        return null;
    }

    @NotNull
    public PsiFile getContextFile(@NotNull PsiElement element) {
        if (element == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(0);
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(1);
        }
        return psiFile;
    }

    @Nullable
    public PsiClass getContextClass(@NotNull PsiElement element) {
        if (element == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(3);
        }
        if (context == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(4);
        }
        PsiReference[] psiReferenceArray = this.getReferencesByElement(element);
        if (psiReferenceArray == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element) {
        if (element == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(6);
        }
        int offsetInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
        String text2 = ElementManipulators.getValueText((PsiElement)element);
        PsiReference[] psiReferenceArray = this.getReferencesByString(text2, element, offsetInElement);
        if (psiReferenceArray == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(7);
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] getReferencesByString(String str, @NotNull PsiElement position, int offsetInPosition) {
        if (position == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(8);
        }
        if (this.myAllowEmpty && StringUtil.isEmpty((String)str)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JavaClassReferenceProvider.$$$reportNull$$$0(9);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        boolean allowDollars = Boolean.TRUE.equals(this.getOption(ALLOW_DOLLAR_NAMES));
        PsiReference[] psiReferenceArray = new JavaClassReferenceSet(str, position, offsetInPosition, allowDollars, this).getAllReferences();
        if (psiReferenceArray == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(10);
        }
        return psiReferenceArray;
    }

    @Override
    public void handleEmptyContext(PsiScopeProcessor processor2, PsiElement position) {
        ElementClassHint hint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        if (position == null) {
            return;
        }
        if (hint == null || hint.shouldProcess(ElementClassHint.DeclarationKind.PACKAGE) || hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            List<PsiElement> cachedPackages = this.getDefaultPackages(position.getProject());
            for (PsiElement psiPackage : cachedPackages) {
                if (processor2.execute(psiPackage, ResolveState.initial())) continue;
                return;
            }
        }
    }

    protected List<PsiElement> getDefaultPackages(Project project2) {
        return (List)CachedValuesManager.getManager((Project)project2).getParameterizedCachedValue((UserDataHolder)project2, this.myKey, this.myProvider, false, (Object)project2);
    }

    private static Collection<PsiPackage> getSubPackages(PsiPackage defaultPackage) {
        return ContainerUtil.mapNotNull((Object[])defaultPackage.getSubPackages(), (Function)((NullableFunction)psiPackage -> {
            String packageName = psiPackage.getName();
            return PsiNameHelper.getInstance((Project)psiPackage.getProject()).isIdentifier(packageName, PsiUtil.getLanguageLevel((PsiElement)psiPackage)) ? psiPackage : null;
        }));
    }

    @Override
    public void setOptions(@Nullable Map<CustomizableReferenceProvider.CustomizationKey, Object> options) {
        this.myOptions = options;
    }

    @Override
    @Nullable
    public Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
        return this.myOptions;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.myAllowEmpty = allowEmpty;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReferenceProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReferenceProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextFile";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextFile";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContextClass";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

