/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TypeOrElementOrAttributeReference;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaReferencesProvider
extends PsiReferenceProvider {
    @NonNls
    private static final String VALUE_ATTR_NAME = "value";
    @NonNls
    static final String NAME_ATTR_NAME = "name";
    @NonNls
    static final String MEMBER_TYPES_ATTR_NAME = "memberTypes";
    @NonNls
    static final String ITEM_TYPE_ATTR_NAME = "itemType";
    @NonNls
    static final String BASE_ATTR_NAME = "base";
    @NonNls
    static final String GROUP_TAG_NAME = "group";
    @NonNls
    static final String ATTRIBUTE_GROUP_TAG_NAME = "attributeGroup";
    @NonNls
    static final String ATTRIBUTE_TAG_NAME = "attribute";
    @NonNls
    static final String ELEMENT_TAG_NAME = "element";
    @NonNls
    static final String SIMPLE_TYPE_TAG_NAME = "simpleType";
    @NonNls
    static final String COMPLEX_TYPE_TAG_NAME = "complexType";
    @NonNls
    static final String REF_ATTR_NAME = "ref";
    @NonNls
    static final String TYPE_ATTR_NAME = "type";
    @NonNls
    static final String SUBSTITUTION_GROUP_ATTR_NAME = "substitutionGroup";

    public String[] getCandidateAttributeNamesForSchemaReferences() {
        return new String[]{REF_ATTR_NAME, TYPE_ATTR_NAME, BASE_ATTR_NAME, NAME_ATTR_NAME, SUBSTITUTION_GROUP_ATTR_NAME, MEMBER_TYPES_ATTR_NAME, VALUE_ATTR_NAME, ITEM_TYPE_ATTR_NAME};
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        PsiElement parent;
        if (element == null) {
            SchemaReferencesProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SchemaReferencesProvider.$$$reportNull$$$0(1);
        }
        if (!((parent = element.getParent()) instanceof XmlAttribute)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SchemaReferencesProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String attrName = ((XmlAttribute)parent).getName();
        if (VALUE_ATTR_NAME.equals(attrName)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SchemaReferencesProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (NAME_ATTR_NAME.equals(attrName)) {
            PsiReference[] psiReferenceArray2 = new PsiReference[]{new NameReference(element)};
            if (psiReferenceArray2 == null) {
                SchemaReferencesProvider.$$$reportNull$$$0(4);
            }
            return psiReferenceArray2;
        }
        if (MEMBER_TYPES_ATTR_NAME.equals(attrName)) {
            ArrayList<TypeOrElementOrAttributeReference> result2 = new ArrayList<TypeOrElementOrAttributeReference>(1);
            String text2 = element.getText();
            int lastIndex = 1;
            int testLength = text2.length();
            for (int i = 1; i < testLength; ++i) {
                if (!Character.isWhitespace(text2.charAt(i))) continue;
                if (lastIndex != i) {
                    result2.add(new TypeOrElementOrAttributeReference(element, new TextRange(lastIndex, i)));
                }
                lastIndex = i + 1;
            }
            if (lastIndex != testLength - 1) {
                result2.add(new TypeOrElementOrAttributeReference(element, new TextRange(lastIndex, testLength - 1)));
            }
            PsiReference[] psiReferenceArray3 = result2.toArray(new PsiReference[result2.size()]);
            if (psiReferenceArray3 == null) {
                SchemaReferencesProvider.$$$reportNull$$$0(5);
            }
            return psiReferenceArray3;
        }
        PsiReference prefix = SchemaReferencesProvider.createSchemaPrefixReference(element);
        PsiReference ref = SchemaReferencesProvider.createTypeOrElementOrAttributeReference(element, prefix == null ? null : prefix.getCanonicalText());
        if (prefix == null) {
            PsiReference[] psiReferenceArray4 = new PsiReference[1];
            psiReferenceArray = psiReferenceArray4;
            psiReferenceArray4[0] = ref;
        } else {
            PsiReference[] psiReferenceArray5 = new PsiReference[2];
            psiReferenceArray5[0] = ref;
            psiReferenceArray = psiReferenceArray5;
            psiReferenceArray5[1] = prefix;
        }
        if (psiReferenceArray == null) {
            SchemaReferencesProvider.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    public static PsiReference createTypeOrElementOrAttributeReference(@NotNull PsiElement element) {
        if (element == null) {
            SchemaReferencesProvider.$$$reportNull$$$0(7);
        }
        return SchemaReferencesProvider.createTypeOrElementOrAttributeReference(element, null);
    }

    public static PsiReference createTypeOrElementOrAttributeReference(@NotNull PsiElement element, String ns) {
        int offset;
        if (element == null) {
            SchemaReferencesProvider.$$$reportNull$$$0(8);
        }
        int length = element.getTextLength();
        int n = offset = element instanceof XmlAttributeValue ? XmlUtil.findPrefixByQualifiedName(((XmlAttributeValue)element).getValue()).length() : 0;
        if (offset > 0) {
            ++offset;
        }
        TypeOrElementOrAttributeReference ref = new TypeOrElementOrAttributeReference(element, length >= 2 ? new TextRange(1 + offset, length - 1) : TextRange.EMPTY_RANGE);
        ref.setNamespacePrefix(ns);
        return ref;
    }

    @Nullable
    private static PsiReference createSchemaPrefixReference(PsiElement element) {
        XmlAttributeValue attributeValue;
        String prefix;
        if (element instanceof XmlAttributeValue && !(prefix = XmlUtil.findPrefixByQualifiedName((attributeValue = (XmlAttributeValue)element).getValue())).isEmpty()) {
            return new SchemaPrefixReference((XmlElement)attributeValue, TextRange.from((int)1, (int)prefix.length()), prefix, null);
        }
        return null;
    }

    @Nullable
    public static XmlNSDescriptorImpl findRedefinedDescriptor(XmlTag tag, String text2) {
        String localName = XmlUtil.findLocalNameByQualifiedName(text2);
        for (XmlTag parentTag = tag.getParentTag(); parentTag != null; parentTag = parentTag.getParentTag()) {
            XmlTag grandParent;
            if (!localName.equals(parentTag.getAttributeValue(NAME_ATTR_NAME)) || (grandParent = parentTag.getParentTag()) == null || !"redefine".equals(grandParent.getLocalName())) continue;
            return XmlNSDescriptorImpl.getRedefinedElementDescriptor(grandParent);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_TAG_NAME;
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTypeOrElementOrAttributeReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NameReference
    implements PsiReference {
        private final PsiElement myElement;

        public NameReference(PsiElement element) {
            this.myElement = element;
        }

        public PsiElement getElement() {
            return this.myElement;
        }

        public TextRange getRangeInElement() {
            return ElementManipulators.getValueTextRange((PsiElement)this.myElement);
        }

        @Nullable
        public PsiElement resolve() {
            return this.myElement.getParent().getParent();
        }

        @NotNull
        public String getCanonicalText() {
            String text2 = this.myElement.getText();
            String string = text2.substring(1, text2.length() - 1);
            if (string == null) {
                NameReference.$$$reportNull$$$0(0);
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return ElementManipulators.getManipulator((PsiElement)this.myElement).handleContentChange(this.myElement, this.getRangeInElement(), newElementName.substring(newElementName.indexOf(58) + 1));
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                NameReference.$$$reportNull$$$0(1);
            }
            return null;
        }

        public boolean isReferenceTo(PsiElement element) {
            return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                NameReference.$$$reportNull$$$0(2);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$NameReference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = SchemaReferencesProvider.ELEMENT_TAG_NAME;
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$NameReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

