/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lang.java.parser.JavadocParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.source.javadoc.PsiDocCommentImpl;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.impl.source.javadoc.PsiDocTagImpl;
import com.intellij.psi.impl.source.javadoc.PsiInlineDocTagImpl;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.tree.ICompositeElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.IReparseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.tree.java.IJavaDocElementType;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JavaDocElementType {
    public static final IElementType DOC_TAG = new JavaDocCompositeElementType("DOC_TAG", PsiDocTagImpl.class);
    public static final IElementType DOC_INLINE_TAG = new JavaDocCompositeElementType("DOC_INLINE_TAG", PsiInlineDocTagImpl.class);
    public static final IElementType DOC_METHOD_OR_FIELD_REF = new JavaDocCompositeElementType("DOC_METHOD_OR_FIELD_REF", PsiDocMethodOrFieldRef.class);
    public static final IElementType DOC_PARAMETER_REF = new JavaDocCompositeElementType("DOC_PARAMETER_REF", PsiDocParamRef.class);
    public static final IElementType DOC_TAG_VALUE_ELEMENT = new IJavaDocElementType("DOC_TAG_VALUE_ELEMENT");
    public static final ILazyParseableElementType DOC_REFERENCE_HOLDER = new JavaDocLazyElementType("DOC_REFERENCE_HOLDER"){
        private final JavaParserUtil.ParserWrapper myParser = new JavaParserUtil.ParserWrapper(){

            @Override
            public void parse(PsiBuilder builder) {
                JavadocParser.parseJavadocReference(builder);
            }
        };

        @Nullable
        public ASTNode parseContents(ASTNode chameleon) {
            return JavaParserUtil.parseFragment(chameleon, this.myParser, false, LanguageLevel.JDK_1_3);
        }
    };
    public static final ILazyParseableElementType DOC_TYPE_HOLDER = new JavaDocLazyElementType("DOC_TYPE_HOLDER"){
        private final JavaParserUtil.ParserWrapper myParser = new JavaParserUtil.ParserWrapper(){

            @Override
            public void parse(PsiBuilder builder) {
                JavadocParser.parseJavadocType(builder);
            }
        };

        @Nullable
        public ASTNode parseContents(ASTNode chameleon) {
            return JavaParserUtil.parseFragment(chameleon, this.myParser, false, LanguageLevel.JDK_1_3);
        }
    };
    public static final ILazyParseableElementType DOC_COMMENT = new IReparseableElementType("DOC_COMMENT", (Language)JavaLanguage.INSTANCE){
        private final JavaParserUtil.ParserWrapper myParser = new JavaParserUtil.ParserWrapper(){

            @Override
            public void parse(PsiBuilder builder) {
                JavadocParser.parseDocCommentText(builder);
            }
        };

        public ASTNode createNode(CharSequence text2) {
            return new PsiDocCommentImpl(text2);
        }

        @Nullable
        public ASTNode parseContents(ASTNode chameleon) {
            return JavaParserUtil.parseFragment(chameleon, this.myParser);
        }

        public boolean isParsable(CharSequence buffer, Language fileLanguage, Project project2) {
            if (!StringUtil.startsWith((CharSequence)buffer, (CharSequence)"/**") || !StringUtil.endsWith((CharSequence)buffer, (CharSequence)"*/")) {
                return false;
            }
            Lexer lexer = JavaParserDefinition.createLexer(LanguageLevelProjectExtension.getInstance((Project)project2).getLanguageLevel());
            lexer.start(buffer);
            if (lexer.getTokenType() == DOC_COMMENT) {
                lexer.advance();
                if (lexer.getTokenType() == null) {
                    return true;
                }
            }
            return false;
        }
    };
    public static final TokenSet ALL_JAVADOC_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{DOC_TAG, DOC_INLINE_TAG, DOC_METHOD_OR_FIELD_REF, DOC_PARAMETER_REF, DOC_TAG_VALUE_ELEMENT, DOC_REFERENCE_HOLDER, DOC_TYPE_HOLDER, DOC_COMMENT});

    public static class JavaDocLazyElementType
    extends ILazyParseableElementType {
        private JavaDocLazyElementType(@NonNls String debugName) {
            super(debugName, (Language)JavaLanguage.INSTANCE);
        }

        public ASTNode createNode(CharSequence text2) {
            return new LazyParseablePsiElement((IElementType)this, text2);
        }
    }

    public static class JavaDocCompositeElementType
    extends IJavaDocElementType
    implements ICompositeElementType {
        private final Constructor<? extends ASTNode> myConstructor;

        private JavaDocCompositeElementType(@NonNls String debugName, Class<? extends ASTNode> nodeClass) {
            super(debugName);
            this.myConstructor = ReflectionUtil.getDefaultConstructor(nodeClass);
        }

        @NotNull
        public ASTNode createCompositeNode() {
            ASTNode aSTNode = (ASTNode)ReflectionUtil.createInstance(this.myConstructor, (Object[])new Object[0]);
            if (aSTNode == null) {
                JavaDocCompositeElementType.$$$reportNull$$$0(0);
            }
            return aSTNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/JavaDocElementType$JavaDocCompositeElementType", "createCompositeNode"));
        }
    }
}

