/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaTreeGenerator;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeCopyHandler;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;

public class JavaTreeCopyHandler
implements TreeCopyHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.JavaTreeCopyHandler");
    private static final Key<Boolean> ALREADY_ESCAPED = new Key("ALREADY_ESCAPED");
    private static final Key<Boolean> ESCAPEMENT_ENGAGED = new Key("ESCAPEMENT_ENGAGED");
    private static final Key<Boolean> INTERFACE_MODIFIERS_FLAG_KEY = Key.create((String)"INTERFACE_MODIFIERS_FLAG_KEY");

    @Override
    public TreeElement decodeInformation(TreeElement element, Map<Object, Object> decodingState) {
        String escaped;
        String original;
        boolean shallDecodeEscapedTexts = JavaTreeCopyHandler.shallEncodeEscapedTexts(element, decodingState);
        if (element instanceof CompositeElement) {
            IElementType elementType = element.getElementType();
            if (elementType == JavaElementType.JAVA_CODE_REFERENCE || elementType == JavaElementType.REFERENCE_EXPRESSION || elementType == JavaElementType.METHOD_REF_EXPRESSION) {
                PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeToPsiNotNull(element);
                PsiClass refClass = (PsiClass)element.getCopyableUserData(JavaTreeGenerator.REFERENCED_CLASS_KEY);
                if (refClass != null) {
                    element.putCopyableUserData(JavaTreeGenerator.REFERENCED_CLASS_KEY, null);
                    PsiManager manager = refClass.getManager();
                    JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)refClass.getProject());
                    PsiElement refElement = ref.resolve();
                    try {
                        if (refClass != refElement && !manager.areElementsEquivalent((PsiElement)refClass, refElement)) {
                            if (((CompositeElement)element).findChildByRole(54) == null) {
                                ref = (PsiJavaCodeReferenceElement)ref.bindToElement((PsiElement)refClass);
                            }
                        } else {
                            ref = (PsiJavaCodeReferenceElement)codeStyleManager.shortenClassReferences((PsiElement)ref, 4096);
                        }
                        return (TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)ref);
                    }
                    catch (IncorrectOperationException e) {
                        ((PsiImportHolder)ref.getContainingFile()).importClass(refClass);
                    }
                } else {
                    PsiMember refMember = (PsiMember)element.getCopyableUserData(JavaTreeGenerator.REFERENCED_MEMBER_KEY);
                    if (refMember != null) {
                        LOG.assertTrue(ref instanceof PsiReferenceExpression);
                        element.putCopyableUserData(JavaTreeGenerator.REFERENCED_MEMBER_KEY, null);
                        PsiElement refElement = ref.resolve();
                        if (refMember != refElement && !refMember.getManager().areElementsEquivalent((PsiElement)refMember, refElement)) {
                            PsiClass containingClass = refMember.getContainingClass();
                            if (containingClass != null) {
                                try {
                                    ref = (PsiJavaCodeReferenceElement)((PsiReferenceExpression)ref).bindToElementViaStaticImport(containingClass);
                                }
                                catch (IncorrectOperationException incorrectOperationException) {
                                    // empty catch block
                                }
                            }
                            return SourceTreeToPsiMap.psiToTreeNotNull((PsiElement)ref);
                        }
                    }
                }
            } else if (element.getElementType() == JavaElementType.MODIFIER_LIST && element.getUserData(INTERFACE_MODIFIERS_FLAG_KEY) != null) {
                element.putUserData(INTERFACE_MODIFIERS_FLAG_KEY, null);
                try {
                    PsiModifierList modifierList = (PsiModifierList)SourceTreeToPsiMap.treeToPsiNotNull(element);
                    if (element.getTreeParent().getElementType() == JavaElementType.FIELD) {
                        modifierList.setModifierProperty("public", true);
                        modifierList.setModifierProperty("static", true);
                        modifierList.setModifierProperty("final", true);
                    } else if (element.getTreeParent().getElementType() == JavaElementType.METHOD || element.getTreeParent().getElementType() == JavaElementType.ANNOTATION_METHOD) {
                        modifierList.setModifierProperty("public", true);
                        modifierList.setModifierProperty("abstract", true);
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        } else if (shallDecodeEscapedTexts && element instanceof LeafElement && !(element instanceof OuterLanguageElement) && !JavaTreeCopyHandler.isInCData(element) && !Comparing.equal((String)(original = element.getText()), (String)(escaped = StringUtil.escapeXml((String)original))) && element.getCopyableUserData(ALREADY_ESCAPED) == null) {
            LeafElement copy = ((LeafElement)element).replaceWithText(escaped);
            copy.putCopyableUserData(ALREADY_ESCAPED, Boolean.TRUE);
            return copy;
        }
        return null;
    }

    private static boolean conversionMayApply(ASTNode element) {
        PsiElement psi = element.getPsi();
        if (psi == null || !psi.isValid()) {
            return false;
        }
        PsiFile file2 = psi.getContainingFile();
        Language baseLanguage = file2.getViewProvider().getBaseLanguage();
        return baseLanguage == StdLanguages.JSPX && file2.getLanguage() != baseLanguage;
    }

    @Override
    public void encodeInformation(TreeElement element, ASTNode original, Map<Object, Object> encodingState) {
        String unescapedText;
        String originalText;
        boolean shallEncodeEscapedTexts = JavaTreeCopyHandler.shallEncodeEscapedTexts(original, encodingState);
        if (original instanceof CompositeElement) {
            ASTNode grand;
            ASTNode parent;
            IElementType parentType;
            IElementType originalType = original.getElementType();
            if (originalType == JavaElementType.JAVA_CODE_REFERENCE || originalType == JavaElementType.REFERENCE_EXPRESSION) {
                JavaTreeCopyHandler.encodeInformationInRef(element, original);
            } else if (originalType == JavaElementType.MODIFIER_LIST && ((parentType = (parent = original.getTreeParent()).getElementType()) == JavaElementType.FIELD || parentType == JavaElementType.METHOD || parentType == JavaElementType.ANNOTATION_METHOD) && (grand = parent.getTreeParent()).getElementType() == JavaElementType.CLASS && (((PsiClass)SourceTreeToPsiMap.treeToPsiNotNull(grand)).isInterface() || ((PsiClass)SourceTreeToPsiMap.treeToPsiNotNull(grand)).isAnnotationType())) {
                element.putUserData(INTERFACE_MODIFIERS_FLAG_KEY, Boolean.TRUE);
            }
        } else if (shallEncodeEscapedTexts && original instanceof LeafElement && !(original instanceof OuterLanguageElement) && !JavaTreeCopyHandler.isInCData(original) && !Comparing.equal((String)(originalText = element.getText()), (String)(unescapedText = StringUtil.unescapeXml((String)originalText)))) {
            LeafElement replaced = ((LeafElement)element).rawReplaceWithText(unescapedText);
            element.putCopyableUserData(ALREADY_ESCAPED, null);
            replaced.putCopyableUserData(ALREADY_ESCAPED, null);
        }
    }

    private static Boolean shallEncodeEscapedTexts(ASTNode original, Map<Object, Object> encodingState) {
        Boolean shallEncodeEscapedTexts = (Boolean)encodingState.get(ESCAPEMENT_ENGAGED);
        if (shallEncodeEscapedTexts == null) {
            shallEncodeEscapedTexts = JavaTreeCopyHandler.conversionMayApply(original);
            encodingState.put(ESCAPEMENT_ENGAGED, shallEncodeEscapedTexts);
        }
        return shallEncodeEscapedTexts;
    }

    private static boolean isInCData(ASTNode element) {
        ASTNode leaf = element;
        while (leaf != null) {
            if (leaf instanceof OuterLanguageElement) {
                return leaf.getText().contains("<![CDATA[");
            }
            leaf = TreeUtil.prevLeaf(leaf);
        }
        return false;
    }

    private static void encodeInformationInRef(TreeElement ref, ASTNode original) {
        block9: {
            IElementType originalType;
            block10: {
                block8: {
                    originalType = original.getElementType();
                    if (originalType != JavaElementType.REFERENCE_EXPRESSION) break block8;
                    PsiJavaCodeReferenceElement javaRefElement = (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeToPsiNotNull(original);
                    JavaResolveResult resolveResult = javaRefElement.advancedResolve(false);
                    PsiElement target2 = resolveResult.getElement();
                    if (target2 instanceof PsiClass && (original.getTreeParent().getElementType() == JavaElementType.REFERENCE_EXPRESSION || original.getTreeParent().getElementType() == JavaElementType.METHOD_REF_EXPRESSION)) {
                        ref.putCopyableUserData(JavaTreeGenerator.REFERENCED_CLASS_KEY, (PsiClass)target2);
                    } else if ((target2 instanceof PsiMethod || target2 instanceof PsiField) && ((PsiMember)target2).hasModifierProperty("static") && resolveResult.getCurrentFileResolveScope() instanceof PsiImportStaticStatement) {
                        ref.putCopyableUserData(JavaTreeGenerator.REFERENCED_MEMBER_KEY, (PsiMember)target2);
                    }
                    break block9;
                }
                if (originalType != JavaElementType.JAVA_CODE_REFERENCE) break block10;
                int kind2 = ((PsiJavaCodeReferenceElementImpl)original).getKind(((PsiJavaCodeReferenceElementImpl)original).getContainingFile());
                switch (kind2) {
                    case 1: 
                    case 3: 
                    case 6: {
                        PsiElement target3 = ((PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeToPsiNotNull(original)).resolve();
                        if (target3 instanceof PsiClass) {
                            ref.putCopyableUserData(JavaTreeGenerator.REFERENCED_CLASS_KEY, (PsiClass)target3);
                            break;
                        }
                        break block9;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    default: {
                        LOG.error("Unknown kind: " + kind2);
                        break;
                    }
                }
                break block9;
            }
            LOG.error("Wrong element type: " + originalType);
        }
    }
}

