/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.impl.PsiLiteralStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.injected.StringLiteralEscaper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.util.text.LiteralFormatUtil;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiLiteralExpressionImpl
extends JavaStubPsiElement<PsiLiteralStub>
implements PsiLiteralExpression,
PsiLanguageInjectionHost,
ContributedReferenceHost {
    @NonNls
    private static final String QUOT = "&quot;";
    public static final TokenSet INTEGER_LITERALS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.INTEGER_LITERAL, JavaTokenType.LONG_LITERAL});
    public static final TokenSet REAL_LITERALS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.FLOAT_LITERAL, JavaTokenType.DOUBLE_LITERAL});
    public static final TokenSet NUMERIC_LITERALS = TokenSet.orSet((TokenSet[])new TokenSet[]{INTEGER_LITERALS, REAL_LITERALS});

    public PsiLiteralExpressionImpl(@NotNull PsiLiteralStub stub) {
        if (stub == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        super(stub, (IStubElementType)JavaStubElementTypes.LITERAL_EXPRESSION);
    }

    public PsiLiteralExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        super(node);
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = ((CompositeElement)this.getNode()).getChildrenAsPsiElements(null, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    public PsiType getType() {
        IElementType type2 = this.getLiteralElementType();
        if (type2 == JavaTokenType.INTEGER_LITERAL) {
            return PsiType.INT;
        }
        if (type2 == JavaTokenType.LONG_LITERAL) {
            return PsiType.LONG;
        }
        if (type2 == JavaTokenType.FLOAT_LITERAL) {
            return PsiType.FLOAT;
        }
        if (type2 == JavaTokenType.DOUBLE_LITERAL) {
            return PsiType.DOUBLE;
        }
        if (type2 == JavaTokenType.CHARACTER_LITERAL) {
            return PsiType.CHAR;
        }
        if (type2 == JavaTokenType.STRING_LITERAL) {
            PsiManagerEx manager = this.getManager();
            GlobalSearchScope resolveScope = ResolveScopeManager.getElementResolveScope((PsiElement)this);
            return PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)resolveScope);
        }
        if (type2 == JavaTokenType.TRUE_KEYWORD || type2 == JavaTokenType.FALSE_KEYWORD) {
            return PsiType.BOOLEAN;
        }
        if (type2 == JavaTokenType.NULL_KEYWORD) {
            return PsiType.NULL;
        }
        return null;
    }

    public IElementType getLiteralElementType() {
        PsiLiteralStub stub = (PsiLiteralStub)((Object)this.getGreenStub());
        if (stub != null) {
            return stub.getLiteralType();
        }
        return this.getNode().getFirstChildNode().getElementType();
    }

    public String getCanonicalText() {
        IElementType type2 = this.getLiteralElementType();
        return NUMERIC_LITERALS.contains(type2) ? LiteralFormatUtil.removeUnderscores(this.getText()) : this.getText();
    }

    @Override
    public String getText() {
        PsiLiteralStub stub = (PsiLiteralStub)((Object)this.getGreenStub());
        if (stub != null) {
            return stub.getLiteralText();
        }
        return super.getText();
    }

    public Object getValue() {
        IElementType type2 = this.getLiteralElementType();
        if (type2 == JavaTokenType.TRUE_KEYWORD) {
            return Boolean.TRUE;
        }
        if (type2 == JavaTokenType.FALSE_KEYWORD) {
            return Boolean.FALSE;
        }
        if (type2 == JavaTokenType.STRING_LITERAL) {
            String innerText = this.getInnerText();
            return innerText == null ? null : PsiLiteralExpressionImpl.internedParseStringCharacters(innerText);
        }
        String text2 = NUMERIC_LITERALS.contains(type2) ? this.getCanonicalText().toLowerCase(Locale.ENGLISH) : this.getCanonicalText();
        int textLength = text2.length();
        if (type2 == JavaTokenType.INTEGER_LITERAL) {
            return PsiLiteralUtil.parseInteger((String)text2);
        }
        if (type2 == JavaTokenType.LONG_LITERAL) {
            return PsiLiteralUtil.parseLong((String)text2);
        }
        if (type2 == JavaTokenType.FLOAT_LITERAL) {
            return PsiLiteralUtil.parseFloat((String)text2);
        }
        if (type2 == JavaTokenType.DOUBLE_LITERAL) {
            return PsiLiteralUtil.parseDouble((String)text2);
        }
        if (type2 == JavaTokenType.CHARACTER_LITERAL) {
            if (StringUtil.endsWithChar((CharSequence)text2, (char)'\'')) {
                if (textLength == 1) {
                    return null;
                }
                text2 = text2.substring(1, textLength - 1);
            } else {
                text2 = text2.substring(1, textLength);
            }
            StringBuilder chars = new StringBuilder();
            boolean success = PsiLiteralExpressionImpl.parseStringCharacters(text2, chars, null);
            if (!success) {
                return null;
            }
            if (chars.length() != 1) {
                return null;
            }
            return Character.valueOf(chars.charAt(0));
        }
        return null;
    }

    @Nullable
    public String getInnerText() {
        String text2 = this.getCanonicalText();
        int textLength = text2.length();
        if (StringUtil.endsWithChar((CharSequence)text2, (char)'\"')) {
            if (textLength == 1) {
                return null;
            }
            text2 = text2.substring(1, textLength - 1);
        } else if (text2.startsWith(QUOT) && text2.endsWith(QUOT) && textLength > QUOT.length()) {
            text2 = text2.substring(QUOT.length(), textLength - QUOT.length());
        } else {
            return null;
        }
        return text2;
    }

    @Nullable
    private static String internedParseStringCharacters(String chars) {
        StringBuilder outChars = new StringBuilder(chars.length());
        boolean success = PsiLiteralExpressionImpl.parseStringCharacters(chars, outChars, null);
        return success ? outChars.toString() : null;
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets) {
        if (chars == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        if (outChars == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        return CodeInsightUtilCore.parseStringCharacters(chars, outChars, sourceOffsets);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitLiteralExpression((PsiLiteralExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiLiteralExpression:" + this.getText();
    }

    public boolean isValidHost() {
        return this.getLiteralElementType() == JavaTokenType.STRING_LITERAL;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        IElementType type2 = this.getLiteralElementType();
        if (type2 != JavaTokenType.STRING_LITERAL && type2 != JavaTokenType.INTEGER_LITERAL) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PsiLiteralExpressionImpl.$$$reportNull$$$0(6);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = PsiReferenceService.getService().getContributedReferences((PsiElement)this);
        if (psiReferenceArray == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(7);
        }
        return psiReferenceArray;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        if (text2 == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(8);
        }
        ASTNode valueNode = this.getNode().getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text2);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<PsiLiteralExpressionImpl> createLiteralTextEscaper() {
        StringLiteralEscaper<PsiLiteralExpressionImpl> stringLiteralEscaper = new StringLiteralEscaper<PsiLiteralExpressionImpl>(this);
        if (stringLiteralEscaper == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(9);
        }
        return stringLiteralEscaper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralTextEscaper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseStringCharacters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

