/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubProcessingHelperBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubProcessingHelperBase");

    public <Psi extends PsiElement> boolean processStubsInFile(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull StubIdList value2, @NotNull Processor<? super Psi> processor2, @NotNull Class<Psi> requiredClass) {
        PsiElement psi;
        PsiFile psiFile;
        if (project2 == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(1);
        }
        if (value2 == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(3);
        }
        if (requiredClass == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(4);
        }
        if ((psiFile = PsiManager.getInstance((Project)project2).findFile(file2)) == null) {
            LOG.error("Stub index points to a file without PSI: " + file2.getFileType());
            this.onInternalError(file2);
            return true;
        }
        List<StubbedSpine> spines = StubProcessingHelperBase.getAllSpines(psiFile);
        if (spines.isEmpty()) {
            return this.handleNonPsiStubs(file2, processor2, requiredClass, psiFile);
        }
        int size = value2.size();
        for (int i = 0; i < size && this.checkType(requiredClass, psiFile, psi = StubProcessingHelperBase.getStubPsi(spines, value2.get(i))); ++i) {
            if (processor2.process((Object)psi)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<StubbedSpine> getAllSpines(PsiFile psiFile) {
        if (!(psiFile instanceof PsiFileImpl) && psiFile instanceof PsiFileWithStubSupport) {
            List<StubbedSpine> list2 = Collections.singletonList(((PsiFileWithStubSupport)psiFile).getStubbedSpine());
            if (list2 == null) {
                StubProcessingHelperBase.$$$reportNull$$$0(5);
            }
            return list2;
        }
        List list3 = ContainerUtil.map(StubTreeBuilder.getStubbedRoots(psiFile.getViewProvider()), t -> ((PsiFileImpl)t.second).getStubbedSpine());
        if (list3 == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(6);
        }
        return list3;
    }

    private <Psi extends PsiElement> boolean checkType(@NotNull Class<Psi> requiredClass, PsiFile psiFile, PsiElement psiElement) {
        if (requiredClass == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(7);
        }
        if (requiredClass.isInstance(psiElement)) {
            return true;
        }
        StubTree stubTree = ((PsiFileWithStubSupport)psiFile).getStubTree();
        if (stubTree == null && psiFile instanceof PsiFileImpl) {
            stubTree = ((PsiFileImpl)psiFile).calcStubTree();
        }
        this.inconsistencyDetected(stubTree, (PsiFileWithStubSupport)psiFile);
        return false;
    }

    private static PsiElement getStubPsi(List<StubbedSpine> spines, int index) {
        if (spines.size() == 1) {
            return spines.get(0).getStubPsi(index);
        }
        for (StubbedSpine spine : spines) {
            int count = spine.getStubCount();
            if (index < count) {
                return spine.getStubPsi(index);
            }
            index -= count;
        }
        return null;
    }

    private <Psi extends PsiElement> boolean handleNonPsiStubs(@NotNull VirtualFile file2, @NotNull Processor<? super Psi> processor2, @NotNull Class<Psi> requiredClass, @NotNull PsiFile psiFile) {
        if (file2 == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(8);
        }
        if (processor2 == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(9);
        }
        if (requiredClass == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(10);
        }
        if (psiFile == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(11);
        }
        if (BinaryFileStubBuilders.INSTANCE.forFileType(psiFile.getFileType()) == null) {
            LOG.error("unable to get stub builder for " + psiFile.getFileType() + ", " + StubTreeLoader.getFileViewProviderMismatchDiagnostics(psiFile.getViewProvider()));
            this.onInternalError(file2);
            return true;
        }
        if (psiFile instanceof PsiBinaryFile) {
            return true;
        }
        ObjectStubTree objectStubTree = StubTreeLoader.getInstance().readFromVFile(psiFile.getProject(), file2);
        if (objectStubTree == null) {
            LOG.error("Stub index points to a file without indexed stubs: " + psiFile.getFileType());
            this.onInternalError(file2);
            return true;
        }
        if (objectStubTree instanceof StubTree) {
            LOG.error("Stub index points to a file with PSI stubs (instead of non-PSI ones): " + psiFile.getFileType());
            this.onInternalError(file2);
            return true;
        }
        if (!requiredClass.isInstance(psiFile)) {
            this.inconsistencyDetected(objectStubTree, (PsiFileWithStubSupport)psiFile);
            return true;
        }
        return processor2.process((Object)psiFile);
    }

    private void inconsistencyDetected(@Nullable ObjectStubTree stubTree, @NotNull PsiFileWithStubSupport psiFile) {
        if (psiFile == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(12);
        }
        try {
            StubTextInconsistencyException.checkStubTextConsistency(psiFile);
            LOG.error((Throwable)StubTreeLoader.getInstance().stubTreeAndIndexDoNotMatch("PSI and index do not match.", stubTree, psiFile));
        }
        finally {
            this.onInternalError(psiFile.getVirtualFile());
        }
    }

    protected abstract void onInternalError(VirtualFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubProcessingHelperBase";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubProcessingHelperBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSpines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processStubsInFile";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleNonPsiStubs";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "inconsistencyDetected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

