/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.impl.java.stubs.hierarchy.IndexTree;
import com.intellij.psi.stubsHierarchy.impl.Import;
import com.intellij.psi.stubsHierarchy.impl.Imports;
import com.intellij.psi.stubsHierarchy.impl.NameEnvironment;
import com.intellij.psi.stubsHierarchy.impl.QualifiedName;
import com.intellij.psi.stubsHierarchy.impl.StubEnter;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.psi.stubsHierarchy.impl.UnitInfo;
import com.intellij.psi.stubsHierarchy.impl.UnitInputStream;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class SerializedUnit {
    private final byte[] myBytes;

    SerializedUnit(byte[] bytes) {
        this.myBytes = bytes;
    }

    SerializedUnit(IndexTree.Unit unit) {
        try {
            UnsyncByteArrayOutputStream stream = new UnsyncByteArrayOutputStream();
            SerializedUnit.writeUnit((DataOutput)new DataOutputStream((OutputStream)stream), unit);
            this.myBytes = stream.toByteArray();
        }
        catch (IOException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    byte[] getSerializedBytes() {
        return this.myBytes;
    }

    void readUnit(StubEnter stubEnter, int fileId) {
        try {
            SerializedUnit.enterUnit(new UnitInputStream((InputStream)new UnsyncByteArrayInputStream(this.myBytes), fileId, stubEnter));
        }
        catch (IOException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    private static void writeNameComponents(DataOutput out, String qName) throws IOException {
        int[] array = NameEnvironment.hashQualifiedName(qName);
        DataInputOutputUtil.writeINT((DataOutput)out, (int)array.length);
        for (int i : array) {
            out.writeInt(i);
        }
    }

    static QualifiedName readNameComponents(DataInput in) throws IOException {
        int length = DataInputOutputUtil.readINT((DataInput)in);
        if (length == 1) {
            return new QualifiedName.OfSingleComponent(in.readInt());
        }
        int[] result2 = new int[length];
        for (int i = 0; i < length; ++i) {
            result2[i] = in.readInt();
        }
        return new QualifiedName.OfComponents(result2);
    }

    private static void writeUnit(@NotNull DataOutput out, IndexTree.Unit value2) throws IOException {
        boolean compiled;
        if (out == null) {
            SerializedUnit.$$$reportNull$$$0(0);
        }
        SerializedUnit.writeNameComponents(out, value2.myPackageName);
        out.writeByte(value2.myUnitType);
        boolean bl = compiled = value2.myUnitType == 0;
        if (!compiled) {
            Imports.writeImports(out, value2);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.myDecls.length);
        for (IndexTree.ClassDecl def : value2.myDecls) {
            SerializedUnit.saveClassDecl(out, def, compiled);
        }
    }

    private static void enterUnit(UnitInputStream in) throws IOException {
        Symbol.PackageSymbol pkg = in.stubEnter.readPackageName(in);
        byte type2 = in.readByte();
        Import[] imports2 = type2 == 0 ? Imports.EMPTY_ARRAY : in.stubEnter.imports.readImports(in);
        UnitInfo unitInfo = UnitInfo.mkUnitInfo(type2, imports2);
        int classCount = DataInputOutputUtil.readINT((DataInput)in);
        for (int i = 0; i < classCount; ++i) {
            SerializedUnit.readClassDecl(in, unitInfo, pkg, pkg.myQualifiedName);
        }
    }

    private static void saveClassDecl(@NotNull DataOutput out, IndexTree.ClassDecl value2, boolean compiled) throws IOException {
        if (out == null) {
            SerializedUnit.$$$reportNull$$$0(1);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.myStubId);
        DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.myMods);
        out.writeInt(NameEnvironment.hashIdentifier(value2.myName));
        SerializedUnit.writeSupers(out, value2, compiled);
        SerializedUnit.writeMembers(out, value2.myDecls, compiled);
    }

    private static Symbol.ClassSymbol readClassDecl(UnitInputStream in, UnitInfo info, Symbol owner2, int ownerName) throws IOException {
        int stubId = DataInputOutputUtil.readINT((DataInput)in);
        int mods = DataInputOutputUtil.readINT((DataInput)in);
        int name2 = in.readInt();
        Object superNames = SerializedUnit.readSupers(in, info.isCompiled());
        int qname = NameEnvironment.memberQualifiedName(ownerName, name2);
        Symbol.ClassSymbol symbol = in.stubEnter.classEnter(info, owner2, stubId, mods, name2, superNames, qname, in.fileId);
        SerializedUnit.readMembers(in, info, qname, symbol);
        return symbol;
    }

    private static void writeSupers(@NotNull DataOutput out, IndexTree.ClassDecl value2, boolean interned) throws IOException {
        if (out == null) {
            SerializedUnit.$$$reportNull$$$0(2);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.mySupers.length);
        for (String aSuper : value2.mySupers) {
            SerializedUnit.writeSuperName(out, interned, aSuper);
        }
    }

    private static Object readSupers(UnitInputStream in, boolean intern) throws IOException {
        int length = DataInputOutputUtil.readINT((DataInput)in);
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return SerializedUnit.readSuperName(in, intern);
        }
        QualifiedName[] superNames = new QualifiedName[length];
        for (int i = 0; i < superNames.length; ++i) {
            superNames[i] = SerializedUnit.readSuperName(in, intern);
        }
        return superNames;
    }

    private static void writeSuperName(@NotNull DataOutput out, boolean interned, String aSuper) throws IOException {
        if (out == null) {
            SerializedUnit.$$$reportNull$$$0(3);
        }
        if (interned) {
            out.writeInt(NameEnvironment.fromString(aSuper));
        } else {
            SerializedUnit.writeNameComponents(out, aSuper);
        }
    }

    private static QualifiedName readSuperName(UnitInputStream in, boolean intern) throws IOException {
        return intern ? new QualifiedName.Interned(in.readInt()) : SerializedUnit.readNameComponents(in);
    }

    private static void writeMembers(@NotNull DataOutput out, IndexTree.Decl[] decls, boolean compiled) throws IOException {
        if (out == null) {
            SerializedUnit.$$$reportNull$$$0(4);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)decls.length);
        for (IndexTree.Decl def : decls) {
            SerializedUnit.saveDecl(out, def, compiled);
        }
    }

    private static void readMembers(UnitInputStream in, UnitInfo info, int ownerName, Symbol.MemberSymbol symbol) throws IOException {
        int memberCount = DataInputOutputUtil.readINT((DataInput)in);
        if (memberCount == 0) {
            return;
        }
        ArrayList<Symbol.ClassSymbol> members = new ArrayList<Symbol.ClassSymbol>();
        for (int i = 0; i < memberCount; ++i) {
            ContainerUtil.addIfNotNull(members, (Object)SerializedUnit.readDecl(in, info, symbol, ownerName));
        }
        symbol.setMembers(members);
    }

    private static void saveDecl(@NotNull DataOutput out, IndexTree.Decl value2, boolean compiled) throws IOException {
        if (out == null) {
            SerializedUnit.$$$reportNull$$$0(5);
        }
        if (value2 instanceof IndexTree.ClassDecl) {
            out.writeBoolean(true);
            SerializedUnit.saveClassDecl(out, (IndexTree.ClassDecl)value2, compiled);
        } else if (value2 instanceof IndexTree.MemberDecl) {
            out.writeBoolean(false);
            SerializedUnit.writeMembers(out, ((IndexTree.MemberDecl)value2).myDecls, compiled);
        }
    }

    private static Symbol.ClassSymbol readDecl(UnitInputStream in, UnitInfo info, Symbol owner2, int ownerName) throws IOException {
        if (in.readBoolean()) {
            return SerializedUnit.readClassDecl(in, info, owner2, ownerName);
        }
        SerializedUnit.readMembers(in, info, ownerName, new Symbol.MemberSymbol(owner2));
        return null;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof SerializedUnit && Arrays.equals(this.myBytes, ((SerializedUnit)o).myBytes);
    }

    public int hashCode() {
        int result2 = this.myBytes.length;
        int length = Math.min(30, this.myBytes.length);
        for (int i = 0; i < length; ++i) {
            result2 = 31 * result2 + this.myBytes[i];
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "out";
        objectArray2[1] = "com/intellij/psi/stubsHierarchy/impl/SerializedUnit";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeUnit";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "saveClassDecl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "writeSupers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeSuperName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeMembers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "saveDecl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

