/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceListWeigher
extends ProximityWeigher {
    public static final ReferenceListWeigher INSTANCE = new ReferenceListWeigher();
    public static final ElementPattern<PsiElement> INSIDE_REFERENCE_LIST = PlatformPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiReferenceList.class});

    @Nullable
    protected Preference getPreferredCondition(@NotNull PsiElement position) {
        if (position == null) {
            ReferenceListWeigher.$$$reportNull$$$0(0);
        }
        if (INSIDE_REFERENCE_LIST.accepts((Object)position)) {
            PsiReferenceList.Role role;
            PsiReferenceList list2 = (PsiReferenceList)position.getParent().getParent();
            if (ReferenceListWeigher.shouldContainInterfaces(list2, role = list2.getRole())) {
                return Preference.Interfaces;
            }
            if (role == PsiReferenceList.Role.EXTENDS_LIST) {
                return Preference.Classes;
            }
            if (role == PsiReferenceList.Role.THROWS_LIST) {
                return Preference.Exceptions;
            }
        }
        return null;
    }

    private static boolean shouldContainInterfaces(PsiReferenceList list2, PsiReferenceList.Role role) {
        if (role == PsiReferenceList.Role.EXTENDS_LIST) {
            PsiElement parent = list2.getParent();
            return parent instanceof PsiClass && ((PsiClass)parent).isInterface();
        }
        return role == PsiReferenceList.Role.IMPLEMENTS_LIST;
    }

    public ReferenceListApplicability weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        if (element == null) {
            ReferenceListWeigher.$$$reportNull$$$0(1);
        }
        if (location == null) {
            ReferenceListWeigher.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiClass && location.getPosition() != null) {
            return this.getApplicability((PsiClass)element, location.getPosition());
        }
        return ReferenceListApplicability.unknown;
    }

    @NotNull
    public ReferenceListApplicability getApplicability(@NotNull PsiClass aClass, @NotNull PsiElement position) {
        Preference condition2;
        if (aClass == null) {
            ReferenceListWeigher.$$$reportNull$$$0(3);
        }
        if (position == null) {
            ReferenceListWeigher.$$$reportNull$$$0(4);
        }
        if ((condition2 = this.getPreferredCondition(position)) == Preference.Interfaces) {
            ReferenceListApplicability referenceListApplicability = aClass.isInterface() ? ReferenceListApplicability.applicableByKind : ReferenceListApplicability.inapplicable;
            if (referenceListApplicability == null) {
                ReferenceListWeigher.$$$reportNull$$$0(5);
            }
            return referenceListApplicability;
        }
        if (condition2 == Preference.Classes) {
            VirtualFile vFile;
            if (aClass.isInterface()) {
                ReferenceListApplicability referenceListApplicability = ReferenceListApplicability.inapplicable;
                if (referenceListApplicability == null) {
                    ReferenceListWeigher.$$$reportNull$$$0(6);
                }
                return referenceListApplicability;
            }
            String name2 = aClass.getName();
            if (name2 != null && name2.endsWith("TestCase") && (vFile = aClass.getContainingFile().getVirtualFile()) != null && ProjectFileIndex.SERVICE.getInstance((Project)aClass.getProject()).isInTestSourceContent(vFile)) {
                ReferenceListApplicability referenceListApplicability = ReferenceListApplicability.applicableByName;
                if (referenceListApplicability == null) {
                    ReferenceListWeigher.$$$reportNull$$$0(7);
                }
                return referenceListApplicability;
            }
            ReferenceListApplicability referenceListApplicability = ReferenceListApplicability.applicableByKind;
            if (referenceListApplicability == null) {
                ReferenceListWeigher.$$$reportNull$$$0(8);
            }
            return referenceListApplicability;
        }
        if (condition2 == Preference.Exceptions) {
            ReferenceListApplicability referenceListApplicability = InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Throwable") ? ReferenceListApplicability.applicableByKind : ReferenceListApplicability.inapplicable;
            if (referenceListApplicability == null) {
                ReferenceListWeigher.$$$reportNull$$$0(9);
            }
            return referenceListApplicability;
        }
        ReferenceListApplicability referenceListApplicability = ReferenceListApplicability.unknown;
        if (referenceListApplicability == null) {
            ReferenceListWeigher.$$$reportNull$$$0(10);
        }
        return referenceListApplicability;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/proximity/ReferenceListWeigher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/proximity/ReferenceListWeigher";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredCondition";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "weigh";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getApplicability";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ReferenceListApplicability {
        inapplicable,
        unknown,
        applicableByKind,
        applicableByName;

    }

    protected static enum Preference {
        Interfaces,
        Classes,
        Exceptions;

    }
}

