/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.introduce.IntroduceTarget;
import com.intellij.refactoring.introduce.PsiIntroduceTarget;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IntroduceTargetChooser {
    private IntroduceTargetChooser() {
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor, @NotNull List<T> expressions2, @NotNull Pass<T> callback, @NotNull Function<T, String> renderer) {
        if (editor == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(0);
        }
        if (expressions2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(2);
        }
        if (renderer == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(3);
        }
        IntroduceTargetChooser.showChooser(editor, expressions2, callback, renderer, "Expressions");
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor, @NotNull List<T> expressions2, @NotNull Pass<T> callback, @NotNull Function<T, String> renderer, @NotNull @Nls String title) {
        if (editor == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(4);
        }
        if (expressions2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(6);
        }
        if (renderer == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(7);
        }
        if (title == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(8);
        }
        IntroduceTargetChooser.showChooser(editor, expressions2, callback, renderer, title, ScopeHighlighter.NATURAL_RANGER);
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor, @NotNull List<T> expressions2, @NotNull Pass<T> callback, @NotNull Function<T, String> renderer, @NotNull @Nls String title, @NotNull NotNullFunction<PsiElement, TextRange> ranger) {
        if (editor == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(9);
        }
        if (expressions2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(10);
        }
        if (callback == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(11);
        }
        if (renderer == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(12);
        }
        if (title == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(13);
        }
        if (ranger == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(14);
        }
        IntroduceTargetChooser.showChooser(editor, expressions2, callback, renderer, title, -1, ranger);
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor, @NotNull List<T> expressions2, final @NotNull Pass<T> callback, @NotNull Function<T, String> renderer, @NotNull @Nls String title, int selection, @NotNull NotNullFunction<PsiElement, TextRange> ranger) {
        if (editor == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(15);
        }
        if (expressions2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(16);
        }
        if (callback == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(17);
        }
        if (renderer == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(18);
        }
        if (title == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(19);
        }
        if (ranger == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(20);
        }
        List targets = ContainerUtil.map(expressions2, t -> {
            if (ranger == null) {
                IntroduceTargetChooser.$$$reportNull$$$0(26);
            }
            if (renderer == null) {
                IntroduceTargetChooser.$$$reportNull$$$0(27);
            }
            return new MyIntroduceTarget<PsiElement>((PsiElement)t, ranger, (Function<PsiElement, String>)renderer);
        });
        Pass callbackWrapper = new Pass<MyIntroduceTarget<T>>(){

            public void pass(MyIntroduceTarget<T> target2) {
                callback.pass(target2.getPlace());
            }
        };
        IntroduceTargetChooser.showIntroduceTargetChooser(editor, targets, callbackWrapper, title, selection);
    }

    public static <T extends IntroduceTarget> void showIntroduceTargetChooser(@NotNull Editor editor, @NotNull List<T> expressions2, @NotNull Pass<T> callback, @NotNull @Nls String title, int selection) {
        if (editor == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(21);
        }
        if (expressions2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(22);
        }
        if (callback == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(23);
        }
        if (title == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(24);
        }
        final AtomicReference<ScopeHighlighter> highlighter = new AtomicReference<ScopeHighlighter>(new ScopeHighlighter(editor));
        CollectionListModel model = new CollectionListModel(expressions2);
        JBList list2 = new JBList((ListModel)model);
        AccessibleContextUtil.setName((JComponent)list2, (String)title);
        list2.getSelectionModel().setSelectionMode(0);
        if (selection > -1) {
            list2.setSelectedIndex(selection);
        }
        list2.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
                IntroduceTarget expr = (IntroduceTarget)value2;
                if (expr.isValid()) {
                    String text2;
                    int firstNewLinePos = (text2 = expr.render()).indexOf(10);
                    String trimmedText = text2.substring(0, firstNewLinePos != -1 ? firstNewLinePos : Math.min(100, text2.length()));
                    if (trimmedText.length() != text2.length()) {
                        trimmedText = trimmedText + " ...";
                    }
                    this.setText(trimmedText);
                } else {
                    this.setForeground((Color)JBColor.RED);
                    this.setText("Invalid");
                }
                return rendererComponent;
            }
        });
        list2.addListSelectionListener(e -> {
            ScopeHighlighter h = (ScopeHighlighter)highlighter.get();
            if (h == null) {
                return;
            }
            h.dropHighlight();
            IntroduceTarget expr = (IntroduceTarget)list2.getSelectedValue();
            if (expr != null && expr.isValid()) {
                TextRange range = expr.getTextRange();
                h.highlight((Pair<TextRange, List<TextRange>>)Pair.create((Object)range, Collections.singletonList(range)));
            }
        });
        JBPopup popup2 = JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
            IntroduceTarget expr;
            if (callback == null) {
                IntroduceTargetChooser.$$$reportNull$$$0(25);
            }
            if ((expr = (IntroduceTarget)list2.getSelectedValue()) != null && expr.isValid()) {
                callback.pass((Object)expr);
            }
        }).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                ((ScopeHighlighter)highlighter.getAndSet(null)).dropHighlight();
            }
        }).createPopup();
        popup2.showInBestPositionFor(editor);
        Project project2 = editor.getProject();
        if (project2 != null) {
            NavigationUtil.hidePopupIfDumbModeStarts(popup2, project2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 17: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: 
            case 7: 
            case 12: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 8: 
            case 13: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 14: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranger";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/IntroduceTargetChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showChooser";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "showIntroduceTargetChooser";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showIntroduceTargetChooser$2";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showChooser$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyIntroduceTarget<T extends PsiElement>
    extends PsiIntroduceTarget<T> {
        private final NotNullFunction<PsiElement, TextRange> myRanger;
        private final Function<T, String> myRenderer;

        public MyIntroduceTarget(@NotNull T psi, @NotNull NotNullFunction<PsiElement, TextRange> ranger, @NotNull Function<T, String> renderer) {
            if (psi == null) {
                MyIntroduceTarget.$$$reportNull$$$0(0);
            }
            if (ranger == null) {
                MyIntroduceTarget.$$$reportNull$$$0(1);
            }
            if (renderer == null) {
                MyIntroduceTarget.$$$reportNull$$$0(2);
            }
            super(psi);
            this.myRanger = ranger;
            this.myRenderer = renderer;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = (TextRange)this.myRanger.fun(this.getPlace());
            if (textRange == null) {
                MyIntroduceTarget.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        @Override
        @NotNull
        public String render() {
            String string = (String)this.myRenderer.fun(this.getPlace());
            if (string == null) {
                MyIntroduceTarget.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ranger";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/IntroduceTargetChooser$MyIntroduceTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/IntroduceTargetChooser$MyIntroduceTarget";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "render";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

