/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.analysis.XmlUnusedNamespaceInspection;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlImportOptimizer
implements ImportOptimizer {
    private final XmlUnusedNamespaceInspection myInspection = new XmlUnusedNamespaceInspection();
    private final Condition<ProblemDescriptor> myCondition = descriptor2 -> {
        PsiElement element = descriptor2.getPsiElement();
        PsiElement parent = element.getParent();
        return parent != null && !this.myInspection.isSuppressedFor(parent);
    };

    public boolean supports(PsiFile file2) {
        return file2 instanceof XmlFile;
    }

    @NotNull
    public ImportOptimizer.CollectingInfoRunnable processFile(final PsiFile file2) {
        ImportOptimizer.CollectingInfoRunnable collectingInfoRunnable = new ImportOptimizer.CollectingInfoRunnable(){
            int myRemovedNameSpaces = 0;

            public void run() {
                XmlFile xmlFile = (XmlFile)file2;
                Project project2 = xmlFile.getProject();
                HighlightDisplayKey key2 = HighlightDisplayKey.find((String)XmlImportOptimizer.this.myInspection.getShortName());
                if (!InspectionProjectProfileManager.getInstance(project2).getCurrentProfile().isToolEnabled(key2, (PsiElement)xmlFile)) {
                    return;
                }
                ProblemsHolder holder = new ProblemsHolder(InspectionManager.getInstance((Project)project2), (PsiFile)xmlFile, false);
                final XmlElementVisitor visitor = (XmlElementVisitor)XmlImportOptimizer.this.myInspection.buildVisitor(holder, false);
                new PsiRecursiveElementVisitor(){

                    public void visitElement(PsiElement element) {
                        if (element instanceof XmlAttribute) {
                            visitor.visitXmlAttribute((XmlAttribute)element);
                        } else {
                            super.visitElement(element);
                        }
                    }
                }.visitFile((PsiFile)xmlFile);
                Object[] results = holder.getResultsArray();
                List list2 = ContainerUtil.filter((Object[])results, (Condition)XmlImportOptimizer.this.myCondition);
                LinkedHashMap<XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix, ProblemDescriptor> fixes = new LinkedHashMap<XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix, ProblemDescriptor>();
                for (ProblemDescriptor result2 : list2) {
                    for (QuickFix fix : result2.getFixes()) {
                        if (!(fix instanceof XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix)) continue;
                        fixes.put((XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix)fix, result2);
                    }
                }
                SmartPsiElementPointer<XmlTag> pointer = null;
                for (Map.Entry fix : fixes.entrySet()) {
                    pointer = ((XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix)fix.getKey()).doFix(project2, (ProblemDescriptor)fix.getValue(), false);
                    ++this.myRemovedNameSpaces;
                }
                if (pointer != null) {
                    XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix.reformatStartTag(project2, pointer);
                }
            }

            @Nullable
            public String getUserNotificationInfo() {
                return this.myRemovedNameSpaces > 0 ? "Removed " + this.myRemovedNameSpaces + " namespace" + (this.myRemovedNameSpaces > 1 ? "s" : "") : null;
            }
        };
        if (collectingInfoRunnable == null) {
            XmlImportOptimizer.$$$reportNull$$$0(0);
        }
        return collectingInfoRunnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/XmlImportOptimizer", "processFile"));
    }
}

