/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.convertToInstanceMethod;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodHandler;
import com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodProcessor;
import com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodDialogBase;
import com.intellij.ui.DoubleClickListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class ConvertToInstanceMethodDialog
extends MoveInstanceMethodDialogBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodDialog");

    public ConvertToInstanceMethodDialog(PsiMethod method, Object[] variables) {
        super(method, variables, ConvertToInstanceMethodHandler.REFACTORING_NAME);
        this.init();
    }

    @Override
    protected void doAction() {
        Object targetVariable = this.myList.getSelectedValue();
        LOG.assertTrue(targetVariable != null);
        ConvertToInstanceMethodProcessor processor2 = new ConvertToInstanceMethodProcessor(this.myMethod.getProject(), this.myMethod, targetVariable instanceof PsiParameter ? (PsiParameter)targetVariable : null, this.myVisibilityPanel.getVisibility());
        if (!this.verifyTargetClass(processor2.getTargetClass())) {
            return;
        }
        this.invokeRefactoring(processor2);
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.convertToInstanceMethod");
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(10, 4));
        JLabel label = new JLabel(RefactoringBundle.message((String)"moveInstanceMethod.select.an.instance.parameter"));
        panel2.add((Component)label, "North");
        panel2.add((Component)this.createListAndVisibilityPanels(), "Center");
        return panel2;
    }

    @Override
    protected JList createTargetVariableChooser() {
        final JList variableChooser = super.createTargetVariableChooser();
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                Point point = e.getPoint();
                int index = variableChooser.locationToIndex(point);
                if (index == -1) {
                    return false;
                }
                if (!variableChooser.getCellBounds(index, index).contains(point)) {
                    return false;
                }
                ConvertToInstanceMethodDialog.this.doRefactorAction();
                return true;
            }
        }.installOn((Component)variableChooser);
        return variableChooser;
    }

    @Override
    protected String getMovePropertySuffix() {
        return null;
    }

    @Override
    protected String getCbTitle() {
        return null;
    }
}

