/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ExtractMethodObjectHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance(ExtractMethodObjectHandler.class);

    public void invoke(final @NotNull Project project2, final Editor editor, final PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(0);
        }
        ExtractMethodHandler.selectAndPass(project2, editor, file2, new Pass<PsiElement[]>(){

            public void pass(PsiElement[] selectedValue) {
                ExtractMethodObjectHandler.invokeOnElements(project2, editor, file2, selectedValue);
            }
        });
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
        PsiElement[] elements;
        if (editor == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(2);
        }
        if (dataContext == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(3);
        }
        return (elements = ExtractMethodHandler.getElements(file2.getProject(), editor, file2)) != null && elements.length > 0;
    }

    private static void invokeOnElements(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull PsiElement[] elements) {
        if (project2 == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(6);
        }
        if (elements == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(7);
        }
        if (elements.length == 0) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.a.set.of.statements.or.an.expression"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)"Extract Method Object", (String)"refactoring.extractMethodObject");
            return;
        }
        try {
            ExtractMethodObjectHandler.extractMethodObject(project2, editor, new ExtractMethodObjectProcessor(project2, editor, elements, ""));
        }
        catch (PrepareFailedException e) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)e.getMessage(), (String)"Extract Method Object", (String)"refactoring.extractMethodObject");
            ExtractMethodHandler.highlightPrepareError(e, file2, editor, project2);
        }
    }

    static void extractMethodObject(Project project2, Editor editor, ExtractMethodObjectProcessor processor2) throws PrepareFailedException {
        ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor = processor2.getExtractProcessor();
        if (!extractProcessor.prepare()) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)extractProcessor.getTargetClass().getContainingFile())) {
            return;
        }
        if (extractProcessor.showDialog()) {
            ExtractMethodObjectHandler.extractMethodObject(project2, editor, processor2, extractProcessor);
        }
    }

    public static void extractMethodObject(@NotNull Project project2, Editor editor, @NotNull ExtractMethodObjectProcessor processor2, @NotNull ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor) {
        RangeMarker marker;
        if (project2 == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(8);
        }
        if (processor2 == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(9);
        }
        if (extractProcessor == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(10);
        }
        if (editor != null) {
            int offset = editor.getCaretModel().getOffset();
            marker = editor.getDocument().createRangeMarker(offset, offset);
        } else {
            marker = null;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            if (project2 == null) {
                ExtractMethodObjectHandler.$$$reportNull$$$0(23);
            }
            if (processor2 == null) {
                ExtractMethodObjectHandler.$$$reportNull$$$0(24);
            }
            if (extractProcessor == null) {
                ExtractMethodObjectHandler.$$$reportNull$$$0(25);
            }
            ExtractMethodObjectHandler.doRefactoring(project2, editor, processor2, extractProcessor);
        }, "Extract Method Object", (Object)"Extract Method Object");
        if (editor != null) {
            editor.getCaretModel().moveToOffset(marker.getStartOffset());
            marker.dispose();
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    private static void doRefactoring(@NotNull Project project2, Editor editor, @NotNull ExtractMethodObjectProcessor processor2, @NotNull ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor) {
        if (project2 == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(11);
        }
        if (processor2 == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(12);
        }
        if (extractProcessor == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(13);
        }
        PostprocessReformattingAspect.getInstance(project2).postponeFormattingInside(() -> {
            if (extractProcessor == null) {
                ExtractMethodObjectHandler.$$$reportNull$$$0(16);
            }
            if (processor2 == null) {
                ExtractMethodObjectHandler.$$$reportNull$$$0(17);
            }
            if (project2 == null) {
                ExtractMethodObjectHandler.$$$reportNull$$$0(18);
            }
            try {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (extractProcessor == null) {
                        ExtractMethodObjectHandler.$$$reportNull$$$0(22);
                    }
                    extractProcessor.doRefactoring();
                });
                processor2.run();
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (processor2 == null) {
                        ExtractMethodObjectHandler.$$$reportNull$$$0(21);
                    }
                    processor2.runChangeSignature();
                });
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            if (processor2.isCreateInnerClass()) {
                processor2.moveUsedMethodsToInner();
                PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                if (editor != null) {
                    DuplicatesImpl.processDuplicates(extractProcessor, project2, editor);
                }
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                PsiMethod method;
                if (processor2 == null) {
                    ExtractMethodObjectHandler.$$$reportNull$$$0(19);
                }
                if (project2 == null) {
                    ExtractMethodObjectHandler.$$$reportNull$$$0(20);
                }
                if (processor2.isCreateInnerClass()) {
                    processor2.changeInstanceAccess(project2);
                }
                LOG.assertTrue((method = processor2.getMethod()) != null);
                method.delete();
            });
        });
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(14);
        }
        if (elements == null) {
            ExtractMethodObjectHandler.$$$reportNull$$$0(15);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 9: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractProcessor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForQuickList";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeOnElements";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "extractMethodObject";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "doRefactoring";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doRefactoring$4";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$3";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$2";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$extractMethodObject$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

