/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineConstantFieldProcessor;
import com.intellij.refactoring.inline.InlineOptionsWithSearchSettingsDialog;

public class InlineFieldDialog
extends InlineOptionsWithSearchSettingsDialog {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.field.title");
    private final PsiReferenceExpression myReferenceExpression;
    private final PsiField myField;
    protected final int myOccurrencesNumber;

    public InlineFieldDialog(Project project2, PsiField field, PsiReferenceExpression ref) {
        super(project2, true, (PsiElement)field);
        this.myField = field;
        this.myReferenceExpression = ref;
        this.myInvokedOnReference = this.myReferenceExpression != null;
        this.setTitle(REFACTORING_NAME);
        this.myOccurrencesNumber = this.getNumberOfOccurrences((PsiNameIdentifierOwner)this.myField);
        this.init();
    }

    @Override
    protected String getNameLabelText() {
        String occurrencesString = this.myOccurrencesNumber > -1 ? " - " + this.myOccurrencesNumber + " occurrence" + (this.myOccurrencesNumber == 1 ? "" : "s") : "";
        String fieldText = PsiFormatUtil.formatVariable((PsiVariable)this.myField, (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return RefactoringBundle.message((String)"inline.field.field.name.label", (Object[])new Object[]{fieldText, occurrencesString});
    }

    @Override
    protected String getBorderTitle() {
        return RefactoringBundle.message((String)"inline.field.border.title");
    }

    @Override
    protected String getInlineThisText() {
        return RefactoringBundle.message((String)"this.reference.only.and.keep.the.field");
    }

    @Override
    protected String getInlineAllText() {
        return RefactoringBundle.message((String)(this.myField.isWritable() ? "all.references.and.remove.the.field" : "all.invocations.in.project"));
    }

    @Override
    protected String getKeepTheDeclarationText() {
        if (this.myField.isWritable()) {
            return RefactoringBundle.message((String)"all.references.keep.field");
        }
        return super.getKeepTheDeclarationText();
    }

    @Override
    protected boolean allowInlineAll() {
        return true;
    }

    @Override
    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_FIELD_THIS;
    }

    @Override
    protected boolean ignoreOccurrence(PsiReference reference) {
        return PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiImportStatementBase.class) == null;
    }

    @Override
    protected boolean isSearchInCommentsAndStrings() {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FIELD;
    }

    @Override
    protected void saveSearchInCommentsAndStrings(boolean searchInComments) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FIELD = searchInComments;
    }

    @Override
    protected boolean isSearchForTextOccurrences() {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FIELD;
    }

    @Override
    protected void saveSearchInTextOccurrences(boolean searchInTextOccurrences) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FIELD = searchInTextOccurrences;
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.invokeRefactoring(new InlineConstantFieldProcessor(this.myField, this.getProject(), this.myReferenceExpression, this.isInlineThisOnly(), this.isSearchInCommentsAndStrings(), this.isSearchForTextOccurrences(), !this.isKeepTheDeclaration()));
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            settings.INLINE_FIELD_THIS = this.isInlineThisOnly();
        }
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.inlineField");
    }
}

