/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.refactoring.inlineSuperClass.InlineSuperClassRefactoringProcessor;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineSuperClassRefactoringDialog
extends InlineOptionsDialog {
    private final PsiClass mySuperClass;
    private final PsiClass myCurrentInheritor;
    private final DocCommentPanel myDocPanel;

    protected InlineSuperClassRefactoringDialog(@NotNull Project project2, PsiClass superClass, PsiClass currentInheritor) {
        if (project2 == null) {
            InlineSuperClassRefactoringDialog.$$$reportNull$$$0(0);
        }
        super(project2, false, (PsiElement)superClass);
        this.mySuperClass = superClass;
        this.myCurrentInheritor = currentInheritor;
        this.myInvokedOnReference = currentInheritor != null;
        this.myDocPanel = new DocCommentPanel("JavaDoc for inlined members");
        this.myDocPanel.setPolicy(JavaRefactoringSettings.getInstance().PULL_UP_MEMBERS_JAVADOC);
        this.init();
        this.setTitle("Inline Super Class");
    }

    @Override
    protected void doAction() {
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            settings.INLINE_SUPER_CLASS_THIS = this.isInlineThisOnly();
        }
        this.invokeRefactoring(new InlineSuperClassRefactoringProcessor(this.getProject(), this.isInlineThisOnly() ? this.myCurrentInheritor : null, this.mySuperClass, this.myDocPanel.getPolicy()));
    }

    @Override
    protected JComponent createNorthPanel() {
        return null;
    }

    @Nullable
    protected String getHelpId() {
        return "Inline_Super_Class";
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0);
        panel2.add((Component)super.createCenterPanel(), gc);
        panel2.add((Component)this.myDocPanel, gc);
        if (this.mySuperClass.getDocComment() == null) {
            boolean hasJavadoc = InlineSuperClassRefactoringProcessor.getClassMembersToPush(this.mySuperClass).stream().anyMatch(memberInfo -> {
                PsiMember member = (PsiMember)memberInfo.getMember();
                return member instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)member).getDocComment() != null;
            });
            this.myDocPanel.setVisible(hasJavadoc);
        }
        gc.weighty = 1.0;
        gc.fill = 1;
        panel2.add(Box.createVerticalGlue(), gc);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            InlineSuperClassRefactoringDialog.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    protected String getNameLabelText() {
        return "Class " + this.mySuperClass.getQualifiedName();
    }

    @Override
    protected String getBorderTitle() {
        return "Inline";
    }

    @Override
    protected String getInlineAllText() {
        return RefactoringBundle.message((String)"all.references.and.remove.super.class");
    }

    @Override
    protected String getInlineThisText() {
        return RefactoringBundle.message((String)"this.reference.only.and.keep.super.class");
    }

    @Override
    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_SUPER_CLASS_THIS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

