/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.IntroduceFieldCentralPanel;
import com.intellij.refactoring.ui.JavaVisibilityPanel;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class IntroduceFieldDialogPanel
extends IntroduceFieldCentralPanel {
    private JRadioButton myRbInConstructor;
    private JRadioButton myRbInCurrentMethod;
    private JRadioButton myRbInFieldDeclaration;
    private JRadioButton myRbInSetUp;
    private JavaVisibilityPanel myVisibilityPanel;

    public IntroduceFieldDialogPanel(PsiClass parentClass, PsiExpression initializerExpression, PsiLocalVariable localVariable, boolean isCurrentMethodConstructor, boolean isInvokedOnDeclaration, boolean willBeDeclaredStatic, PsiExpression[] occurrences, boolean allowInitInMethod, boolean allowInitInMethodIfAll, TypeSelectorManager typeSelectorManager) {
        super(parentClass, initializerExpression, localVariable, isCurrentMethodConstructor, isInvokedOnDeclaration, willBeDeclaredStatic, occurrences, allowInitInMethod, allowInitInMethodIfAll, typeSelectorManager);
    }

    @Override
    protected void initializeControls(PsiExpression initializerExpression, BaseExpressionToFieldHandler.InitializationPlace ourLastInitializerPlace) {
        this.initializeInitializerPlace(initializerExpression, ourLastInitializerPlace);
        String ourLastVisibility = JavaRefactoringSettings.getInstance().INTRODUCE_FIELD_VISIBILITY;
        if (ourLastVisibility == null) {
            ourLastVisibility = "private";
        }
        this.myVisibilityPanel.setVisibility(ourLastVisibility);
        super.initializeControls(initializerExpression, ourLastInitializerPlace);
    }

    @Override
    protected void initializeInitializerPlace(PsiExpression initializerExpression, BaseExpressionToFieldHandler.InitializationPlace ourLastInitializerPlace) {
        if (initializerExpression != null) {
            this.setEnabledInitializationPlaces((PsiElement)initializerExpression);
            if (!this.myAllowInitInMethod) {
                this.myRbInCurrentMethod.setEnabled(false);
            }
        } else {
            this.myRbInConstructor.setEnabled(false);
            this.myRbInCurrentMethod.setEnabled(false);
            this.myRbInFieldDeclaration.setEnabled(false);
            if (this.myRbInSetUp != null) {
                this.myRbInSetUp.setEnabled(false);
            }
        }
        PsiMethod setUpMethod = TestFrameworks.getInstance().findSetUpMethod(this.myParentClass);
        if (this.myInitializerExpression != null && PsiTreeUtil.isAncestor((PsiElement)setUpMethod, (PsiElement)this.myInitializerExpression, (boolean)false) && this.myRbInSetUp.isEnabled() || ourLastInitializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_SETUP_METHOD && TestFrameworks.getInstance().isTestClass(this.myParentClass) && this.myRbInSetUp.isEnabled()) {
            this.myRbInSetUp.setSelected(true);
        } else if (ourLastInitializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR) {
            if (this.myRbInConstructor.isEnabled()) {
                this.myRbInConstructor.setSelected(true);
            } else {
                this.selectInCurrentMethod();
            }
        } else if (ourLastInitializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION) {
            if (this.myRbInFieldDeclaration.isEnabled()) {
                this.myRbInFieldDeclaration.setSelected(true);
            } else {
                this.selectInCurrentMethod();
            }
        } else {
            this.selectInCurrentMethod();
        }
    }

    private void selectInCurrentMethod() {
        if (this.myRbInCurrentMethod.isEnabled()) {
            this.myRbInCurrentMethod.setSelected(true);
        } else if (this.myRbInFieldDeclaration.isEnabled()) {
            this.myRbInFieldDeclaration.setSelected(true);
        } else {
            this.myRbInCurrentMethod.setSelected(true);
        }
    }

    @Override
    public BaseExpressionToFieldHandler.InitializationPlace getInitializerPlace() {
        if (this.myRbInConstructor.isSelected()) {
            return BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR;
        }
        if (this.myRbInCurrentMethod.isSelected()) {
            return BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD;
        }
        if (this.myRbInFieldDeclaration.isSelected()) {
            return BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION;
        }
        if (this.myRbInSetUp != null && this.myRbInSetUp.isSelected()) {
            return BaseExpressionToFieldHandler.InitializationPlace.IN_SETUP_METHOD;
        }
        LOG.assertTrue(false);
        return BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION;
    }

    @Override
    public String getFieldVisibility() {
        return this.myVisibilityPanel.getVisibility();
    }

    @Override
    protected JComponent createInitializerPlacePanel(ItemListener itemListener, ItemListener finalUpdater) {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JPanel initializationPanel = new JPanel();
        initializationPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"initialize.in.border.title"), (boolean)true));
        initializationPanel.setLayout(new BoxLayout(initializationPanel, 1));
        this.myRbInCurrentMethod = new JRadioButton();
        this.myRbInCurrentMethod.setFocusable(false);
        this.myRbInCurrentMethod.setText(RefactoringBundle.message((String)"current.method.radio"));
        this.myRbInCurrentMethod.setEnabled(this.myAllowInitInMethod);
        this.myRbInFieldDeclaration = new JRadioButton();
        this.myRbInFieldDeclaration.setFocusable(false);
        this.myRbInFieldDeclaration.setText(RefactoringBundle.message((String)"field.declaration.radio"));
        this.myRbInConstructor = new JRadioButton();
        this.myRbInConstructor.setFocusable(false);
        this.myRbInConstructor.setText(RefactoringBundle.message((String)"class.constructors.radio"));
        initializationPanel.add(this.myRbInCurrentMethod);
        initializationPanel.add(this.myRbInFieldDeclaration);
        initializationPanel.add(this.myRbInConstructor);
        if (TestFrameworks.getInstance().isTestClass(this.myParentClass)) {
            this.myRbInSetUp = new JRadioButton();
            this.myRbInSetUp.setFocusable(false);
            this.myRbInSetUp.setText(RefactoringBundle.message((String)"setup.method.radio"));
            initializationPanel.add(this.myRbInSetUp);
        }
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.myRbInCurrentMethod);
        bg.add(this.myRbInFieldDeclaration);
        bg.add(this.myRbInConstructor);
        if (this.myRbInSetUp != null) {
            bg.add(this.myRbInSetUp);
        }
        this.myRbInConstructor.addItemListener(itemListener);
        this.myRbInCurrentMethod.addItemListener(itemListener);
        this.myRbInFieldDeclaration.addItemListener(itemListener);
        this.myRbInConstructor.addItemListener(finalUpdater);
        this.myRbInCurrentMethod.addItemListener(finalUpdater);
        this.myRbInFieldDeclaration.addItemListener(finalUpdater);
        if (this.myRbInSetUp != null) {
            this.myRbInSetUp.addItemListener(finalUpdater);
        }
        JPanel groupPanel = new JPanel(new GridLayout(1, 2));
        groupPanel.add(initializationPanel);
        this.myVisibilityPanel = new JavaVisibilityPanel(false, false);
        groupPanel.add(this.myVisibilityPanel);
        mainPanel.add((Component)groupPanel, "Center");
        return mainPanel;
    }

    @Override
    protected boolean updateInitializationPlaceModel(boolean initializedInSetup, boolean initializedInConstructor) {
        this.myRbInFieldDeclaration.setEnabled(false);
        this.myRbInConstructor.setEnabled(initializedInConstructor);
        this.enableFinal(false);
        if (this.myRbInSetUp != null) {
            if (!initializedInSetup) {
                this.myRbInSetUp.setEnabled(false);
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean hasSetUpChoice() {
        return this.myRbInSetUp != null;
    }

    @Override
    public void setInitializeInFieldDeclaration() {
        this.myRbInFieldDeclaration.setSelected(true);
    }

    @Override
    public void setVisibility(String visibility) {
        this.myVisibilityPanel.setVisibility(visibility);
    }

    @Override
    protected boolean allowFinal() {
        boolean allowFinal;
        boolean bl = allowFinal = this.myRbInFieldDeclaration.isSelected() || this.myRbInConstructor.isSelected() && !this.myWillBeDeclaredStatic;
        if (this.myRbInCurrentMethod.isSelected() && this.myIsCurrentMethodConstructor) {
            PsiMethod[] constructors = this.myParentClass.getConstructors();
            allowFinal = constructors.length <= 1;
        }
        return super.allowFinal() && allowFinal;
    }

    @Override
    protected void updateInitializerSelection() {
        this.myRbInCurrentMethod.setEnabled(this.myAllowInitInMethodIfAll || !this.isReplaceAllOccurrences());
        if (!this.myRbInCurrentMethod.isEnabled() && this.myRbInCurrentMethod.isSelected()) {
            this.myRbInCurrentMethod.setSelected(false);
            this.myRbInFieldDeclaration.setSelected(true);
        }
    }

    @Override
    protected JPanel composeWholePanel(JComponent initializerPlacePanel, JPanel checkboxPanel) {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0);
        panel2.add((Component)initializerPlacePanel, constraints);
        panel2.add((Component)checkboxPanel, constraints);
        return panel2;
    }
}

