/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInstanceMethod;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveInstanceMembersUtil;
import com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodDialogBase;
import com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodHandler;
import com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodProcessor;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class MoveInstanceMethodDialog
extends MoveInstanceMethodDialogBase {
    @NonNls
    private static final String KEY = "#com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodDialog";
    private Map<PsiClass, Set<PsiMember>> myThisClassesMap;
    private Map<PsiClass, EditorTextField> myOldClassParameterNameFields;

    public MoveInstanceMethodDialog(PsiMethod method, PsiVariable[] variables) {
        super(method, variables, MoveInstanceMethodHandler.REFACTORING_NAME);
        this.init();
    }

    protected String getDimensionServiceKey() {
        return KEY;
    }

    protected JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        TitledSeparator separator = new TitledSeparator();
        mainPanel.add((Component)separator, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myList = this.createTargetVariableChooser();
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MoveInstanceMethodDialog.this.validateTextFields(e.getFirstIndex());
            }
        });
        separator.setText(RefactoringBundle.message((String)"moveInstanceMethod.select.an.instance.parameter"));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myList);
        mainPanel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myVisibilityPanel = MoveInstanceMethodDialog.createVisibilityPanel();
        mainPanel.add((Component)this.myVisibilityPanel, new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 17, 3, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel parametersPanel = this.createParametersPanel();
        if (parametersPanel != null) {
            mainPanel.add((Component)parametersPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        }
        mainPanel.add((Component)this.initOpenInEditorCb(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 13, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        separator.setLabelFor((Component)this.myList);
        this.validateTextFields(this.myList.getSelectedIndex());
        this.updateOnChanged(this.myList);
        return mainPanel;
    }

    private void validateTextFields(int selectedIndex) {
        PsiField field;
        PsiClass hisClass;
        Set<PsiMember> members;
        for (EditorTextField textField2 : this.myOldClassParameterNameFields.values()) {
            textField2.setEnabled(true);
        }
        Object variable = this.myVariables[selectedIndex];
        if (variable instanceof PsiField && (members = this.myThisClassesMap.get(hisClass = (field = (PsiField)variable).getContainingClass())) != null && members.size() == 1 && members.contains(field)) {
            this.myOldClassParameterNameFields.get(hisClass).setEnabled(false);
        }
    }

    @Nullable
    private JPanel createParametersPanel() {
        this.myThisClassesMap = MoveInstanceMembersUtil.getThisClassesToMembers((PsiMember)this.myMethod);
        this.myOldClassParameterNameFields = new HashMap();
        if (this.myThisClassesMap.size() == 0) {
            return null;
        }
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, true));
        for (PsiClass aClass : this.myThisClassesMap.keySet()) {
            String text2 = RefactoringBundle.message((String)"move.method.this.parameter.label", (Object[])new Object[]{ObjectUtils.notNull((Object)aClass.getName(), (Object)"")});
            panel2.add((Component)new TitledSeparator(text2, null));
            String suggestedName = MoveInstanceMethodHandler.suggestParameterNameForThisClass(aClass);
            EditorTextField field = new EditorTextField(suggestedName, this.getProject(), (FileType)StdFileTypes.JAVA);
            field.setMinimumSize(new Dimension(field.getPreferredSize()));
            this.myOldClassParameterNameFields.put(aClass, field);
            panel2.add((Component)((Object)field));
        }
        panel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        return panel2;
    }

    @Override
    protected void doAction() {
        LinkedHashMap<PsiClass, String> parameterNames = new LinkedHashMap<PsiClass, String>();
        for (PsiClass aClass : this.myThisClassesMap.keySet()) {
            EditorTextField field = this.myOldClassParameterNameFields.get(aClass);
            if (!field.isEnabled()) continue;
            String parameterName = field.getText().trim();
            if (!PsiNameHelper.getInstance((Project)this.myMethod.getProject()).isIdentifier(parameterName)) {
                Messages.showErrorDialog((Project)this.getProject(), (String)RefactoringBundle.message((String)"move.method.enter.a.valid.name.for.parameter"), (String)this.myRefactoringName);
                return;
            }
            parameterNames.put(aClass, parameterName);
        }
        PsiVariable targetVariable = (PsiVariable)this.myList.getSelectedValue();
        if (targetVariable == null) {
            return;
        }
        MoveInstanceMethodProcessor processor2 = new MoveInstanceMethodProcessor(this.myMethod.getProject(), this.myMethod, targetVariable, this.myVisibilityPanel.getVisibility(), this.isOpenInEditor(), parameterNames);
        if (!this.verifyTargetClass(processor2.getTargetClass())) {
            return;
        }
        this.saveOpenInEditorOption();
        this.invokeRefactoring(processor2);
    }

    @Override
    protected void updateOnChanged(JList list2) {
        super.updateOnChanged(list2);
        PsiVariable selectedValue = (PsiVariable)list2.getSelectedValue();
        if (selectedValue != null) {
            PsiClassType psiType = (PsiClassType)selectedValue.getType();
            PsiClass targetClass = psiType.resolve();
            UIUtil.setEnabled((Component)this.myVisibilityPanel, (targetClass != null && !targetClass.isInterface() ? 1 : 0) != 0, (boolean)true);
        }
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.moveInstMethod");
    }

    @Override
    protected String getMovePropertySuffix() {
        return "Instance";
    }

    @Override
    protected String getCbTitle() {
        return "Open moved method in editor";
    }
}

