/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.targets.AliasingPsiTargetMapper;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RenameAliasingPomTargetProcessor
extends RenamePsiElementProcessor {
    private static final Logger LOG = Logger.getInstance(RenameAliasingPomTargetProcessor.class);

    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenameAliasingPomTargetProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof PomTarget || element instanceof PomTargetPsiElement;
    }

    @Override
    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        PomTarget target2 = null;
        if (element instanceof PomTargetPsiElement) {
            target2 = ((PomTargetPsiElement)element).getTarget();
        } else if (element instanceof PomTarget) {
            target2 = (PomTarget)element;
        }
        if (target2 != null) {
            for (AliasingPsiTargetMapper mapper : (AliasingPsiTargetMapper[])Extensions.getExtensions((ExtensionPointName)AliasingPsiTargetMapper.EP_NAME)) {
                for (AliasingPsiTarget psiTarget : mapper.getTargets(target2)) {
                    String name2;
                    PsiElement psiElement = PomService.convertToPsi((PsiTarget)psiTarget);
                    String definedName = allRenames.put(psiElement, name2 = psiTarget.getNameAlias(newName));
                    if (definedName != null) {
                        LOG.assertTrue(definedName.equals(name2), (Object)("target: " + psiTarget + "; defined name: " + definedName + "; name: " + name2 + "; mapper: " + mapper));
                        continue;
                    }
                    this.prepareRenaming(psiElement, name2, allRenames);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenameAliasingPomTargetProcessor", "canProcessElement"));
    }
}

