/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.replaceConstructorWithFactory;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.replaceConstructorWithFactory.ReplaceConstructorWithFactoryHandler;
import com.intellij.refactoring.replaceConstructorWithFactory.ReplaceConstructorWithFactoryProcessor;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.JavaReferenceEditorUtil;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ReplaceConstructorWithFactoryDialog
extends RefactoringDialog {
    private NameSuggestionsField myNameField;
    private final ReferenceEditorWithBrowseButton myTfTargetClassName;
    private JComboBox myTargetClassNameCombo;
    private final PsiClass myContainingClass;
    private final PsiMethod myConstructor;
    private final boolean myIsInner;
    private NameSuggestionsField.DataChanged myNameChangedListener;

    ReplaceConstructorWithFactoryDialog(Project project2, PsiMethod constructor, PsiClass containingClass) {
        super(project2, true);
        this.myContainingClass = containingClass;
        this.myConstructor = constructor;
        this.myIsInner = this.myContainingClass.getContainingClass() != null && !this.myContainingClass.hasModifierProperty("static");
        this.setTitle(ReplaceConstructorWithFactoryHandler.REFACTORING_NAME);
        this.myTfTargetClassName = JavaReferenceEditorUtil.createReferenceEditorWithBrowseButton(new ChooseClassAction(), "", project2, true);
        this.init();
    }

    protected void dispose() {
        this.myNameField.removeDataChangedListener(this.myNameChangedListener);
        super.dispose();
    }

    public String getName() {
        return this.myNameField.getEnteredName();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.replaceConstrWithFactory");
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField.getFocusableComponent();
    }

    public String getTargetClassName() {
        if (!this.myIsInner) {
            return this.myTfTargetClassName.getText();
        }
        return (String)this.myTargetClassNameCombo.getSelectedItem();
    }

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = JBUI.insets((int)4, (int)0, (int)4, (int)8);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel2.add((Component)new JLabel(RefactoringBundle.message((String)"factory.method.name.label")), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        String[] nameSuggestions = new String[]{"create" + this.myContainingClass.getName(), "new" + this.myContainingClass.getName(), "getInstance", "newInstance"};
        this.myNameField = new NameSuggestionsField(nameSuggestions, this.getProject());
        this.myNameChangedListener = () -> this.validateButtons();
        this.myNameField.addDataChangedListener(this.myNameChangedListener);
        panel2.add((Component)this.myNameField.getComponent(), gbc);
        JPanel targetClassPanel = this.createTargetPanel();
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        panel2.add((Component)targetClassPanel, gbc);
        return panel2;
    }

    private JPanel createTargetPanel() {
        JPanel targetClassPanel = new JPanel(new BorderLayout());
        if (!this.myIsInner) {
            JLabel label = new JLabel(RefactoringBundle.message((String)"replace.constructor.with.factory.target.fq.name"));
            label.setLabelFor((Component)((Object)this.myTfTargetClassName));
            targetClassPanel.add((Component)label, "North");
            targetClassPanel.add((Component)((Object)this.myTfTargetClassName), "Center");
            this.myTfTargetClassName.setText(this.myContainingClass.getQualifiedName());
        } else {
            ArrayList<String> list2 = new ArrayList<String>();
            PsiClass parent = this.myContainingClass;
            while (parent instanceof PsiClass) {
                list2.add(parent.getQualifiedName());
                parent = parent.getParent();
            }
            this.myTargetClassNameCombo = new JComboBox<String>(ArrayUtil.toStringArray(list2));
            JLabel label = new JLabel(RefactoringBundle.message((String)"replace.constructor.with.factory.target.fq.name"));
            label.setLabelFor(this.myTargetClassNameCombo.getEditor().getEditorComponent());
            targetClassPanel.add((Component)label, "North");
            targetClassPanel.add((Component)this.myTargetClassNameCombo, "Center");
        }
        return targetClassPanel;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.replaceConstructorWithFactory.ReplaceConstructorWithFactoryDialog";
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    @Override
    protected void doAction() {
        Project project2 = this.getProject();
        PsiManager manager = PsiManager.getInstance((Project)project2);
        String targetClassName = this.getTargetClassName();
        PsiClass targetClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(targetClassName, GlobalSearchScope.allScope((Project)project2));
        if (targetClass == null) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"class.0.not.found", (Object[])new Object[]{targetClassName}));
            CommonRefactoringUtil.showErrorMessage((String)ReplaceConstructorWithFactoryHandler.REFACTORING_NAME, (String)message2, (String)"refactoring.replaceConstrWithFactory", (Project)project2);
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)targetClass)) {
            return;
        }
        this.invokeRefactoring(new ReplaceConstructorWithFactoryProcessor(project2, this.myConstructor, this.myContainingClass, targetClass, this.getName()));
    }

    @Override
    protected void canRun() throws ConfigurationException {
        String name2 = this.myNameField.getEnteredName();
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)this.myContainingClass.getProject());
        if (!nameHelper.isIdentifier(name2)) {
            throw new ConfigurationException("'" + name2 + "' is invalid factory method name");
        }
    }

    private class ChooseClassAction
    implements ActionListener {
        private ChooseClassAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)ReplaceConstructorWithFactoryDialog.this.getProject()).createProjectScopeChooser(RefactoringBundle.message((String)"choose.destination.class"));
            chooser.selectDirectory(ReplaceConstructorWithFactoryDialog.this.myContainingClass.getContainingFile().getContainingDirectory());
            chooser.showDialog();
            PsiClass aClass = chooser.getSelected();
            if (aClass != null) {
                ReplaceConstructorWithFactoryDialog.this.myTfTargetClassName.setText(aClass.getQualifiedName());
            }
        }
    }
}

