/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete.usageInfo;

import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiStatement;
import com.intellij.refactoring.safeDelete.ImportSearcher;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceSimpleDeleteUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;

public class SafeDeleteReferenceJavaDeleteUsageInfo
extends SafeDeleteReferenceSimpleDeleteUsageInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceJavaDeleteUsageInfo");

    public SafeDeleteReferenceJavaDeleteUsageInfo(PsiElement element, PsiElement referencedElement, boolean isSafeDelete) {
        super(element, referencedElement, isSafeDelete);
    }

    public SafeDeleteReferenceJavaDeleteUsageInfo(PsiElement element, PsiElement referencedElement, int startOffset, int endOffset, boolean isNonCodeUsage, boolean isSafeDelete) {
        super(element, referencedElement, startOffset, endOffset, isNonCodeUsage, isSafeDelete);
    }

    public SafeDeleteReferenceJavaDeleteUsageInfo(PsiExpression expression2, PsiElement referenceElement) {
        this((PsiElement)expression2, referenceElement, !RemoveUnusedVariableUtil.checkSideEffects(expression2, null, new ArrayList<PsiElement>()));
    }

    @Override
    public void deleteElement() throws IncorrectOperationException {
        if (this.isSafeDelete()) {
            PsiElement element = this.getElement();
            LOG.assertTrue(element != null);
            PsiElement importStatement = ImportSearcher.getImport(element, false);
            if (importStatement != null) {
                if (element instanceof PsiImportStaticReferenceElement) {
                    if (((PsiImportStaticReferenceElement)element).multiResolve(false).length < 2) {
                        importStatement.delete();
                    }
                } else {
                    importStatement.delete();
                }
            } else if (element instanceof PsiExpressionStatement && RefactoringUtil.isLoopOrIf(element.getParent())) {
                PsiStatement emptyTest = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createStatementFromText(";", null);
                element.replace((PsiElement)emptyTest);
            } else {
                element.delete();
            }
        }
    }
}

