/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeCook;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.Bottom;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVariable;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeCook.Settings;
import com.intellij.refactoring.typeCook.deductive.PsiTypeVariableFactory;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Util {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.typeCook.Util");

    public static PsiType createArrayType(PsiType theType, int level) {
        while (level-- > 0) {
            theType = theType.createArrayType();
        }
        return theType;
    }

    public static PsiClassType.ClassResolveResult resolveType(PsiType type2) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)type2);
        PsiClass aClass = resolveResult.getElement();
        if (aClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)aClass).getBaseClassType();
            return Util.resolveType(resolveResult.getSubstitutor().substitute((PsiType)baseClassType));
        }
        return resolveResult;
    }

    public static PsiType normalize(PsiType t, boolean objectBottom) {
        if (t instanceof PsiArrayType) {
            PsiType normType = Util.normalize(((PsiArrayType)t).getComponentType(), objectBottom);
            return normType == null ? null : normType.createArrayType();
        }
        if (t instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result2 = Util.resolveType(t);
            if (result2 == null) {
                return null;
            }
            PsiClass aclass = result2.getElement();
            PsiSubstitutor subst = result2.getSubstitutor();
            PsiManager manager = aclass.getManager();
            PsiSubstitutor newbst = PsiSubstitutor.EMPTY;
            boolean anyBottom = false;
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aclass)) {
                PsiType p = subst.substitute(typeParameter);
                if (p != null) {
                    PsiType pp = Util.normalize(p, objectBottom);
                    if (pp == null) {
                        return null;
                    }
                    if (pp == Bottom.BOTTOM || objectBottom && pp.getCanonicalText().equals("java.lang.Object")) {
                        anyBottom = true;
                    }
                    newbst = newbst.put(typeParameter, pp);
                    continue;
                }
                anyBottom = true;
            }
            if (anyBottom || newbst == PsiSubstitutor.EMPTY) {
                newbst = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createRawSubstitutor((PsiTypeParameterListOwner)aclass);
            }
            return JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createType(aclass, newbst);
        }
        return t;
    }

    public static boolean isRaw(PsiType t, Settings settings) {
        return Util.isRaw(t, settings, true);
    }

    private static boolean isRaw(PsiType t, Settings settings, boolean upper) {
        if (t instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = Util.resolveType(t);
            if (resolveResult.getElement() == null) {
                return false;
            }
            if (PsiClassType.isRaw((PsiClassType.ClassResolveResult)resolveResult)) {
                return true;
            }
            PsiSubstitutor subst = resolveResult.getSubstitutor();
            PsiClass element = resolveResult.getElement();
            PsiManager manager = element.getManager();
            if (settings.cookObjects() && upper && t.equals(PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)manager.getProject())))) {
                return true;
            }
            for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)element)) {
                PsiType actual = subst.substitute(parameter2);
                if (!Util.isRaw(actual, settings, false)) continue;
                return true;
            }
            return false;
        }
        if (t instanceof PsiArrayType) {
            return !settings.preserveRawArrays() && Util.isRaw(((PsiArrayType)t).getComponentType(), settings, upper);
        }
        return false;
    }

    public static PsiType banalize(PsiType t) {
        if (t instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result2 = Util.resolveType(t);
            PsiClass theClass = result2.getElement();
            if (theClass == null) {
                return t;
            }
            PsiSubstitutor theSubst = result2.getSubstitutor();
            PsiManager theManager = theClass.getManager();
            PsiSubstitutor subst = PsiSubstitutor.EMPTY;
            for (PsiTypeParameter theParm : theSubst.getSubstitutionMap().keySet()) {
                PsiType actualType = theSubst.substitute(theParm);
                if (actualType == null) {
                    subst = subst.put(theParm, (PsiType)Bottom.BOTTOM);
                    continue;
                }
                if (actualType instanceof PsiWildcardType) {
                    PsiWildcardType wctype = (PsiWildcardType)actualType;
                    PsiType bound = wctype.getBound();
                    if (bound == null) {
                        subst = subst.put(theParm, actualType);
                        continue;
                    }
                    PsiType banabound = Util.banalize(bound);
                    subst = subst.put(theParm, (PsiType)(wctype.isExtends() ? PsiWildcardType.createExtends((PsiManager)theManager, (PsiType)banabound) : PsiWildcardType.createSuper((PsiManager)theManager, (PsiType)banabound)));
                    continue;
                }
                PsiType banType = Util.banalize(actualType);
                if (banType == null) {
                    return t;
                }
                subst = subst.put(theParm, banType);
            }
            return JavaPsiFacade.getInstance((Project)theManager.getProject()).getElementFactory().createType(theClass, subst);
        }
        if (t instanceof PsiArrayType) {
            return Util.banalize(((PsiArrayType)t).getComponentType()).createArrayType();
        }
        return t;
    }

    public static PsiSubstitutor composeSubstitutors(PsiSubstitutor f, PsiSubstitutor g) {
        if (f == PsiSubstitutor.EMPTY) {
            return g;
        }
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        Set base = g.getSubstitutionMap().keySet();
        Iterator iterator = base.iterator();
        while (iterator.hasNext()) {
            PsiTypeParameter p;
            PsiType type2 = g.substitute(p = (PsiTypeParameter)iterator.next());
            subst = subst.put(p, type2 == null ? null : f.substitute(type2));
        }
        return subst;
    }

    public static boolean bindsTypeParameters(PsiType t, Set<PsiTypeParameter> params) {
        if (t instanceof PsiWildcardType) {
            PsiWildcardType wct = (PsiWildcardType)t;
            PsiType bound = wct.getBound();
            return bound != null && wct.isExtends() && Util.bindsTypeParameters(bound, params);
        }
        PsiClassType.ClassResolveResult result2 = Util.resolveType(t);
        PsiClass theClass = result2.getElement();
        PsiSubstitutor theSubst = result2.getSubstitutor();
        if (theClass == null) {
            return false;
        }
        if (theClass instanceof PsiTypeParameter) {
            return params == null || params.contains(theClass);
        }
        if (theClass.hasTypeParameters()) {
            for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)theClass)) {
                PsiType bound = theSubst.substitute(parameter2);
                if (bound == null || !Util.bindsTypeParameters(bound, params)) continue;
                return true;
            }
        }
        return false;
    }

    public static PsiType getType(PsiElement element) {
        if (element instanceof PsiVariable) {
            return ((PsiVariable)element).getType();
        }
        if (element instanceof PsiExpression) {
            return ((PsiExpression)element).getType();
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getReturnType();
        }
        return null;
    }

    public static PsiType createParameterizedType(PsiType t, PsiTypeVariableFactory factory, PsiElement context) {
        return Util.createParameterizedType(t, factory, true, context);
    }

    public static PsiType createParameterizedType(PsiType t, PsiTypeVariableFactory factory) {
        return Util.createParameterizedType(t, factory, true, null);
    }

    private static PsiType createParameterizedType(PsiType t, PsiTypeVariableFactory factory, boolean upper, PsiElement context) {
        if (t == null || upper && t.getCanonicalText().equals("java.lang.Object")) {
            return factory.create(context);
        }
        if (t instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result2 = Util.resolveType(t);
            PsiSubstitutor aSubst = result2.getSubstitutor();
            PsiClass aClass = result2.getElement();
            PsiSubstitutor theSubst = PsiSubstitutor.EMPTY;
            HashSet<PsiTypeVariable> cluster = new HashSet<PsiTypeVariable>();
            for (PsiTypeParameter parm : aSubst.getSubstitutionMap().keySet()) {
                PsiType type2 = Util.createParameterizedType(aSubst.substitute(parm), factory, false, context);
                if (type2 instanceof PsiTypeVariable) {
                    cluster.add((PsiTypeVariable)type2);
                }
                theSubst = theSubst.put(parm, type2);
            }
            if (cluster.size() > 1) {
                factory.registerCluster(cluster);
            }
            return JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aClass, theSubst);
        }
        if (t instanceof PsiArrayType) {
            return Util.createParameterizedType(((PsiArrayType)t).getComponentType(), factory, upper, context).createArrayType();
        }
        return t;
    }

    public static boolean bindsTypeVariables(PsiType t) {
        if (t == null) {
            return false;
        }
        if (t instanceof PsiTypeVariable) {
            return true;
        }
        if (t instanceof PsiArrayType) {
            return Util.bindsTypeVariables(((PsiArrayType)t).getComponentType());
        }
        if (t instanceof PsiWildcardType) {
            return Util.bindsTypeVariables(((PsiWildcardType)t).getBound());
        }
        if (t instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)t).getConjuncts()) {
                if (!Util.bindsTypeVariables(conjunct)) continue;
                return true;
            }
            return false;
        }
        PsiClassType.ClassResolveResult result2 = Util.resolveType(t);
        if (result2.getElement() != null) {
            PsiSubstitutor subst = result2.getSubstitutor();
            for (PsiType psiType : subst.getSubstitutionMap().values()) {
                if (!Util.bindsTypeVariables(psiType)) continue;
                return true;
            }
        }
        return false;
    }

    public static void changeType(PsiElement element, PsiType type2) {
        try {
            if (element instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression cast = (PsiTypeCastExpression)element;
                cast.getCastType().replace((PsiElement)JavaPsiFacade.getInstance((Project)cast.getProject()).getElementFactory().createTypeElement(type2));
            } else if (element instanceof PsiVariable) {
                PsiVariable field = (PsiVariable)element;
                field.normalizeDeclaration();
                field.getTypeElement().replace((PsiElement)JavaPsiFacade.getInstance((Project)field.getProject()).getElementFactory().createTypeElement(type2));
            } else if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                method.getReturnTypeElement().replace((PsiElement)JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createTypeElement(type2));
            } else if (element instanceof PsiNewExpression) {
                PsiNewExpression newx = (PsiNewExpression)element;
                PsiClassType.ClassResolveResult result2 = Util.resolveType(type2);
                if (result2 == null) {
                    return;
                }
                PsiSubstitutor subst = result2.getSubstitutor();
                PsiTypeParameter[] parms = result2.getElement().getTypeParameters();
                if (parms.length > 0 && subst.substitute(parms[0]) != null) {
                    PsiTypeElement[] elements;
                    PsiJavaCodeReferenceElement classReference2 = newx.getClassOrAnonymousClassReference();
                    PsiReferenceParameterList list2 = classReference2.getParameterList();
                    if (list2 == null) {
                        return;
                    }
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)newx.getProject()).getElementFactory();
                    for (PsiTypeElement psiTypeElement : elements = list2.getTypeParameterElements()) {
                        psiTypeElement.delete();
                    }
                    for (PsiTypeElement psiTypeElement : parms) {
                        PsiType aType = subst.substitute((PsiTypeParameter)psiTypeElement);
                        if (aType instanceof PsiWildcardType) {
                            aType = ((PsiWildcardType)aType).getBound();
                        }
                        list2.add((PsiElement)factory.createTypeElement((PsiType)(aType == null ? PsiType.getJavaLangObject((PsiManager)list2.getManager(), (GlobalSearchScope)list2.getResolveScope()) : aType)));
                    }
                    if (PsiDiamondTypeUtil.canCollapseToDiamond(newx, newx, newx.getType())) {
                        PsiDiamondTypeUtil.replaceExplicitWithDiamond((PsiElement)list2);
                    }
                }
            } else {
                LOG.error("Unexpected element type " + element.getClass().getName());
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error("Incorrect Operation Exception thrown in CastRole.\n");
        }
    }
}

