/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeCook.deductive.builder;

import com.intellij.openapi.project.Project;
import com.intellij.psi.Bottom;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.typeCook.Settings;
import com.intellij.refactoring.typeCook.Util;
import com.intellij.refactoring.typeCook.deductive.PsiTypeVariableFactory;
import com.intellij.refactoring.typeCook.deductive.builder.Constraint;
import com.intellij.refactoring.typeCook.deductive.builder.Subtype;
import com.intellij.refactoring.typeCook.deductive.resolver.Binding;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class ReductionSystem {
    final Set<Constraint> myConstraints = new HashSet<Constraint>();
    final Set<PsiElement> myElements;
    final Map<PsiTypeCastExpression, PsiType> myCastToOperandType;
    final Map<PsiElement, PsiType> myTypes;
    final PsiTypeVariableFactory myTypeVariableFactory;
    final Project myProject;
    final Settings mySettings;
    Set<PsiTypeVariable> myBoundVariables;

    public ReductionSystem(Project project2, Set<PsiElement> elements, Map<PsiElement, PsiType> types, PsiTypeVariableFactory factory, Settings settings) {
        this.myProject = project2;
        this.myElements = elements;
        this.myTypes = types;
        this.myTypeVariableFactory = factory;
        this.myBoundVariables = null;
        this.mySettings = settings;
        this.myCastToOperandType = new HashMap<PsiTypeCastExpression, PsiType>();
    }

    public Project getProject() {
        return this.myProject;
    }

    public Set<Constraint> getConstraints() {
        return this.myConstraints;
    }

    public void addCast(PsiTypeCastExpression cast, PsiType operandType) {
        this.myCastToOperandType.put(cast, operandType);
    }

    public void addSubtypeConstraint(PsiType left, PsiType right) {
        Subtype c;
        if (left instanceof PsiPrimitiveType) {
            left = ((PsiPrimitiveType)left).getBoxedType(PsiManager.getInstance((Project)this.myProject), GlobalSearchScope.allScope((Project)this.myProject));
        }
        if (right instanceof PsiPrimitiveType) {
            right = ((PsiPrimitiveType)right).getBoxedType(PsiManager.getInstance((Project)this.myProject), GlobalSearchScope.allScope((Project)this.myProject));
        }
        if (left == null || right == null) {
            return;
        }
        if ((Util.bindsTypeVariables(left) || Util.bindsTypeVariables(right)) && !this.myConstraints.contains(c = new Subtype(left, right))) {
            this.myConstraints.add(c);
        }
    }

    private static String memberString(PsiMember member) {
        return member.getContainingClass().getQualifiedName() + "." + member.getName();
    }

    private static String variableString(PsiLocalVariable var) {
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)var, PsiMethod.class);
        return ReductionSystem.memberString((PsiMember)method) + "#" + var.getName();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Victims:\n");
        for (PsiElement element : this.myElements) {
            PsiType type2 = this.myTypes.get(element);
            if (type2 == null) continue;
            if (element instanceof PsiParameter) {
                PsiParameter parm = (PsiParameter)element;
                PsiElement declarationScope = parm.getDeclarationScope();
                if (declarationScope instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)declarationScope;
                    buffer.append("   parameter " + method.getParameterList().getParameterIndex(parm) + " of " + ReductionSystem.memberString((PsiMember)method));
                } else {
                    buffer.append("   parameter of foreach");
                }
            } else if (element instanceof PsiField) {
                buffer.append("   field " + ReductionSystem.memberString((PsiMember)((PsiField)element)));
            } else if (element instanceof PsiLocalVariable) {
                buffer.append("   local " + ReductionSystem.variableString((PsiLocalVariable)element));
            } else if (element instanceof PsiMethod) {
                buffer.append("   return of " + ReductionSystem.memberString((PsiMember)((PsiMethod)element)));
            } else if (element instanceof PsiNewExpression) {
                buffer.append("   " + element.getText());
            } else if (element instanceof PsiTypeCastExpression) {
                buffer.append("   " + element.getText());
            } else {
                buffer.append("   unknown: " + (element == null ? "null" : element.getClass().getName()));
            }
            buffer.append(" " + type2.getCanonicalText() + "\n");
        }
        buffer.append("Variables: " + this.myTypeVariableFactory.getNumber() + "\n");
        buffer.append("Bound variables: ");
        if (this.myBoundVariables == null) {
            buffer.append(" not specified\n");
        } else {
            for (PsiTypeVariable boundVariable : this.myBoundVariables) {
                buffer.append(boundVariable.getIndex() + ", ");
            }
        }
        buffer.append("Constraints: " + this.myConstraints.size() + "\n");
        for (Constraint constraint : this.myConstraints) {
            buffer.append("   " + constraint + "\n");
        }
        return buffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public ReductionSystem[] isolate() {
        void var9_26;
        class Node {
            int myComponent = -1;
            Constraint myConstraint;
            Set<Node> myNeighbours = new HashSet<Node>();

            public Node() {
                this.myConstraint = null;
            }

            public Node(Constraint c) {
                this.myConstraint = c;
            }

            public Constraint getConstraint() {
                return this.myConstraint;
            }

            public void addEdge(Node n) {
                if (!this.myNeighbours.contains(n)) {
                    this.myNeighbours.add(n);
                    n.addEdge(this);
                }
            }
        }
        Node[] typeVariableNodes = new Node[this.myTypeVariableFactory.getNumber()];
        Node[] constraintNodes = new Node[this.myConstraints.size()];
        HashMap boundVariables = new HashMap();
        for (int i = 0; i < typeVariableNodes.length; ++i) {
            typeVariableNodes[i] = new Node();
        }
        int j = 0;
        for (Constraint constraint : this.myConstraints) {
            constraintNodes[j++] = new Node(constraint);
        }
        int l = 0;
        for (Constraint constraint : this.myConstraints) {
            final LinkedHashSet boundVars = new LinkedHashSet();
            Node constraintNode = constraintNodes[l++];
            new Object(){

                void visit(Constraint c) {
                    this.visit(c.getLeft());
                    this.visit(c.getRight());
                }

                private void visit(PsiType t) {
                    PsiType bound;
                    if (t instanceof PsiTypeVariable) {
                        boundVars.add((PsiTypeVariable)t);
                    } else if (t instanceof PsiArrayType) {
                        this.visit(t.getDeepComponentType());
                    } else if (t instanceof PsiClassType) {
                        PsiSubstitutor subst = Util.resolveType(t).getSubstitutor();
                        for (PsiType type2 : subst.getSubstitutionMap().values()) {
                            this.visit(type2);
                        }
                    } else if (t instanceof PsiIntersectionType) {
                        PsiType[] conjuncts;
                        for (PsiType conjunct : conjuncts = ((PsiIntersectionType)t).getConjuncts()) {
                            this.visit(conjunct);
                        }
                    } else if (t instanceof PsiWildcardType && (bound = ((PsiWildcardType)t).getBound()) != null) {
                        this.visit(bound);
                    }
                }
            }.visit(constraint);
            PsiTypeVariable[] psiTypeVariableArray = boundVars.toArray(new PsiTypeVariable[0]);
            for (int j2 = 0; j2 < psiTypeVariableArray.length; ++j2) {
                int x = psiTypeVariableArray[j2].getIndex();
                Node typeVariableNode = typeVariableNodes[x];
                typeVariableNode.addEdge(constraintNode);
                for (int k = j2 + 1; k < psiTypeVariableArray.length; ++k) {
                    int y = psiTypeVariableArray[k].getIndex();
                    typeVariableNode.addEdge(typeVariableNodes[y]);
                }
            }
            boundVariables.put(constraint, boundVars);
        }
        List<Set<PsiTypeVariable>> clusters = this.myTypeVariableFactory.getClusters();
        for (Set set2 : clusters) {
            Node prev = null;
            for (PsiTypeVariable psiTypeVariable : set2) {
                Node curr = typeVariableNodes[psiTypeVariable.getIndex()];
                if (prev != null) {
                    prev.addEdge(curr);
                }
                prev = curr;
            }
        }
        int currComponent = 0;
        for (Node node : typeVariableNodes) {
            if (node.myComponent != -1) continue;
            final int component = currComponent++;
            new Object(){

                void selectComponent(Node n) {
                    LinkedList<Node> frontier = new LinkedList<Node>();
                    frontier.addFirst(n);
                    while (frontier.size() > 0) {
                        Node curr = (Node)frontier.removeFirst();
                        curr.myComponent = component;
                        for (Node p : curr.myNeighbours) {
                            if (p.myComponent != -1) continue;
                            frontier.addFirst(p);
                        }
                    }
                }
            }.selectComponent(node);
        }
        ReductionSystem[] reductionSystemArray = new ReductionSystem[currComponent];
        Node[] nodeArray = constraintNodes;
        int n = nodeArray.length;
        boolean bl = false;
        while (var9_26 < n) {
            Node node = nodeArray[var9_26];
            Constraint constraint = node.getConstraint();
            int index = node.myComponent;
            if (reductionSystemArray[index] == null) {
                reductionSystemArray[index] = new ReductionSystem(this.myProject, this.myElements, this.myTypes, this.myTypeVariableFactory, this.mySettings);
            }
            reductionSystemArray[index].addConstraint(constraint, (Set)boundVariables.get(constraint));
            ++var9_26;
        }
        return reductionSystemArray;
    }

    private void addConstraint(Constraint constraint, Set<PsiTypeVariable> vars) {
        if (this.myBoundVariables == null) {
            this.myBoundVariables = vars;
        } else {
            this.myBoundVariables.addAll(vars);
        }
        this.myConstraints.add(constraint);
    }

    public PsiTypeVariableFactory getVariableFactory() {
        return this.myTypeVariableFactory;
    }

    public Set<PsiTypeVariable> getBoundVariables() {
        return this.myBoundVariables;
    }

    @NonNls
    public String dumpString() {
        String[] data = new String[this.myElements.size()];
        int i = 0;
        for (PsiElement element : this.myElements) {
            data[i++] = Util.getType(element).getCanonicalText() + "\\n" + ReductionSystem.elementString(element);
        }
        Arrays.sort(data, (x, y) -> x.compareTo((String)y));
        StringBuffer repr = new StringBuffer();
        for (String aData : data) {
            repr.append(aData);
            repr.append("\n");
        }
        return repr.toString();
    }

    @NonNls
    private static String elementString(PsiElement element) {
        PsiElement scope;
        if (element instanceof PsiNewExpression) {
            return "new";
        }
        if (element instanceof PsiParameter && (scope = ((PsiParameter)element).getDeclarationScope()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)scope;
            return "parameter " + method.getParameterList().getParameterIndex((PsiParameter)element) + " of " + method.getName();
        }
        if (element instanceof PsiMethod) {
            return "return of " + ((PsiMethod)element).getName();
        }
        return element.toString();
    }

    public String dumpResult(final Binding bestBinding) {
        String[] data = new String[this.myElements.size()];
        class Substitutor {
            Substitutor() {
            }

            PsiType substitute(PsiType t) {
                if (t instanceof PsiWildcardType) {
                    PsiWildcardType wcType = (PsiWildcardType)t;
                    PsiType bound = wcType.getBound();
                    if (bound == null) {
                        return t;
                    }
                    PsiManager manager = PsiManager.getInstance((Project)ReductionSystem.this.myProject);
                    PsiType subst = this.substitute(bound);
                    return subst == null || subst instanceof PsiWildcardType ? subst : (wcType.isExtends() ? PsiWildcardType.createExtends((PsiManager)manager, (PsiType)subst) : PsiWildcardType.createSuper((PsiManager)manager, (PsiType)subst));
                }
                if (t instanceof PsiTypeVariable) {
                    if (bestBinding != null) {
                        PsiType b = bestBinding.apply(t);
                        if (b instanceof Bottom || b instanceof PsiTypeVariable) {
                            return null;
                        }
                        return this.substitute(b);
                    }
                    return null;
                }
                if (t instanceof Bottom) {
                    return null;
                }
                if (t instanceof PsiArrayType) {
                    return this.substitute(((PsiArrayType)t).getComponentType()).createArrayType();
                }
                if (t instanceof PsiClassType) {
                    PsiClassType.ClassResolveResult result2 = ((PsiClassType)t).resolveGenerics();
                    PsiClass aClass = result2.getElement();
                    PsiSubstitutor aSubst = result2.getSubstitutor();
                    if (aClass == null) {
                        return t;
                    }
                    PsiSubstitutor theSubst = PsiSubstitutor.EMPTY;
                    for (PsiTypeParameter parm : aSubst.getSubstitutionMap().keySet()) {
                        PsiType type2 = aSubst.substitute(parm);
                        theSubst = theSubst.put(parm, this.substitute(type2));
                    }
                    return JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aClass, theSubst);
                }
                return t;
            }
        }
        Substitutor binding = new Substitutor();
        int i = 0;
        for (PsiElement element : this.myElements) {
            PsiType t = this.myTypes.get(element);
            if (t != null) {
                data[i++] = binding.substitute(t).getCanonicalText() + "\\n" + ReductionSystem.elementString(element);
                continue;
            }
            data[i++] = "\\n" + ReductionSystem.elementString(element);
        }
        Arrays.sort(data, (x, y) -> x.compareTo((String)y));
        StringBuffer repr = new StringBuffer();
        for (String aData : data) {
            repr.append(aData);
            repr.append("\n");
        }
        return repr.toString();
    }

    public Settings getSettings() {
        return this.mySettings;
    }
}

