/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.util.containers.HashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeEvaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.typeMigration.TypeEvaluator");
    private final HashMap<TypeMigrationUsageInfo, LinkedList<PsiType>> myTypeMap;
    private final TypeMigrationRules myRules;
    private final TypeMigrationLabeler myLabeler;
    private final ProjectFileIndex myProjectFileIndex;

    public TypeEvaluator(LinkedList<Pair<TypeMigrationUsageInfo, PsiType>> types, TypeMigrationLabeler labeler, Project project2) {
        this.myLabeler = labeler;
        this.myRules = labeler == null ? new TypeMigrationRules(project2) : labeler.getRules();
        this.myTypeMap = new HashMap();
        if (types != null) {
            for (Pair pair2 : types) {
                if (((TypeMigrationUsageInfo)((Object)pair2.getFirst())).getElement() instanceof PsiExpression) continue;
                LinkedList<Object> e = new LinkedList<Object>();
                e.addFirst(pair2.getSecond());
                this.myTypeMap.put(pair2.getFirst(), e);
            }
        }
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
    }

    public boolean setType(TypeMigrationUsageInfo usageInfo, @NotNull PsiType type2) {
        if (type2 == null) {
            TypeEvaluator.$$$reportNull$$$0(0);
        }
        LinkedList t = (LinkedList)this.myTypeMap.get((Object)usageInfo);
        PsiElement element = usageInfo.getElement();
        if (!(!(type2 instanceof PsiEllipsisType) || element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiMethod)) {
            type2 = ((PsiEllipsisType)type2).toArrayType();
        }
        if (t != null) {
            if (!((PsiType)t.getFirst()).equals(type2)) {
                if (element instanceof PsiVariable || element instanceof PsiMethod) {
                    return false;
                }
                t.addFirst(type2);
                return true;
            }
        } else {
            LinkedList<PsiType> e = new LinkedList<PsiType>();
            e.addFirst(type2);
            usageInfo.setOwnerRoot(this.myLabeler.getCurrentRoot());
            this.myTypeMap.put((Object)usageInfo, e);
            return true;
        }
        return false;
    }

    @Nullable
    public PsiType getType(PsiElement element) {
        VirtualFile file2 = element.getContainingFile().getVirtualFile();
        if (file2 == null || !this.myProjectFileIndex.isInContent(file2)) {
            return TypeMigrationLabeler.getElementType(element);
        }
        for (Map.Entry entry : this.myTypeMap.entrySet()) {
            if (!Comparing.equal((Object)element, (Object)((TypeMigrationUsageInfo)((Object)entry.getKey())).getElement())) continue;
            return (PsiType)((LinkedList)entry.getValue()).getFirst();
        }
        if (element.getTextRange() == null) {
            return null;
        }
        return this.getType(new TypeMigrationUsageInfo(element));
    }

    @Nullable
    public PsiType getType(TypeMigrationUsageInfo usageInfo) {
        LinkedList e = (LinkedList)this.myTypeMap.get((Object)usageInfo);
        if (e != null) {
            return (PsiType)e.getFirst();
        }
        return TypeMigrationLabeler.getElementType(usageInfo.getElement());
    }

    @Nullable
    public PsiType evaluateType(PsiExpression expr) {
        if (expr == null) {
            return null;
        }
        LinkedList e = (LinkedList)this.myTypeMap.get((Object)new TypeMigrationUsageInfo((PsiElement)expr));
        if (e != null) {
            return (PsiType)e.getFirst();
        }
        if (expr instanceof PsiArrayAccessExpression) {
            PsiType at = this.evaluateType(((PsiArrayAccessExpression)expr).getArrayExpression());
            if (at instanceof PsiArrayType) {
                return ((PsiArrayType)at).getComponentType();
            }
        } else {
            if (expr instanceof PsiAssignmentExpression) {
                return this.evaluateType(((PsiAssignmentExpression)expr).getLExpression());
            }
            if (expr instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)expr;
                JavaResolveResult resolveResult = call.resolveMethodGenerics();
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    PsiParameter[] parameters2 = method.getParameterList().getParameters();
                    PsiExpression[] actualParms = call.getArgumentList().getExpressions();
                    return PsiUtil.captureToplevelWildcards((PsiType)this.createMethodSubstitution(parameters2, actualParms, method, (PsiExpression)call, resolveResult.getSubstitutor(), false).substitute(this.evaluateType((PsiExpression)call.getMethodExpression())), (PsiElement)expr);
                }
            } else {
                PsiClass superClass;
                PsiClass psiClass;
                if (expr instanceof PsiPolyadicExpression) {
                    PsiExpression[] operands2 = ((PsiPolyadicExpression)expr).getOperands();
                    IElementType sign = ((PsiPolyadicExpression)expr).getOperationTokenType();
                    PsiType lType = operands2.length > 0 ? this.evaluateType(operands2[0]) : null;
                    for (int i = 1; i < operands2.length; ++i) {
                        lType = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)this.evaluateType(operands2[i]), (IElementType)sign, (boolean)true);
                    }
                    return lType;
                }
                if (expr instanceof PsiUnaryExpression) {
                    return this.evaluateType(((PsiUnaryExpression)expr).getOperand());
                }
                if (expr instanceof PsiParenthesizedExpression) {
                    return this.evaluateType(((PsiParenthesizedExpression)expr).getExpression());
                }
                if (expr instanceof PsiConditionalExpression) {
                    PsiExpression thenExpression2 = ((PsiConditionalExpression)expr).getThenExpression();
                    PsiExpression elseExpression2 = ((PsiConditionalExpression)expr).getElseExpression();
                    PsiType thenType = this.evaluateType(thenExpression2);
                    PsiType elseType = this.evaluateType(elseExpression2);
                    switch ((thenType == null ? 0 : 1) + (elseType == null ? 0 : 2)) {
                        case 0: {
                            return expr.getType();
                        }
                        case 1: {
                            return thenType;
                        }
                        case 2: {
                            return elseType;
                        }
                        case 3: {
                            if (TypeConversionUtil.areTypesConvertible((PsiType)thenType, (PsiType)elseType)) {
                                return thenType;
                            }
                            if (TypeConversionUtil.areTypesConvertible((PsiType)elseType, (PsiType)thenType)) {
                                return elseType;
                            }
                            switch ((thenType.equals(thenExpression2.getType()) ? 0 : 1) + (elseType.equals(elseExpression2.getType()) ? 0 : 2)) {
                                case 0: {
                                    return expr.getType();
                                }
                                case 1: {
                                    return thenType;
                                }
                                case 2: {
                                    return elseType;
                                }
                                case 3: {
                                    return expr.getType();
                                }
                            }
                            LOG.error("Must not happen.");
                            return null;
                        }
                    }
                    LOG.error("Must not happen.");
                } else if (expr instanceof PsiNewExpression) {
                    PsiClassType.ClassResolveResult qualifierResult;
                    PsiExpression qualifier = ((PsiNewExpression)expr).getQualifier();
                    if (qualifier != null && (qualifierResult = TypeEvaluator.resolveType(this.evaluateType(qualifier))).getElement() != null) {
                        PsiSubstitutor qualifierSubs = qualifierResult.getSubstitutor();
                        PsiClassType.ClassResolveResult result2 = TypeEvaluator.resolveType(expr.getType());
                        if (result2.getElement() != null) {
                            PsiClass aClass = result2.getElement();
                            return JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aClass, result2.getSubstitutor().putAll(qualifierSubs));
                        }
                    }
                } else if (expr instanceof PsiFunctionalExpression) {
                    PsiType functionalInterfaceType = ((PsiFunctionalExpression)expr).getFunctionalInterfaceType();
                    if (functionalInterfaceType != null) {
                        return functionalInterfaceType;
                    }
                } else if (expr instanceof PsiReferenceExpression) {
                    PsiType type2 = this.evaluateReferenceExpressionType(expr);
                    if (type2 != null) {
                        return PsiImplUtil.normalizeWildcardTypeByPosition(type2, expr);
                    }
                } else if (expr instanceof PsiSuperExpression && (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiClass.class)) != null && (superClass = psiClass.getSuperClass()) != null) {
                    return this.getType(new TypeMigrationUsageInfo((PsiElement)superClass));
                }
            }
        }
        return this.getType((PsiElement)expr);
    }

    @Nullable
    private PsiType evaluateReferenceExpressionType(PsiExpression expr) {
        PsiReferenceExpression ref = (PsiReferenceExpression)expr;
        PsiExpression qualifier = ref.getQualifierExpression();
        if (qualifier == null) {
            PsiElement resolvee = ref.resolve();
            if (resolvee == null) {
                return null;
            }
            return resolvee instanceof PsiClass ? JavaPsiFacade.getElementFactory((Project)resolvee.getProject()).createType((PsiClass)resolvee, PsiSubstitutor.EMPTY) : this.getType(resolvee);
        }
        PsiType qualifierType = this.evaluateType(qualifier);
        if (!(qualifierType instanceof PsiArrayType)) {
            PsiElement element = ref.resolve();
            PsiClassType.ClassResolveResult result2 = TypeEvaluator.resolveType(qualifierType);
            PsiClass aClass = result2.getElement();
            if (aClass != null) {
                PsiSubstitutor aSubst = result2.getSubstitutor();
                if (element instanceof PsiField) {
                    PsiField field = (PsiField)element;
                    PsiType aType = field.getType();
                    PsiClass superClass = field.getContainingClass();
                    if (InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)superClass, (boolean)true)) {
                        aType = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY).substitute(aType);
                    }
                    return aSubst.substitute(aType);
                }
                if (element instanceof PsiMethod) {
                    PsiMethod[] methods;
                    PsiMethod method = (PsiMethod)element;
                    PsiType aType = method.getReturnType();
                    PsiClass superClass = method.getContainingClass();
                    if (InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)superClass, (boolean)true)) {
                        aType = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY).substitute(aType);
                    } else if (InheritanceUtil.isInheritorOrSelf((PsiClass)superClass, (PsiClass)aClass, (boolean)true) && (methods = method.findSuperMethods(aClass)).length > 0) {
                        aType = methods[0].getReturnType();
                    }
                    return aSubst.substitute(aType);
                }
            }
        }
        return null;
    }

    public static PsiClassType.ClassResolveResult resolveType(PsiType type2) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)type2);
        PsiClass aClass = resolveResult.getElement();
        if (aClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)aClass).getBaseClassType();
            return TypeEvaluator.resolveType(resolveResult.getSubstitutor().substitute((PsiType)baseClassType));
        }
        return resolveResult;
    }

    public PsiSubstitutor createMethodSubstitution(PsiParameter[] parameters2, PsiExpression[] actualParms, PsiMethod method, PsiExpression call) {
        return this.createMethodSubstitution(parameters2, actualParms, method, call, PsiSubstitutor.EMPTY, false);
    }

    public PsiSubstitutor createMethodSubstitution(PsiParameter[] parameters2, PsiExpression[] actualParms, PsiMethod method, PsiExpression call, PsiSubstitutor subst, boolean preferSubst) {
        SubstitutorBuilder substitutorBuilder = new SubstitutorBuilder(method, call, subst);
        for (int i = 0; i < Math.min(parameters2.length, actualParms.length); ++i) {
            substitutorBuilder.bindTypeParameters(this.getType((PsiElement)parameters2[i]), this.evaluateType(actualParms[i]));
        }
        return substitutorBuilder.createSubstitutor(preferSubst);
    }

    public String getReport() {
        StringBuilder buffer = new StringBuilder();
        Object[] t = new String[this.myTypeMap.size()];
        int k = 0;
        for (TypeMigrationUsageInfo info : this.myTypeMap.keySet()) {
            LinkedList types = (LinkedList)this.myTypeMap.get((Object)info);
            StringBuilder b = new StringBuilder();
            if (types != null) {
                b.append(info.getElement()).append(" : ");
                b.append(StringUtil.join((Collection)types, psiType -> psiType.getCanonicalText(), (String)" "));
                b.append("\n");
            }
            t[k++] = b.toString();
        }
        Arrays.sort(t);
        for (Object aT : t) {
            buffer.append((String)aT);
        }
        return buffer.toString();
    }

    public LinkedList<Pair<TypeMigrationUsageInfo, PsiType>> getMigratedDeclarations() {
        LinkedList<Pair<TypeMigrationUsageInfo, PsiType>> list2 = new LinkedList<Pair<TypeMigrationUsageInfo, PsiType>>();
        for (TypeMigrationUsageInfo usageInfo : this.myTypeMap.keySet()) {
            LinkedList types = (LinkedList)this.myTypeMap.get((Object)usageInfo);
            PsiElement element = usageInfo.getElement();
            if (!(element instanceof PsiVariable) && !(element instanceof PsiMethod)) continue;
            list2.addLast((Pair<TypeMigrationUsageInfo, PsiType>)Pair.create((Object)((Object)usageInfo), types.getFirst()));
        }
        return list2;
    }

    @Nullable
    static PsiType substituteType(PsiType migrationType, PsiType originalType, boolean captureWildcard, PsiClass originalClass, PsiType rawTypeToReplace) {
        if (originalClass != null) {
            if (((PsiClassType)originalType).hasParameters() && ((PsiClassType)migrationType).hasParameters()) {
                PsiResolveHelper psiResolveHelper = JavaPsiFacade.getInstance((Project)originalClass.getProject()).getResolveHelper();
                PsiClassType rawOriginalType = JavaPsiFacade.getElementFactory((Project)originalClass.getProject()).createType(originalClass, PsiSubstitutor.EMPTY);
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                for (PsiTypeParameter parameter2 : originalClass.getTypeParameters()) {
                    PsiType type2 = psiResolveHelper.getSubstitutionForTypeParameter(parameter2, (PsiType)rawOriginalType, migrationType, false, PsiUtil.getLanguageLevel((PsiElement)originalClass));
                    if (type2 == null) {
                        return null;
                    }
                    substitutor = substitutor.put(parameter2, captureWildcard && type2 instanceof PsiWildcardType ? ((PsiWildcardType)type2).getExtendsBound() : type2);
                }
                return substitutor.substitute(rawTypeToReplace);
            }
            return originalType;
        }
        return null;
    }

    public static PsiType substituteType(PsiType migrationTtype, PsiType originalType, boolean isContraVariantPosition) {
        PsiClass originalClass;
        if (originalType instanceof PsiClassType && migrationTtype instanceof PsiClassType && (originalClass = ((PsiClassType)originalType).resolve()) != null) {
            PsiType psiType;
            if (isContraVariantPosition && TypeConversionUtil.erasure((PsiType)originalType).isAssignableFrom(TypeConversionUtil.erasure((PsiType)migrationTtype))) {
                PsiType psiType2;
                PsiSubstitutor substitutor;
                PsiClass psiClass = ((PsiClassType)migrationTtype).resolve();
                PsiSubstitutor psiSubstitutor = substitutor = psiClass != null ? TypeConversionUtil.getClassSubstitutor((PsiClass)originalClass, (PsiClass)psiClass, (PsiSubstitutor)PsiSubstitutor.EMPTY) : null;
                if (substitutor != null && (psiType2 = TypeEvaluator.substituteType(migrationTtype, originalType, false, psiClass, (PsiType)JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(originalClass, substitutor))) != null) {
                    return psiType2;
                }
            } else if (!isContraVariantPosition && TypeConversionUtil.erasure((PsiType)migrationTtype).isAssignableFrom(TypeConversionUtil.erasure((PsiType)originalType)) && (psiType = TypeEvaluator.substituteType(migrationTtype, originalType, false, originalClass, (PsiType)JavaPsiFacade.getElementFactory((Project)originalClass.getProject()).createType(originalClass, PsiSubstitutor.EMPTY))) != null) {
                return psiType;
            }
        }
        return migrationTtype;
    }

    @Nullable
    public <T> T getSettings(Class<T> aClass) {
        return this.myRules.getConversionSettings(aClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/refactoring/typeMigration/TypeEvaluator", "setType"));
    }

    private class SubstitutorBuilder {
        private final Map<PsiTypeParameter, PsiType> myMapping;
        private final PsiMethod myMethod;
        private final PsiExpression myCall;
        private final PsiSubstitutor mySubst;

        public SubstitutorBuilder(PsiMethod method, PsiExpression call, PsiSubstitutor subst) {
            this.mySubst = subst;
            this.myMapping = new HashMap();
            this.myMethod = method;
            this.myCall = call;
        }

        private void update(PsiTypeParameter p, PsiType t) {
            PsiType binding;
            if (t instanceof PsiPrimitiveType) {
                t = ((PsiPrimitiveType)t).getBoxedType((PsiElement)this.myMethod);
            }
            if ((binding = this.myMapping.get(p)) == null) {
                this.myMapping.put(p, t);
            } else if (t != null) {
                this.myMapping.put(p, PsiIntersectionType.createIntersection((PsiType[])new PsiType[]{binding, t}));
            }
        }

        void bindTypeParameters(PsiType formal, PsiType actual) {
            if (formal instanceof PsiWildcardType) {
                if (actual instanceof PsiCapturedWildcardType && ((PsiWildcardType)formal).isExtends() == ((PsiCapturedWildcardType)actual).getWildcard().isExtends()) {
                    this.bindTypeParameters(((PsiWildcardType)formal).getBound(), ((PsiCapturedWildcardType)actual).getWildcard().getBound());
                    return;
                }
                formal = ((PsiWildcardType)formal).getBound();
            }
            if (formal instanceof PsiArrayType && actual instanceof PsiArrayType) {
                this.bindTypeParameters(((PsiArrayType)formal).getComponentType(), ((PsiArrayType)actual).getComponentType());
                return;
            }
            Pair<PsiType, PsiType> typePair = TypeEvaluator.this.myRules.bindTypeParameters(formal, actual, this.myMethod, this.myCall, TypeEvaluator.this.myLabeler);
            if (typePair != null) {
                this.bindTypeParameters((PsiType)typePair.getFirst(), (PsiType)typePair.getSecond());
                return;
            }
            PsiClassType.ClassResolveResult resultF = TypeEvaluator.resolveType(formal);
            PsiClass classF = resultF.getElement();
            if (classF != null) {
                PsiSubstitutor superClassSubstitutor;
                if (classF instanceof PsiTypeParameter) {
                    this.update((PsiTypeParameter)classF, actual);
                    return;
                }
                PsiClassType.ClassResolveResult resultA = TypeEvaluator.resolveType(actual);
                PsiClass classA = resultA.getElement();
                if (classA == null) {
                    return;
                }
                if (!classA.equals(classF) && (superClassSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)classF, (PsiClass)classA, (PsiSubstitutor)resultA.getSubstitutor())) != null) {
                    PsiClassType aligned = JavaPsiFacade.getInstance((Project)classF.getProject()).getElementFactory().createType(classF, superClassSubstitutor);
                    this.bindTypeParameters(formal, (PsiType)aligned);
                }
                PsiTypeParameter[] typeParms = classA.getTypeParameters();
                PsiSubstitutor substA = resultA.getSubstitutor();
                PsiSubstitutor substF = resultF.getSubstitutor();
                for (PsiTypeParameter typeParm : typeParms) {
                    this.bindTypeParameters(substF.substitute(typeParm), substA.substitute(typeParm));
                }
            }
        }

        public PsiSubstitutor createSubstitutor(boolean preferSubst) {
            PsiSubstitutor theSubst = this.mySubst;
            if (preferSubst) {
                this.myMapping.keySet().removeAll(this.mySubst.getSubstitutionMap().keySet());
            }
            for (PsiTypeParameter parm : this.myMapping.keySet()) {
                theSubst = theSubst.put(parm, this.myMapping.get(parm));
            }
            return theSubst;
        }
    }
}

