/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Queue;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    private Util() {
    }

    public static PsiElement getEssentialParent(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof PsiParenthesizedExpression) {
            return Util.getEssentialParent(parent);
        }
        return parent;
    }

    @Nullable
    public static PsiElement normalizeElement(PsiElement element) {
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            PsiType initialMethodReturnType = method.getReturnType();
            if (initialMethodReturnType == null) {
                return null;
            }
            SmartList normalized = new SmartList();
            Queue queue2 = new Queue(1);
            queue2.addLast((Object)method);
            while (!queue2.isEmpty()) {
                PsiMethod currentMethod = (PsiMethod)queue2.pullFirst();
                if (!initialMethodReturnType.equals(currentMethod.getReturnType())) continue;
                for (PsiMethod toConsume : currentMethod.findSuperMethods(false)) {
                    queue2.addLast((Object)toConsume);
                }
                normalized.add(currentMethod);
            }
            return normalized.isEmpty() ? element : (PsiElement)normalized.get(normalized.size() - 1);
        }
        if (element instanceof PsiParameter && element.getParent() instanceof PsiParameterList) {
            PsiElement declarationScope = ((PsiParameter)element).getDeclarationScope();
            if (declarationScope instanceof PsiLambdaExpression) {
                PsiMethod interfaceMethod;
                PsiType interfaceType = ((PsiLambdaExpression)declarationScope).getFunctionalInterfaceType();
                if (interfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)interfaceType)) != null) {
                    int index = ((PsiParameterList)element.getParent()).getParameterIndex((PsiParameter)element);
                    return interfaceMethod.getParameterList().getParameters()[index];
                }
                return null;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (method != null) {
                int index = method.getParameterList().getParameterIndex((PsiParameter)element);
                PsiMethod superMethod = method.findDeepestSuperMethod();
                if (superMethod != null) {
                    return superMethod.getParameterList().getParameters()[index];
                }
            }
        }
        return element;
    }

    public static boolean canBeMigrated(@NotNull PsiElement[] es) {
        if (es == null) {
            Util.$$$reportNull$$$0(0);
        }
        return Arrays.stream(es).allMatch(Util::canBeMigrated);
    }

    private static boolean canBeMigrated(@Nullable PsiElement e) {
        if (e == null) {
            return false;
        }
        PsiElement element = Util.normalizeElement(e);
        if (element == null || !element.isWritable()) {
            return false;
        }
        PsiType type2 = TypeMigrationLabeler.getElementType(element);
        if (type2 != null) {
            PsiType elementType;
            PsiType psiType = elementType = type2 instanceof PsiArrayType ? type2.getDeepComponentType() : type2;
            if (elementType instanceof PsiPrimitiveType) {
                return !elementType.equals(PsiType.VOID);
            }
            if (elementType instanceof PsiClassType) {
                PsiClass aClass = ((PsiClassType)elementType).resolve();
                return aClass != null;
            }
            if (elementType instanceof PsiDisjunctionType) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "es", "com/intellij/refactoring/typeMigration/Util", "canBeMigrated"));
    }
}

