/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationVariableTypeFixProvider;
import com.intellij.refactoring.typeMigration.rules.LongAdderConversionRule;
import com.intellij.util.IncorrectOperationException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConvertAtomicToLongAdderIntention
extends PsiElementBaseIntentionAction {
    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiVariable variable;
        if (project2 == null) {
            ConvertAtomicToLongAdderIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ConvertAtomicToLongAdderIntention.$$$reportNull$$$0(1);
        }
        if ((variable = ConvertAtomicToLongAdderIntention.getVariable(element)) != null) {
            PsiType longAdder = JavaPsiFacade.getElementFactory((Project)project2).createTypeFromText("java.util.concurrent.atomic.LongAdder", element);
            TypeMigrationVariableTypeFixProvider.runTypeMigrationOnVariable(variable, longAdder, null, false, false);
        }
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            ConvertAtomicToLongAdderIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ConvertAtomicToLongAdderIntention.$$$reportNull$$$0(3);
        }
        if (!element.isValid() || !PsiUtil.isLanguageLevel8OrHigher((PsiElement)element)) {
            return false;
        }
        PsiVariable variable = ConvertAtomicToLongAdderIntention.getVariable(element);
        return variable != null;
    }

    private static PsiVariable getVariable(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiLocalVariable) && !(parent instanceof PsiField)) {
            return null;
        }
        PsiVariable var = (PsiVariable)element.getParent();
        PsiType type2 = var.getType();
        if (!type2.isValid()) {
            return null;
        }
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type2);
        if (aClass == null || !AtomicLong.class.getName().equals(aClass.getQualifiedName()) && !AtomicInteger.class.getName().equals(aClass.getQualifiedName())) {
            return null;
        }
        PsiExpression initializer = var.getInitializer();
        if (initializer != null) {
            if (initializer instanceof PsiNewExpression) {
                return LongAdderConversionRule.getParametersCount((PsiCallExpression)initializer) == -1 ? null : var;
            }
            return null;
        }
        return var;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ConvertAtomicToLongAdderIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Convert to LongAdder" == null) {
            ConvertAtomicToLongAdderIntention.$$$reportNull$$$0(5);
        }
        return "Convert to LongAdder";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/intentions/ConvertAtomicToLongAdderIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/intentions/ConvertAtomicToLongAdderIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

