/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public abstract class EnableDisableAction
extends AbstractAction {
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getTable().isEditing()) {
            return;
        }
        int[] rows = this.getTable().getSelectedRows();
        if (rows.length > 0) {
            boolean valueToBeSet = false;
            for (int row : rows) {
                if (this.isRowChecked(row)) continue;
                valueToBeSet = true;
                break;
            }
            this.applyValue(rows, valueToBeSet);
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getTable(), true));
    }

    protected abstract JTable getTable();

    protected abstract void applyValue(int[] var1, boolean var2);

    protected abstract boolean isRowChecked(int var1);

    public void register() {
        JTable table = this.getTable();
        InputMap inputMap = table.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        ActionMap actionMap = table.getActionMap();
        actionMap.put("enable_disable", this);
    }
}

