/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.ide.HelpTooltip;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;

public abstract class RefactoringDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.ui.RefactoringDialog");
    private Action myRefactorAction;
    private Action myPreviewAction;
    private boolean myCbPreviewResults;
    protected final Project myProject;

    protected RefactoringDialog(@NotNull Project project2, boolean canBeParent) {
        if (project2 == null) {
            RefactoringDialog.$$$reportNull$$$0(0);
        }
        super(project2, canBeParent);
        this.myCbPreviewResults = true;
        this.myProject = project2;
    }

    public final boolean isPreviewUsages() {
        return this.myCbPreviewResults;
    }

    public void setPreviewResults(boolean previewResults) {
        this.myCbPreviewResults = previewResults;
    }

    public void show() {
        LOG.assertTrue(TransactionGuard.getInstance().getContextTransaction() != null, (Object)"Refactorings should be invoked inside transaction");
        super.show();
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myRefactorAction = new RefactorAction();
        this.myPreviewAction = new PreviewAction();
    }

    protected final Action getRefactorAction() {
        return this.myRefactorAction;
    }

    protected final Action getPreviewAction() {
        return this.myPreviewAction;
    }

    protected abstract void doAction();

    private void doPreviewAction() {
        this.myCbPreviewResults = true;
        this.doAction();
    }

    protected void doRefactorAction() {
        this.myCbPreviewResults = false;
        this.doAction();
    }

    protected final void closeOKAction() {
        super.doOKAction();
    }

    protected final void doOKAction() {
        if (DumbService.isDumb((Project)this.myProject)) {
            Messages.showMessageDialog((Project)this.myProject, (String)"Refactoring is not available while indexing is in progress", (String)"Indexing", null);
            return;
        }
        this.doAction();
    }

    protected boolean areButtonsValid() {
        return true;
    }

    protected void canRun() throws ConfigurationException {
        if (!this.areButtonsValid()) {
            throw new ConfigurationException(null);
        }
    }

    protected void setHelpTooltip(JButton helpButton) {
        if (Registry.is((String)"ide.helptooltip.enabled")) {
            new HelpTooltip().setDescription(ActionsBundle.actionDescription((String)"HelpTopics")).installOn(helpButton);
        } else {
            super.setHelpTooltip(helpButton);
        }
    }

    protected void validateButtons() {
        boolean enabled = true;
        try {
            this.setErrorText(null);
            this.canRun();
        }
        catch (ConfigurationException e) {
            enabled = false;
            this.setErrorText(e.getMessage());
        }
        this.getPreviewAction().setEnabled(enabled);
        this.getRefactorAction().setEnabled(enabled);
    }

    protected boolean hasHelpAction() {
        return true;
    }

    protected boolean hasPreviewButton() {
        return true;
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getRefactorAction());
        if (this.hasPreviewButton()) {
            actions.add(this.getPreviewAction());
        }
        actions.add(this.getCancelAction());
        if (this.hasHelpAction()) {
            actions.add(this.getHelpAction());
        }
        if (SystemInfo.isMac) {
            Collections.reverse(actions);
        }
        Action[] actionArray = actions.toArray(new Action[actions.size()]);
        if (actionArray == null) {
            RefactoringDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    protected Project getProject() {
        return this.myProject;
    }

    protected void invokeRefactoring(BaseRefactoringProcessor processor2) {
        Runnable prepareSuccessfulCallback = () -> this.close(0);
        processor2.setPrepareSuccessfulSwingThreadCallback(prepareSuccessfulCallback);
        processor2.setPreviewUsages(this.isPreviewUsages());
        processor2.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/ui/RefactoringDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/ui/RefactoringDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PreviewAction
    extends AbstractAction {
        public PreviewAction() {
            this.putValue("Name", RefactoringBundle.message((String)"preview.button"));
            if (SystemInfo.isMac) {
                this.putValue("FocusedAction", Boolean.TRUE);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RefactoringDialog.this.doPreviewAction();
        }
    }

    private class RefactorAction
    extends AbstractAction {
        public RefactorAction() {
            this.putValue("Name", RefactoringBundle.message((String)"refactor.button"));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RefactoringDialog.this.doRefactorAction();
        }
    }
}

