/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.classMembers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MemberInfo
extends MemberInfoBase<PsiMember> {
    private final PsiReferenceList mySourceReferenceList;

    public MemberInfo(PsiMember member) {
        this(member, false, null);
    }

    public MemberInfo(PsiMember member, boolean isSuperClass, PsiReferenceList sourceReferenceList) {
        super((PsiElement)member);
        LOG.assertTrue(member.isValid());
        this.mySourceReferenceList = sourceReferenceList;
        if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            this.displayName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)263, (int)7);
            PsiMethod[] superMethods = method.findSuperMethods();
            this.overrides = superMethods.length > 0 ? Boolean.valueOf(!superMethods[0].hasModifierProperty("abstract")) : null;
            this.isStatic = method.hasModifierProperty("static");
        } else if (member instanceof PsiField) {
            PsiField field = (PsiField)member;
            this.displayName = PsiFormatUtil.formatVariable((PsiVariable)field, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            this.isStatic = field.hasModifierProperty("static");
            this.overrides = null;
        } else if (member instanceof PsiClass) {
            PsiClass aClass = (PsiClass)member;
            if (isSuperClass) {
                if (aClass.isInterface()) {
                    this.displayName = RefactoringBundle.message((String)"member.info.implements.0", (Object[])new Object[]{aClass.getName()});
                    this.overrides = Boolean.FALSE;
                } else {
                    this.displayName = RefactoringBundle.message((String)"member.info.extends.0", (Object[])new Object[]{aClass.getName()});
                    this.overrides = Boolean.TRUE;
                }
            } else {
                this.displayName = aClass.getName();
                this.overrides = null;
            }
            this.isStatic = aClass.hasModifierProperty("static");
        } else {
            LOG.assertTrue(false);
            this.isStatic = false;
            this.displayName = "";
            this.overrides = null;
        }
    }

    public PsiReferenceList getSourceReferenceList() {
        return this.mySourceReferenceList;
    }

    public static List<MemberInfo> extractClassMembers(PsiClass subclass, MemberInfoBase.Filter<PsiMember> filter2, boolean extractInterfacesDeep) {
        ArrayList<MemberInfo> members = new ArrayList<MemberInfo>();
        MemberInfo.extractClassMembers(subclass, members, filter2, extractInterfacesDeep);
        return members;
    }

    public static void extractClassMembers(PsiClass subclass, List<MemberInfo> result2, MemberInfoBase.Filter<PsiMember> filter2, boolean extractInterfacesDeep) {
        PsiField[] fields;
        PsiMethod[] methods;
        PsiClass[] innerClasses;
        if (extractInterfacesDeep) {
            MemberInfo.extractSuperInterfaces(subclass, filter2, result2, (Set<PsiClass>)new HashSet());
        } else {
            PsiClass[] interfaces = subclass.getInterfaces();
            PsiClass[] sourceRefList = subclass.isInterface() ? subclass.getExtendsList() : subclass.getImplementsList();
            PsiClass[] psiClassArray = interfaces;
            int n = psiClassArray.length;
            for (int i = 0; i < n; ++i) {
                PsiClass anInterface = psiClassArray[i];
                if (!filter2.includeMember((PsiElement)anInterface)) continue;
                result2.add(new MemberInfo((PsiMember)anInterface, true, (PsiReferenceList)sourceRefList));
            }
        }
        for (PsiClass innerClass : innerClasses = subclass.getInnerClasses()) {
            if (!filter2.includeMember((PsiElement)innerClass)) continue;
            result2.add(new MemberInfo((PsiMember)innerClass));
        }
        for (PsiMethod method : methods = subclass.getMethods()) {
            if (method.isConstructor() || !filter2.includeMember((PsiElement)method)) continue;
            result2.add(new MemberInfo((PsiMember)method));
        }
        for (PsiField field : fields = subclass.getFields()) {
            if (!filter2.includeMember((PsiElement)field)) continue;
            result2.add(new MemberInfo((PsiMember)field));
        }
    }

    private static void extractSuperInterfaces(PsiClass subclass, MemberInfoBase.Filter<PsiMember> filter2, List<MemberInfo> result2, Set<PsiClass> processed2) {
        if (!processed2.contains(subclass)) {
            processed2.add(subclass);
            MemberInfo.extractSuperInterfacesFromReferenceList(subclass.getExtendsList(), filter2, result2, processed2);
            MemberInfo.extractSuperInterfacesFromReferenceList(subclass.getImplementsList(), filter2, result2, processed2);
        }
    }

    private static void extractSuperInterfacesFromReferenceList(PsiReferenceList referenceList, MemberInfoBase.Filter<PsiMember> filter2, List<MemberInfo> result2, Set<PsiClass> processed2) {
        if (referenceList != null) {
            PsiClassType[] extendsListTypes;
            for (PsiClassType extendsListType : extendsListTypes = referenceList.getReferencedTypes()) {
                PsiClass aSuper = extendsListType.resolve();
                if (aSuper == null) continue;
                if (aSuper.isInterface()) {
                    if (!filter2.includeMember((PsiElement)aSuper)) continue;
                    result2.add(new MemberInfo((PsiMember)aSuper, true, referenceList));
                    continue;
                }
                MemberInfo.extractSuperInterfaces(aSuper, filter2, result2, processed2);
            }
        }
    }
}

