/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.deployment.debug;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.ui.DebuggerPanelsManager;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebugConnectionData;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebugServerModeHandler;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebuggerLauncher;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerLauncherImpl
extends JavaDebuggerLauncher {
    private static final Logger LOG = Logger.getInstance(JavaDebuggerLauncherImpl.class);

    public void startDebugSession(@NotNull JavaDebugConnectionData info, @NotNull ExecutionEnvironment executionEnvironment, @NotNull RemoteServer<?> server) throws ExecutionException {
        if (info == null) {
            JavaDebuggerLauncherImpl.$$$reportNull$$$0(0);
        }
        if (executionEnvironment == null) {
            JavaDebuggerLauncherImpl.$$$reportNull$$$0(1);
        }
        if (server == null) {
            JavaDebuggerLauncherImpl.$$$reportNull$$$0(2);
        }
        Project project2 = executionEnvironment.getProject();
        DebuggerPanelsManager manager = DebuggerPanelsManager.getInstance(project2);
        final JavaDebugServerModeHandler serverModeHandler = info.getServerModeHandler();
        boolean serverMode = serverModeHandler != null;
        RemoteConnection remoteConnection = new RemoteConnection(true, info.getHost(), String.valueOf(info.getPort()), serverMode);
        RemoteServerDebugEnvironment debugEnvironment = new RemoteServerDebugEnvironment(project2, remoteConnection, executionEnvironment.getRunProfile());
        RemoteServerDebugUIEnvironment debugUIEnvironment = new RemoteServerDebugUIEnvironment(debugEnvironment, executionEnvironment);
        RunContentDescriptor debugContentDescriptor = manager.attachVirtualMachine(debugUIEnvironment);
        LOG.assertTrue(debugContentDescriptor != null);
        ProcessHandler processHandler2 = debugContentDescriptor.getProcessHandler();
        LOG.assertTrue(processHandler2 != null);
        if (serverMode) {
            serverModeHandler.attachRemote();
            DebuggerManager.getInstance((Project)executionEnvironment.getProject()).addDebugProcessListener(processHandler2, new DebugProcessListener(){

                public void processDetached(DebugProcess process2, boolean closedByUser) {
                    try {
                        serverModeHandler.detachRemote();
                    }
                    catch (ExecutionException e) {
                        LOG.info((Throwable)e);
                    }
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "executionEnvironment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "server";
                break;
            }
        }
        objectArray[1] = "com/intellij/remoteServer/impl/runtime/deployment/debug/JavaDebuggerLauncherImpl";
        objectArray[2] = "startDebugSession";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RemoteServerDebugEnvironment
    implements DebugEnvironment {
        private final Project myProject;
        private final GlobalSearchScope mySearchScope;
        private final RemoteConnection myRemoteConnection;
        private final RunProfile myRunProfile;

        public RemoteServerDebugEnvironment(Project project2, RemoteConnection remoteConnection, RunProfile runProfile) {
            this.myProject = project2;
            this.mySearchScope = SearchScopeProvider.createSearchScope((Project)project2, (RunProfile)runProfile);
            this.myRemoteConnection = remoteConnection;
            this.myRunProfile = runProfile;
        }

        @Override
        @Nullable
        public ExecutionResult createExecutionResult() throws ExecutionException {
            ConsoleViewImpl consoleView = new ConsoleViewImpl(this.myProject, false);
            RemoteDebugProcessHandler process2 = new RemoteDebugProcessHandler(this.myProject);
            consoleView.attachToProcess(process2);
            return new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)process2);
        }

        @Override
        @NotNull
        public GlobalSearchScope getSearchScope() {
            GlobalSearchScope globalSearchScope = this.mySearchScope;
            if (globalSearchScope == null) {
                RemoteServerDebugEnvironment.$$$reportNull$$$0(0);
            }
            return globalSearchScope;
        }

        @Override
        public boolean isRemote() {
            return true;
        }

        @Override
        public RemoteConnection getRemoteConnection() {
            return this.myRemoteConnection;
        }

        @Override
        public long getPollTimeout() {
            return 30000L;
        }

        @Override
        public String getSessionName() {
            return this.myRunProfile.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/debug/JavaDebuggerLauncherImpl$RemoteServerDebugEnvironment", "getSearchScope"));
        }
    }

    private static class RemoteServerDebugUIEnvironment
    implements DebugUIEnvironment {
        private final DebugEnvironment myEnvironment;
        private final ExecutionEnvironment myExecutionEnvironment;

        public RemoteServerDebugUIEnvironment(DebugEnvironment environment, ExecutionEnvironment executionEnvironment) {
            this.myEnvironment = environment;
            this.myExecutionEnvironment = executionEnvironment;
        }

        @Override
        public DebugEnvironment getEnvironment() {
            return this.myEnvironment;
        }

        @Override
        @Nullable
        public RunContentDescriptor getReuseContent() {
            return this.myExecutionEnvironment.getContentToReuse();
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.myExecutionEnvironment.getRunProfile().getIcon();
        }

        @Override
        public void initActions(RunContentDescriptor content, DefaultActionGroup actionGroup) {
            actionGroup.add((AnAction)new CloseAction(this.myExecutionEnvironment.getExecutor(), content, this.myExecutionEnvironment.getProject()));
        }

        @Override
        @Nullable
        public RunProfile getRunProfile() {
            return this.myExecutionEnvironment.getRunProfile();
        }
    }
}

