/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import com.intellij.spellchecker.compress.Alphabet;
import com.intellij.spellchecker.compress.Encoder;
import com.intellij.spellchecker.compress.UnitBitSet;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.spellchecker.engine.Transformation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompressedDictionary
implements Dictionary {
    private final Alphabet alphabet;
    private int wordsCount;
    private byte[][] words;
    private int[] lengths;
    private final Encoder encoder;
    private final String name;
    private TIntObjectHashMap<SortedSet<byte[]>> rawData;
    private static final Comparator<byte[]> COMPARATOR = (o1, o2) -> CompressedDictionary.compareArrays(o1, o2);

    private CompressedDictionary(@NotNull Alphabet alphabet, @NotNull Encoder encoder, @NotNull String name2) {
        if (alphabet == null) {
            CompressedDictionary.$$$reportNull$$$0(0);
        }
        if (encoder == null) {
            CompressedDictionary.$$$reportNull$$$0(1);
        }
        if (name2 == null) {
            CompressedDictionary.$$$reportNull$$$0(2);
        }
        this.rawData = new TIntObjectHashMap();
        this.alphabet = alphabet;
        this.encoder = encoder;
        this.name = name2;
    }

    private void addToDictionary(@NotNull byte[] word) {
        SortedSet<byte[]> set2;
        if (word == null) {
            CompressedDictionary.$$$reportNull$$$0(3);
        }
        if ((set2 = (SortedSet<byte[]>)this.rawData.get(word.length)) == null) {
            set2 = CompressedDictionary.createSet();
            this.rawData.put(word.length, set2);
        }
        set2.add(word);
        ++this.wordsCount;
    }

    private void pack() {
        this.lengths = new int[this.rawData.size()];
        this.words = new byte[this.rawData.size()][];
        this.rawData.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<SortedSet<byte[]>>(){
            int row = 0;

            public boolean execute(int length, SortedSet<byte[]> value2) {
                ((CompressedDictionary)CompressedDictionary.this).lengths[this.row] = length;
                ((CompressedDictionary)CompressedDictionary.this).words[this.row] = new byte[value2.size() * length];
                int k = 0;
                byte[] wordBytes = CompressedDictionary.this.words[this.row];
                for (byte[] bytes : value2) {
                    assert (bytes.length == length);
                    System.arraycopy(bytes, 0, wordBytes, k, bytes.length);
                    k += bytes.length;
                }
                ++this.row;
                return true;
            }
        });
        this.rawData = null;
    }

    @NotNull
    private static SortedSet<byte[]> createSet() {
        TreeSet<byte[]> treeSet = new TreeSet<byte[]>(COMPARATOR);
        if (treeSet == null) {
            CompressedDictionary.$$$reportNull$$$0(4);
        }
        return treeSet;
    }

    public List<String> getWords(char first, int minLength, int maxLength) {
        ArrayList<String> result2 = new ArrayList<String>();
        this.getWords(first, minLength, maxLength, result2);
        return result2;
    }

    public List<String> getWords(char first) {
        ArrayList<String> result2 = new ArrayList<String>();
        this.getWords(first, 0, Integer.MAX_VALUE, result2);
        return result2;
    }

    public void getWords(char first, int minLength, int maxLength, @NotNull Collection<String> result2) {
        int index;
        if (result2 == null) {
            CompressedDictionary.$$$reportNull$$$0(5);
        }
        if ((index = this.alphabet.getIndex(first, false)) == -1) {
            return;
        }
        int i = 0;
        for (byte[] data : this.words) {
            int length = this.lengths[i];
            if (length < minLength || length > maxLength) continue;
            for (int x = 0; x < data.length; x += length) {
                if (this.encoder.getFirstLetterIndex(data[x]) != index) continue;
                byte[] toTest = new byte[length];
                System.arraycopy(data, x, toTest, 0, length);
                String decoded = this.encoder.decode(toTest);
                result2.add(decoded);
            }
            ++i;
        }
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            CompressedDictionary.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        UnitBitSet bs;
        if (word == null) {
            CompressedDictionary.$$$reportNull$$$0(7);
        }
        if ((bs = this.encoder.encode(word, false)) == Encoder.WORD_OF_ENTIRELY_UNKNOWN_LETTERS) {
            return null;
        }
        if (bs == null) {
            return false;
        }
        byte[] compressed = bs.pack();
        int index = ArrayUtil.indexOf((int[])this.lengths, (int)compressed.length);
        return index != -1 && CompressedDictionary.contains(compressed, this.words[index]);
    }

    @Override
    public boolean isEmpty() {
        return this.wordsCount <= 0;
    }

    @Override
    public void traverse(@NotNull Consumer<String> action) {
        if (action == null) {
            CompressedDictionary.$$$reportNull$$$0(8);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getWords() {
        THashSet words = new THashSet();
        for (int i = 0; i <= this.alphabet.getLastIndexUsed(); ++i) {
            char letter = this.alphabet.getLetter(i);
            this.getWords(letter, 0, Integer.MAX_VALUE, (Collection<String>)words);
        }
        return words;
    }

    @Override
    public int size() {
        return this.wordsCount;
    }

    public String toString() {
        return "CompressedDictionary{wordsCount=" + this.wordsCount + ", name='" + this.name + '\'' + '}';
    }

    @NotNull
    public static CompressedDictionary create(@NotNull Loader loader, @NotNull Transformation transform) {
        if (loader == null) {
            CompressedDictionary.$$$reportNull$$$0(9);
        }
        if (transform == null) {
            CompressedDictionary.$$$reportNull$$$0(10);
        }
        Alphabet alphabet = new Alphabet();
        Encoder encoder = new Encoder(alphabet);
        CompressedDictionary dictionary = new CompressedDictionary(alphabet, encoder, loader.getName());
        ArrayList bss = new ArrayList();
        loader.load((Consumer<String>)((Consumer)s -> {
            String transformed;
            if (transform == null) {
                CompressedDictionary.$$$reportNull$$$0(20);
            }
            if ((transformed = transform.transform((String)s)) != null) {
                UnitBitSet bs = encoder.encode(transformed, true);
                if (bs == null) {
                    return;
                }
                bss.add(bs);
            }
        }));
        for (UnitBitSet bs : bss) {
            byte[] compressed = bs.pack();
            dictionary.addToDictionary(compressed);
        }
        dictionary.pack();
        CompressedDictionary compressedDictionary = dictionary;
        if (compressedDictionary == null) {
            CompressedDictionary.$$$reportNull$$$0(11);
        }
        return compressedDictionary;
    }

    public static int compareArrays(@NotNull byte[] array1, @NotNull byte[] array2) {
        if (array1 == null) {
            CompressedDictionary.$$$reportNull$$$0(12);
        }
        if (array2 == null) {
            CompressedDictionary.$$$reportNull$$$0(13);
        }
        return CompressedDictionary.compareArrays(array1, 0, array1.length, array2);
    }

    private static int compareArrays(@NotNull byte[] array1, int start1, int length1, @NotNull byte[] array2) {
        if (array1 == null) {
            CompressedDictionary.$$$reportNull$$$0(14);
        }
        if (array2 == null) {
            CompressedDictionary.$$$reportNull$$$0(15);
        }
        if (length1 != array2.length) {
            return length1 < array2.length ? -1 : 1;
        }
        for (int i = 0; i < length1; ++i) {
            int d = array1[i + start1] - array2[i];
            if (d < 0) {
                return -1;
            }
            if (d <= 0) continue;
            return 1;
        }
        return 0;
    }

    public static boolean contains(@NotNull byte[] goal, @NotNull byte[] data) {
        if (goal == null) {
            CompressedDictionary.$$$reportNull$$$0(16);
        }
        if (data == null) {
            CompressedDictionary.$$$reportNull$$$0(17);
        }
        return CompressedDictionary.binarySearchNew(goal, 0, data.length / goal.length, data) >= 0;
    }

    public static int binarySearchNew(@NotNull byte[] goal, int fromIndex, int toIndex, @NotNull byte[] data) {
        if (goal == null) {
            CompressedDictionary.$$$reportNull$$$0(18);
        }
        if (data == null) {
            CompressedDictionary.$$$reportNull$$$0(19);
        }
        int unitLength = goal.length;
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int check = CompressedDictionary.compareArrays(data, mid * unitLength, unitLength, goal);
            if (check == -1) {
                low = mid + 1;
                continue;
            }
            if (check == 1) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alphabet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/compress/CompressedDictionary";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array1";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array2";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goal";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/compress/CompressedDictionary";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addToDictionary";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWords";
                break;
            }
            case 7: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "compareArrays";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "binarySearchNew";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$create$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

