/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.spellchecker.compress.Alphabet;
import com.intellij.spellchecker.compress.UnitBitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Encoder {
    private final Alphabet alphabet;
    private static final int offset = 0;
    static final UnitBitSet WORD_OF_ENTIRELY_UNKNOWN_LETTERS = new UnitBitSet(new byte[1], new Alphabet());
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.compress");

    public Encoder() {
        this(new Alphabet());
    }

    public Encoder(@NotNull Alphabet alphabet) {
        if (alphabet == null) {
            Encoder.$$$reportNull$$$0(0);
        }
        this.alphabet = alphabet;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    @Nullable
    public UnitBitSet encode(@NotNull CharSequence letters, boolean force) {
        if (letters == null) {
            Encoder.$$$reportNull$$$0(1);
        }
        if (64 <= letters.length() + 0) {
            return null;
        }
        int unknownLetters = 0;
        byte[] indices2 = new byte[letters.length()];
        for (int i = 0; i < letters.length(); ++i) {
            char letter = letters.charAt(i);
            int index = this.alphabet.getIndex(letter, force);
            if (index < 0) {
                ++unknownLetters;
                continue;
            }
            indices2[i] = (byte)index;
        }
        if (unknownLetters == letters.length()) {
            return WORD_OF_ENTIRELY_UNKNOWN_LETTERS;
        }
        if (unknownLetters > 0) {
            return null;
        }
        return new UnitBitSet(indices2, this.alphabet);
    }

    @NotNull
    public String decode(@NotNull byte[] compressed) {
        if (compressed == null) {
            Encoder.$$$reportNull$$$0(2);
        }
        String string = UnitBitSet.decode(compressed, this.alphabet);
        if (string == null) {
            Encoder.$$$reportNull$$$0(3);
        }
        return string;
    }

    public int getFirstLetterIndex(byte firstPackedByte) {
        return UnitBitSet.getFirstLetterIndex(firstPackedByte, this.alphabet);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alphabet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "letters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compressed";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/compress/Encoder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/compress/Encoder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "decode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "encode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

