/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.dictionary;

import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDictionary
implements EditableDictionary {
    @NonNls
    private static final String DEFAULT_CURRENT_USER_NAME = "default.user";
    private static final String DEFAULT_PROJECT_DICTIONARY_NAME = "project";
    private String activeName;
    private Set<EditableDictionary> dictionaries;

    public ProjectDictionary() {
    }

    public ProjectDictionary(@NotNull Set<EditableDictionary> dictionaries) {
        if (dictionaries == null) {
            ProjectDictionary.$$$reportNull$$$0(0);
        }
        this.dictionaries = dictionaries;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        if (DEFAULT_PROJECT_DICTIONARY_NAME == null) {
            ProjectDictionary.$$$reportNull$$$0(1);
        }
        return DEFAULT_PROJECT_DICTIONARY_NAME;
    }

    public void setActiveName(String name2) {
        this.activeName = name2;
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        if (word == null) {
            ProjectDictionary.$$$reportNull$$$0(2);
        }
        if (this.dictionaries == null) {
            return false;
        }
        int errors = 0;
        for (Dictionary dictionary : this.dictionaries) {
            Boolean contains = dictionary.contains(word);
            if (contains == null) {
                ++errors;
                continue;
            }
            if (!contains.booleanValue()) continue;
            return true;
        }
        if (errors == this.dictionaries.size()) {
            return null;
        }
        return false;
    }

    @Override
    public void addToDictionary(String word) {
        this.getActiveDictionary().addToDictionary(word);
    }

    @Override
    public void removeFromDictionary(String word) {
        this.getActiveDictionary().removeFromDictionary(word);
    }

    @NotNull
    private EditableDictionary getActiveDictionary() {
        EditableDictionary editableDictionary = this.ensureCurrentUserDictionary();
        if (editableDictionary == null) {
            ProjectDictionary.$$$reportNull$$$0(3);
        }
        return editableDictionary;
    }

    @NotNull
    private EditableDictionary ensureCurrentUserDictionary() {
        EditableDictionary result2;
        if (this.activeName == null) {
            this.activeName = DEFAULT_CURRENT_USER_NAME;
        }
        if ((result2 = this.getDictionaryByName(this.activeName)) == null) {
            result2 = new UserDictionary(this.activeName);
            if (this.dictionaries == null) {
                this.dictionaries = new THashSet();
            }
            this.dictionaries.add(result2);
        }
        EditableDictionary editableDictionary = result2;
        if (editableDictionary == null) {
            ProjectDictionary.$$$reportNull$$$0(4);
        }
        return editableDictionary;
    }

    @Nullable
    private EditableDictionary getDictionaryByName(@NotNull String name2) {
        if (name2 == null) {
            ProjectDictionary.$$$reportNull$$$0(5);
        }
        if (this.dictionaries == null) {
            return null;
        }
        EditableDictionary result2 = null;
        for (EditableDictionary dictionary : this.dictionaries) {
            if (!dictionary.getName().equals(name2)) continue;
            result2 = dictionary;
            break;
        }
        return result2;
    }

    @Override
    public void replaceAll(@Nullable Collection<String> words) {
        this.getActiveDictionary().replaceAll(words);
    }

    @Override
    public void clear() {
        this.getActiveDictionary().clear();
    }

    @Override
    @Nullable
    public Set<String> getWords() {
        if (this.dictionaries == null) {
            return null;
        }
        THashSet words = new THashSet();
        for (Dictionary dictionary : this.dictionaries) {
            Set<String> otherWords = dictionary.getWords();
            if (otherWords == null) continue;
            words.addAll(otherWords);
        }
        return words;
    }

    @Override
    public int size() {
        int result2 = 0;
        for (Dictionary dictionary : this.dictionaries) {
            result2 += dictionary.size();
        }
        return result2;
    }

    @Override
    public void traverse(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            ProjectDictionary.$$$reportNull$$$0(6);
        }
        if (this.dictionaries == null) {
            return;
        }
        for (EditableDictionary dictionary : this.dictionaries) {
            dictionary.traverse(consumer);
        }
    }

    @Override
    @Nullable
    public Set<String> getEditableWords() {
        return this.getActiveDictionary().getWords();
    }

    @Override
    public void addToDictionary(@Nullable Collection<String> words) {
        this.getActiveDictionary().addToDictionary(words);
    }

    public Set<EditableDictionary> getDictionaries() {
        return this.dictionaries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectDictionary that = (ProjectDictionary)o;
        if (this.activeName != null ? !this.activeName.equals(that.activeName) : that.activeName != null) {
            return false;
        }
        return !(this.dictionaries != null ? !this.dictionaries.equals(that.dictionaries) : that.dictionaries != null);
    }

    public int hashCode() {
        int result2 = this.activeName != null ? this.activeName.hashCode() : 0;
        result2 = 31 * result2 + (this.dictionaries != null ? this.dictionaries.hashCode() : 0);
        return result2;
    }

    @NonNls
    public String toString() {
        return "ProjectDictionary{activeName='" + this.activeName + '\'' + ", dictionaries=" + this.dictionaries + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictionaries";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/dictionary/ProjectDictionary";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/dictionary/ProjectDictionary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveDictionary";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureCurrentUserDictionary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDictionaryByName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

