/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.JavaPredefinedConfigurations;
import com.intellij.structuralsearch.JavaReplaceHandler;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.JavaCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.JavaMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.JavaCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementContext;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStructuralSearchProfile
extends StructuralSearchProfile {
    private static final Set<String> PRIMITIVE_TYPES = new THashSet(Arrays.asList("short", "boolean", "double", "long", "int", "float", "char", "byte"));

    @Override
    public String getText(PsiElement match, int start, int end) {
        PsiElement parent;
        if (match instanceof PsiIdentifier && (parent = match.getParent()) instanceof PsiJavaCodeReferenceElement && !(parent instanceof PsiExpression)) {
            match = parent;
        }
        String matchText = match.getText();
        if (start == 0 && end == -1) {
            return matchText;
        }
        return matchText.substring(start, end == -1 ? matchText.length() : end);
    }

    @Override
    public Class getElementContextByPsi(PsiElement element) {
        if (element instanceof PsiIdentifier) {
            element = element.getParent();
        }
        if (element instanceof PsiMember) {
            return PsiMember.class;
        }
        return PsiExpression.class;
    }

    @Override
    @NotNull
    public String getTypedVarString(PsiElement element) {
        String text2;
        if (element instanceof PsiNamedElement) {
            text2 = ((PsiNamedElement)element).getName();
        } else if (element instanceof PsiAnnotation) {
            PsiJavaCodeReferenceElement referenceElement = ((PsiAnnotation)element).getNameReferenceElement();
            text2 = referenceElement == null ? null : referenceElement.getQualifiedName();
        } else if (element instanceof PsiNameValuePair) {
            text2 = ((PsiNameValuePair)element).getName();
        } else {
            int i;
            text2 = element.getText();
            if (StringUtil.startsWithChar((CharSequence)text2, (char)'@')) {
                text2 = text2.substring(1);
            }
            if (StringUtil.endsWithChar((CharSequence)text2, (char)';')) {
                text2 = text2.substring(0, text2.length() - 1);
            } else if (element instanceof PsiExpressionStatement && (i = text2.indexOf(59)) != -1) {
                text2 = text2.substring(0, i);
            }
        }
        if (text2 == null) {
            text2 = element.getText();
        }
        String string = text2;
        if (string == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public String getMeaningfulText(PsiElement element) {
        if (element instanceof PsiReferenceExpression && ((PsiReferenceExpression)element).getQualifierExpression() != null) {
            String text2;
            PsiElement resolve2 = ((PsiReferenceExpression)element).resolve();
            if (resolve2 instanceof PsiClass) {
                return element.getText();
            }
            PsiElement referencedElement = ((PsiReferenceExpression)element).getReferenceNameElement();
            String string = text2 = referencedElement != null ? referencedElement.getText() : "";
            if (resolve2 == null && text2.length() > 0 && Character.isUpperCase(text2.charAt(0))) {
                return element.getText();
            }
            return text2;
        }
        return super.getMeaningfulText(element);
    }

    @Override
    public PsiElement updateCurrentNode(PsiElement targetNode) {
        if (targetNode instanceof PsiCodeBlock && ((PsiCodeBlock)targetNode).getStatements().length == 1) {
            PsiElement targetNodeParent = targetNode.getParent();
            if (targetNodeParent instanceof PsiBlockStatement) {
                targetNodeParent = targetNodeParent.getParent();
            }
            if (targetNodeParent instanceof PsiIfStatement || targetNodeParent instanceof PsiLoopStatement) {
                targetNode = targetNodeParent;
            }
        }
        return targetNode;
    }

    @Override
    public PsiElement extendMatchedByDownUp(PsiElement targetNode) {
        PsiElement parent;
        if (targetNode instanceof PsiIdentifier && ((parent = (targetNode = targetNode.getParent()).getParent()) instanceof PsiTypeElement || parent instanceof PsiStatement)) {
            targetNode = parent;
        }
        return targetNode;
    }

    @Override
    public PsiElement extendMatchOnePsiFile(PsiElement file2) {
        if (file2 instanceof PsiIdentifier) {
            file2 = file2.getParent();
        }
        return file2;
    }

    @Override
    @NotNull
    public PsiElement getPresentableElement(PsiElement element) {
        PsiElement parent;
        if ((element = super.getPresentableElement(element)) instanceof PsiReferenceExpression) {
            PsiElement parent2 = element.getParent();
            if (parent2 instanceof PsiMethodCallExpression) {
                PsiElement psiElement = parent2;
                if (psiElement == null) {
                    JavaStructuralSearchProfile.$$$reportNull$$$0(1);
                }
                return psiElement;
            }
        } else if (element instanceof PsiJavaCodeReferenceElement && ((parent = element.getParent()) instanceof PsiTypeElement || parent instanceof PsiNewExpression || parent instanceof PsiAnnotation)) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                JavaStructuralSearchProfile.$$$reportNull$$$0(2);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @Override
    public void compile(PsiElement[] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(4);
        }
        new JavaCompilingVisitor(globalVisitor).compile(elements);
    }

    @Override
    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(5);
        }
        JavaMatchingVisitor javaMatchingVisitor = new JavaMatchingVisitor(globalVisitor);
        if (javaMatchingVisitor == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(6);
        }
        return javaMatchingVisitor;
    }

    @Override
    @NotNull
    public NodeFilter getLexicalNodesFilter() {
        NodeFilter nodeFilter = element -> JavaStructuralSearchProfile.isLexicalNode(element);
        if (nodeFilter == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(7);
        }
        return nodeFilter;
    }

    private static boolean isLexicalNode(PsiElement element) {
        if (element instanceof PsiWhiteSpace) {
            return true;
        }
        if (element instanceof PsiJavaToken) {
            return !(element instanceof PsiKeyword) || !PRIMITIVE_TYPES.contains(element.getText()) || !(element.getParent() instanceof PsiNewExpression);
        }
        return false;
    }

    @Override
    @NotNull
    public CompiledPattern createCompiledPattern() {
        JavaCompiledPattern javaCompiledPattern = new JavaCompiledPattern();
        if (javaCompiledPattern == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(8);
        }
        return javaCompiledPattern;
    }

    @Override
    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(9);
        }
        return language == JavaLanguage.INSTANCE;
    }

    @Override
    public StructuralReplaceHandler getReplaceHandler(@NotNull ReplacementContext context) {
        if (context == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(10);
        }
        return new JavaReplaceHandler(context);
    }

    @Override
    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text2, @NotNull PatternTreeContext context, @NotNull FileType fileType, @Nullable Language language, String contextName, @Nullable String extension, @NotNull Project project2, boolean physical) {
        if (text2 == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(11);
        }
        if (context == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(12);
        }
        if (fileType == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(13);
        }
        if (project2 == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(14);
        }
        if (physical) {
            throw new UnsupportedOperationException(this.getClass() + " cannot create physical PSI");
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        if (context == PatternTreeContext.Block) {
            PsiCodeBlock codeBlock = elementFactory.createCodeBlockFromText("{\n" + text2 + "\n}", null);
            PsiElement[] children2 = codeBlock.getChildren();
            int extraChildCount = 4;
            if (children2.length > 4) {
                PsiElement[] classPattern;
                PsiElement[] result2 = new PsiElement[children2.length - 4];
                System.arraycopy(children2, 2, result2, 0, children2.length - 4);
                if (JavaStructuralSearchProfile.shouldTryExpressionPattern(result2)) {
                    try {
                        PsiElement[] expressionPattern = this.createPatternTree(text2, PatternTreeContext.Expression, fileType, language, contextName, extension, project2, false);
                        if (expressionPattern.length == 1) {
                            result2 = expressionPattern;
                        }
                    }
                    catch (IncorrectOperationException expressionPattern) {}
                } else if (JavaStructuralSearchProfile.shouldTryClassPattern(result2) && (classPattern = this.createPatternTree(text2, PatternTreeContext.Class, fileType, language, contextName, extension, project2, false)).length == 1) {
                    result2 = classPattern;
                }
                if (result2 == null) {
                    JavaStructuralSearchProfile.$$$reportNull$$$0(15);
                }
                return result2;
            }
            if (PsiElement.EMPTY_ARRAY == null) {
                JavaStructuralSearchProfile.$$$reportNull$$$0(16);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (context == PatternTreeContext.Class) {
            PsiElement endChild;
            PsiClass clazz = elementFactory.createClassFromText(text2, null);
            PsiElement startChild = clazz.getLBrace();
            if (startChild != null) {
                startChild = startChild.getNextSibling();
            }
            if ((endChild = clazz.getRBrace()) != null) {
                endChild = endChild.getPrevSibling();
            }
            if (startChild == endChild) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    JavaStructuralSearchProfile.$$$reportNull$$$0(17);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            assert (startChild != null);
            SmartList result3 = new SmartList();
            for (PsiElement element = startChild.getNextSibling(); element != endChild && element != null; element = element.getNextSibling()) {
                if (element instanceof PsiErrorElement) continue;
                result3.add(element);
            }
            PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray((Collection)result3);
            if (psiElementArray == null) {
                JavaStructuralSearchProfile.$$$reportNull$$$0(18);
            }
            return psiElementArray;
        }
        if (context == PatternTreeContext.Expression) {
            PsiElement[] psiElementArray = new PsiElement[]{elementFactory.createExpressionFromText(text2, null)};
            if (psiElementArray == null) {
                JavaStructuralSearchProfile.$$$reportNull$$$0(19);
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = PsiFileFactory.getInstance((Project)project2).createFileFromText("__dummy.java", (FileType)JavaFileType.INSTANCE, (CharSequence)text2).getChildren();
        if (psiElementArray == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(20);
        }
        return psiElementArray;
    }

    private static boolean shouldTryExpressionPattern(PsiElement[] elements) {
        PsiElement lastChild;
        PsiElement firstElement;
        return elements.length >= 1 && elements.length <= 3 && (firstElement = elements[0]) instanceof PsiDeclarationStatement && (lastChild = firstElement.getLastChild()) instanceof PsiErrorElement && PsiTreeUtil.prevLeaf((PsiElement)lastChild) instanceof PsiErrorElement;
    }

    private static boolean shouldTryClassPattern(PsiElement[] elements) {
        if (elements.length < 2) {
            return false;
        }
        PsiElement firstElement = elements[0];
        PsiElement secondElement = elements[1];
        if (firstElement instanceof PsiDocComment) {
            return true;
        }
        if (firstElement instanceof PsiDeclarationStatement && PsiTreeUtil.lastChild((PsiElement)firstElement) instanceof PsiErrorElement) {
            return true;
        }
        if (firstElement instanceof PsiErrorElement && secondElement instanceof PsiExpressionStatement && PsiTreeUtil.lastChild((PsiElement)secondElement) instanceof PsiErrorElement) {
            return true;
        }
        return elements.length == 3 && "static".equals(firstElement.getText()) && secondElement instanceof PsiWhiteSpace && elements[2] instanceof PsiBlockStatement;
    }

    @Override
    @NotNull
    public Editor createEditor(@NotNull SearchContext searchContext, @NotNull FileType fileType, Language dialect, String text2, boolean useLastConfiguration) {
        Editor selectedEditor;
        PsiFile element;
        if (searchContext == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(21);
        }
        if (fileType == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(22);
        }
        if ((element = searchContext.getFile()) != null && !useLastConfiguration && (selectedEditor = FileEditorManager.getInstance((Project)searchContext.getProject()).getSelectedTextEditor()) != null) {
            int caretPosition = selectedEditor.getCaretModel().getOffset();
            PsiElement positionedElement = searchContext.getFile().findElementAt(caretPosition);
            if (positionedElement == null) {
                positionedElement = searchContext.getFile().findElementAt(caretPosition + 1);
            }
            if (positionedElement != null) {
                element = PsiTreeUtil.getParentOfType((PsiElement)positionedElement, (Class[])new Class[]{PsiClass.class, PsiCodeBlock.class});
            }
        }
        PsiManager psimanager = PsiManager.getInstance((Project)searchContext.getProject());
        Project project2 = psimanager.getProject();
        PsiCodeFragment file2 = this.createCodeFragment(project2, text2, (PsiElement)element);
        Document doc = PsiDocumentManager.getInstance((Project)searchContext.getProject()).getDocument((PsiFile)file2);
        DaemonCodeAnalyzer.getInstance((Project)searchContext.getProject()).setHighlightingEnabled((PsiFile)file2, false);
        Editor editor = UIUtil.createEditor(doc, searchContext.getProject(), true, true, this.getTemplateContextType());
        if (editor == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(23);
        }
        return editor;
    }

    @Override
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return JavaCodeContextType.class;
    }

    @Override
    public PsiCodeFragment createCodeFragment(Project project2, String text2, PsiElement context) {
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project2);
        return factory.createCodeBlockCodeFragment(text2, context, true);
    }

    @Override
    public void checkSearchPattern(Project project2, MatchOptions options) {
        ValidatingVisitor visitor = new ValidatingVisitor();
        CompiledPattern compiledPattern = PatternCompiler.compilePattern(project2, options);
        NodeIterator nodes = compiledPattern.getNodes();
        if (compiledPattern.getNodeCount() == 1 && (nodes.current() instanceof PsiExpressionStatement || nodes.current() instanceof PsiDeclarationStatement)) {
            visitor.setCurrent(nodes.current());
        }
        while (nodes.hasNext()) {
            nodes.current().accept((PsiElementVisitor)visitor);
            nodes.advance();
        }
        nodes.reset();
    }

    @Override
    public void checkReplacementPattern(Project project2, ReplaceOptions options) {
        MatchOptions matchOptions = options.getMatchOptions();
        FileType fileType = matchOptions.getFileType();
        PsiElement[] statements = this.createPatternTree(matchOptions.getSearchPattern(), PatternTreeContext.Block, fileType, project2, false);
        boolean searchIsExpression = statements.length == 1 && statements[0].getLastChild() instanceof PsiErrorElement;
        PsiElement[] statements2 = this.createPatternTree(options.getReplacement(), PatternTreeContext.Block, fileType, project2, false);
        boolean replaceIsExpression = statements2.length == 1 && statements2[0].getLastChild() instanceof PsiErrorElement;
        ValidatingVisitor visitor = new ValidatingVisitor();
        if (statements2.length == 1 && (statements2[0] instanceof PsiExpressionStatement || statements2[0] instanceof PsiDeclarationStatement)) {
            visitor.setCurrent(statements2[0]);
        }
        for (PsiElement statement2 : statements2) {
            statement2.accept((PsiElementVisitor)visitor);
        }
        if (searchIsExpression && statements[0].getFirstChild() instanceof PsiModifierList && statements2.length == 0) {
            return;
        }
        boolean targetFound = false;
        for (String name2 : matchOptions.getVariableConstraintNames()) {
            MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name2);
            if (!constraint.isPartOfSearchResults()) continue;
            targetFound = true;
            break;
        }
        if (!targetFound && searchIsExpression != replaceIsExpression) {
            throw new UnsupportedPatternException(searchIsExpression ? SSRBundle.message("replacement.template.is.not.expression.error.message", new Object[0]) : SSRBundle.message("search.template.is.not.expression.error.message", new Object[0]));
        }
    }

    @Override
    public LanguageFileType getDefaultFileType(LanguageFileType currentDefaultFileType) {
        return StdFileTypes.JAVA;
    }

    @Override
    public Configuration[] getPredefinedTemplates() {
        return JavaPredefinedConfigurations.createPredefinedTemplates();
    }

    @Override
    public void provideAdditionalReplaceOptions(@NotNull PsiElement node, ReplaceOptions options, final ReplacementBuilder builder) {
        if (node == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(24);
        }
        node.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                this.visitElement((PsiElement)expression2);
            }

            public void visitParameter(PsiParameter parameter2) {
                super.visitParameter(parameter2);
                String name2 = parameter2.getName();
                String type2 = parameter2.getType().getCanonicalText();
                if (StructuralSearchUtil.isTypedVariable(name2)) {
                    name2 = Replacer.stripTypedVariableDecoration(name2);
                    if (StructuralSearchUtil.isTypedVariable(type2)) {
                        type2 = Replacer.stripTypedVariableDecoration(type2);
                    }
                    ParameterInfo nameInfo = builder.findParameterization(name2);
                    ParameterInfo typeInfo = builder.findParameterization(type2);
                    PsiElement scope = parameter2.getDeclarationScope();
                    if (nameInfo != null && typeInfo != null && !(scope instanceof PsiCatchSection) && !(scope instanceof PsiForeachStatement)) {
                        nameInfo.setArgumentContext(false);
                        typeInfo.setArgumentContext(false);
                        typeInfo.setMethodParameterContext(true);
                        nameInfo.setMethodParameterContext(true);
                        typeInfo.setElement((PsiElement)parameter2.getTypeElement());
                    }
                }
            }
        });
    }

    @Override
    public int handleSubstitution(ParameterInfo info, MatchResult match, StringBuilder result2, int offset, ReplacementInfo replacementInfo) {
        if (info.getName().equals(match.getName())) {
            String replacementString;
            boolean forceAddingNewLine = false;
            if (info.isMethodParameterContext()) {
                StringBuilder buf = new StringBuilder();
                JavaStructuralSearchProfile.handleMethodParameter(buf, info, replacementInfo);
                replacementString = buf.toString();
            } else if (match.hasSons() && !match.isScopeMatch()) {
                StringBuilder buf = new StringBuilder();
                MatchResult previous = null;
                boolean stripSemicolon = false;
                for (MatchResult matchResult : match.getAllSons()) {
                    PsiElement currentElement = matchResult.getMatch();
                    boolean bl = stripSemicolon = !(currentElement instanceof PsiField);
                    if (previous != null) {
                        PsiElement prevSibling;
                        PsiElement parent = currentElement.getParent();
                        if (parent instanceof PsiVariable) {
                            prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)parent);
                            if (PsiUtil.isJavaToken((PsiElement)prevSibling, (IElementType)JavaTokenType.COMMA)) {
                                buf.append(',');
                            }
                        } else if (info.isStatementContext()) {
                            prevSibling = currentElement.getPrevSibling();
                            if (prevSibling instanceof PsiWhiteSpace && prevSibling.getPrevSibling() == previous.getMatch()) {
                                buf.append(prevSibling.getText());
                            } else {
                                buf.append('\n');
                            }
                        } else if (info.isArgumentContext()) {
                            buf.append(',');
                        } else if (parent instanceof PsiClass) {
                            prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)currentElement);
                            if (PsiUtil.isJavaToken((PsiElement)prevSibling, (IElementType)JavaTokenType.COMMA)) {
                                buf.append(',');
                            } else {
                                buf.append('\n');
                            }
                        } else if (parent instanceof PsiReferenceList) {
                            buf.append(',');
                        } else if (parent instanceof PsiPolyadicExpression) {
                            PsiPolyadicExpression expression2 = (PsiPolyadicExpression)parent;
                            PsiJavaToken token = expression2.getTokenBeforeOperand(expression2.getOperands()[1]);
                            if (token != null) {
                                buf.append(token.getText());
                            }
                        } else {
                            buf.append(' ');
                        }
                    }
                    buf.append(matchResult.getMatchImage());
                    forceAddingNewLine = currentElement instanceof PsiComment;
                    previous = matchResult;
                }
                replacementString = stripSemicolon ? StringUtil.trimEnd((String)buf.toString(), (char)';') : buf.toString();
            } else {
                PsiElement matchElement = match.getMatch();
                if (info.isStatementContext()) {
                    forceAddingNewLine = matchElement instanceof PsiComment;
                }
                String matchImage = match.getMatchImage();
                replacementString = !(matchElement instanceof PsiField) ? StringUtil.trimEnd((String)matchImage, (char)';') : matchImage;
            }
            offset = Replacer.insertSubstitution(result2, offset, info, replacementString);
            offset = JavaStructuralSearchProfile.removeExtraSemicolon(info, offset, result2, match);
            if (forceAddingNewLine && info.isStatementContext()) {
                result2.insert(info.getStartIndex() + offset + 1, '\n');
                ++offset;
            }
        }
        return offset;
    }

    @Override
    public int handleNoSubstitution(ParameterInfo info, int offset, StringBuilder result2) {
        PsiElement element = info.getElement();
        PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
        if (prevSibling instanceof PsiJavaToken && JavaStructuralSearchProfile.isRemovableToken(prevSibling)) {
            int start = info.getBeforeDelimiterPos() + offset - (prevSibling.getTextLength() - 1);
            int end = info.getStartIndex() + offset;
            result2.delete(start, end);
            return offset - (end - start);
        }
        PsiElement nextSibling = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        if (JavaStructuralSearchProfile.isRemovableToken(nextSibling)) {
            int start = info.getStartIndex() + offset;
            int end = info.getAfterDelimiterPos() + nextSibling.getTextLength() + offset;
            result2.delete(start, end);
            return offset - 1;
        }
        if (element instanceof PsiTypeElement && nextSibling instanceof PsiIdentifier) {
            int start = info.getStartIndex() + offset;
            int end = info.getAfterDelimiterPos() + offset;
            result2.delete(start, end);
            return offset - 1;
        }
        if (element == null || !(element.getParent() instanceof PsiForStatement)) {
            return JavaStructuralSearchProfile.removeExtraSemicolon(info, offset, result2, null);
        }
        return offset;
    }

    private static boolean isRemovableToken(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiAnnotationParameterList || parent instanceof PsiAssertStatement || parent instanceof PsiExpressionList || parent instanceof PsiParameterList || parent instanceof PsiPolyadicExpression || parent instanceof PsiReferenceList || parent instanceof PsiReferenceParameterList || parent instanceof PsiResourceList || parent instanceof PsiTypeParameterList || parent instanceof PsiLocalVariable || parent instanceof PsiField)) {
            return false;
        }
        String text2 = element.getText();
        if (text2.length() != 1) {
            return true;
        }
        switch (text2.charAt(0)) {
            case '(': 
            case ')': 
            case '<': 
            case '>': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isIdentifier(PsiElement element) {
        return element instanceof PsiIdentifier;
    }

    @Override
    @NotNull
    public Collection<String> getReservedWords() {
        Set<String> set2 = Collections.singleton("packageLocal");
        if (set2 == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(25);
        }
        return set2;
    }

    @Override
    public boolean isDocCommentOwner(PsiElement match) {
        return match instanceof PsiMember;
    }

    private static void handleMethodParameter(StringBuilder buf, ParameterInfo info, ReplacementInfo replacementInfo) {
        if (!(info.getElement() instanceof PsiTypeElement)) {
            return;
        }
        String name2 = ((PsiParameter)info.getElement().getParent()).getName();
        name2 = StructuralSearchUtil.isTypedVariable(name2) ? Replacer.stripTypedVariableDecoration(name2) : name2;
        MatchResult matchResult = replacementInfo.getNamedMatchResult(name2);
        if (matchResult == null) {
            return;
        }
        if (matchResult.isMultipleMatch()) {
            for (MatchResult result2 : matchResult.getAllSons()) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                JavaStructuralSearchProfile.appendParameter(buf, result2);
            }
        } else {
            JavaStructuralSearchProfile.appendParameter(buf, matchResult);
        }
    }

    private static void appendParameter(StringBuilder buf, MatchResult matchResult) {
        List<MatchResult> sons = matchResult.getAllSons();
        assert (sons.size() == 1);
        buf.append(sons.get(0).getMatchImage()).append(' ').append(matchResult.getMatchImage());
    }

    private static int removeExtraSemicolon(ParameterInfo info, int offset, StringBuilder result2, MatchResult match) {
        int index;
        if (info.isStatementContext() && result2.charAt(index = offset + info.getStartIndex()) == ';' && (match == null || result2.charAt(index - 1) == '}' && !(match.getMatch() instanceof PsiDeclarationStatement) && !(match.getMatch() instanceof PsiNewExpression) || !match.isMultipleMatch() && match.getMatch() instanceof PsiComment || match.isMultipleMatch() && match.getAllSons().get(match.getAllSons().size() - 1).getMatch() instanceof PsiComment)) {
            result2.deleteCharAt(index);
            --offset;
        }
        return offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/JavaStructuralSearchProfile";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVisitor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarString";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableElement";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/JavaStructuralSearchProfile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMatchingVisitor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexicalNodesFilter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompiledPattern";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternTree";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedWords";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMatchingVisitor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMyLanguage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createPatternTree";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "provideAdditionalReplaceOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ValidatingVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private PsiElement myCurrent;

        ValidatingVisitor() {
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
            if (nameReferenceElement == null || !nameReferenceElement.getText().equals("Modifier")) {
                return;
            }
            for (PsiNameValuePair pair2 : annotation.getParameterList().getAttributes()) {
                PsiAnnotationMemberValue value2 = pair2.getValue();
                if (value2 instanceof PsiArrayInitializerMemberValue) {
                    for (PsiAnnotationMemberValue v : ((PsiArrayInitializerMemberValue)value2).getInitializers()) {
                        String name2 = StringUtil.unquoteString((String)v.getText());
                        ValidatingVisitor.checkModifier(name2);
                    }
                    continue;
                }
                if (value2 == null) continue;
                String name3 = StringUtil.unquoteString((String)value2.getText());
                ValidatingVisitor.checkModifier(name3);
            }
        }

        private static void checkModifier(String name2) {
            if (!"Instance".equals(name2) && !"packageLocal".equals(name2) && ArrayUtil.find((Object[])JavaMatchingVisitor.MODIFIERS, (Object)name2) < 0) {
                throw new MalformedPatternException(SSRBundle.message("invalid.modifier.type", name2));
            }
        }

        public void visitErrorElement(PsiErrorElement element) {
            super.visitErrorElement(element);
            PsiElement parent = element.getParent();
            String errorDescription = element.getErrorDescription();
            if (parent instanceof PsiClass && "Identifier expected".equals(errorDescription)) {
                return;
            }
            if (parent instanceof PsiTryStatement && "'catch' or 'finally' expected".equals(errorDescription)) {
                return;
            }
            if (parent == this.myCurrent) {
                if ("';' expected".equals(errorDescription)) {
                    return;
                }
                if ("Identifier or type expected".equals(errorDescription)) {
                    return;
                }
                if ("Identifier expected".equals(errorDescription)) {
                    return;
                }
            }
            throw new MalformedPatternException(errorDescription);
        }

        void setCurrent(PsiElement current) {
            this.myCurrent = current;
        }
    }
}

