/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.UnsupportedPatternException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StringToConstraintsTransformer {
    @NonNls
    private static final String REF = "ref";
    @NonNls
    private static final String REGEX = "regex";
    @NonNls
    private static final String REGEXW = "regexw";
    @NonNls
    private static final String EXPRTYPE = "exprtype";
    @NonNls
    private static final String FORMAL = "formal";
    @NonNls
    private static final String SCRIPT = "script";
    @NonNls
    private static final String CONTAINS = "contains";
    @NonNls
    private static final String WITHIN = "within";

    public static void transformCriteria(String criteria, MatchOptions options) {
        StringBuilder pattern = new StringBuilder();
        int anonymousTypedVarsCount = 0;
        boolean targetFound = false;
        int length = criteria.length();
        for (int index = 0; index < length; ++index) {
            char ch = criteria.charAt(index);
            if (index == 0 && ch == '[') {
                MatchVariableConstraint constraint = new MatchVariableConstraint();
                constraint.setName("__context__");
                index = StringToConstraintsTransformer.handleTypedVarCondition(0, criteria, constraint);
                options.addVariableConstraint(constraint);
                if (index == length) break;
                ch = criteria.charAt(index);
            }
            if (ch == '\\' && index + 1 < length) {
                ch = criteria.charAt(++index);
            } else if (ch == '\'') {
                String typedVar;
                int endIndex;
                int newIndex = StringToConstraintsTransformer.handleCharacterLiteral(criteria, index, pattern);
                if (newIndex != index) {
                    index = newIndex;
                    continue;
                }
                for (endIndex = ++index; endIndex < length && Character.isJavaIdentifierPart(criteria.charAt(endIndex)); ++endIndex) {
                }
                if (endIndex == index) {
                    throw new MalformedPatternException(SSRBundle.message("error.expected.character", new Object[0]));
                }
                boolean anonymous = false;
                if (criteria.charAt(index) == '_') {
                    anonymous = true;
                    typedVar = endIndex == index + 1 ? "_" + ++anonymousTypedVarsCount : criteria.substring(index + 1, endIndex);
                } else {
                    typedVar = criteria.substring(index, endIndex);
                }
                pattern.append("$").append(typedVar).append("$");
                index = endIndex;
                MatchVariableConstraint constraint = options.getVariableConstraint(typedVar);
                boolean constraintCreated = false;
                if (constraint == null) {
                    constraint = new MatchVariableConstraint();
                    constraint.setName(typedVar);
                    constraintCreated = true;
                }
                int savedIndex = index;
                int minOccurs = 1;
                int maxOccurs = 1;
                boolean greedy = true;
                if (index < length) {
                    ch = criteria.charAt(index);
                    if (ch == '+') {
                        maxOccurs = Integer.MAX_VALUE;
                        ++index;
                    } else if (ch == '?') {
                        minOccurs = 0;
                        ++index;
                    } else if (ch == '*') {
                        minOccurs = 0;
                        maxOccurs = Integer.MAX_VALUE;
                        ++index;
                    } else if (ch == '{') {
                        ++index;
                        minOccurs = 0;
                        while (index < length && (ch = criteria.charAt(index)) >= '0' && ch <= '9') {
                            if ((minOccurs = minOccurs * 10 + (ch - 48)) < 0) {
                                throw new MalformedPatternException(SSRBundle.message("error.overflow", new Object[0]));
                            }
                            ++index;
                        }
                        if (ch == ',') {
                            ++index;
                            maxOccurs = 0;
                            while (index < length && (ch = criteria.charAt(index)) >= '0' && ch <= '9') {
                                if ((maxOccurs = maxOccurs * 10 + (ch - 48)) < 0) {
                                    throw new MalformedPatternException(SSRBundle.message("error.overflow", new Object[0]));
                                }
                                ++index;
                            }
                        } else {
                            maxOccurs = Integer.MAX_VALUE;
                        }
                        if (ch != '}') {
                            if (maxOccurs == Integer.MAX_VALUE) {
                                throw new MalformedPatternException(SSRBundle.message("error.expected.brace1", new Object[0]));
                            }
                            throw new MalformedPatternException(SSRBundle.message("error.expected.brace2", new Object[0]));
                        }
                        ++index;
                    }
                    if (index < length && (ch = criteria.charAt(index)) == '?') {
                        greedy = false;
                        ++index;
                    }
                }
                if (constraintCreated) {
                    constraint.setMinCount(minOccurs);
                    constraint.setMaxCount(maxOccurs);
                    constraint.setGreedy(greedy);
                    constraint.setPartOfSearchResults(!anonymous);
                    if (targetFound && !anonymous) {
                        throw new MalformedPatternException(SSRBundle.message("error.only.one.target.allowed", new Object[0]));
                    }
                    targetFound = !anonymous;
                } else if (savedIndex != index) {
                    throw new MalformedPatternException(SSRBundle.message("error.condition.only.on.first.variable.reference", new Object[0]));
                }
                if (index < length && criteria.charAt(index) == ':') {
                    if (++index >= length) {
                        throw new MalformedPatternException(SSRBundle.message("error.expected.condition", ":"));
                    }
                    ch = criteria.charAt(index);
                    if (ch == ':') {
                        pattern.append(ch);
                    } else {
                        if (!constraintCreated) {
                            throw new MalformedPatternException(SSRBundle.message("error.condition.only.on.first.variable.reference", new Object[0]));
                        }
                        index = StringToConstraintsTransformer.handleTypedVarCondition(index, criteria, constraint);
                    }
                }
                if (constraintCreated) {
                    options.addVariableConstraint(constraint);
                }
                if (index == length) break;
                --index;
                continue;
            }
            pattern.append(ch);
        }
        options.setSearchPattern(pattern.toString());
    }

    public static int handleCharacterLiteral(String criteria, int index, StringBuilder pattern) {
        int length = criteria.length();
        if (index + 1 < length && criteria.charAt(index + 1) == '\'') {
            pattern.append('\'');
            return index + 1;
        }
        if (index + 2 < length && criteria.charAt(index + 2) == '\'') {
            pattern.append(criteria, index, index + 3);
            return index + 2;
        }
        if (index + 3 < length && criteria.charAt(index + 1) == '\\' && criteria.charAt(index + 3) == '\'') {
            pattern.append(criteria, index, index + 4);
            return index + 3;
        }
        if (index + 7 < length && criteria.charAt(index + 1) == '\\' && criteria.charAt(index + 2) == 'u' && criteria.charAt(index + 7) == '\'') {
            pattern.append(criteria, index, index + 8);
            return index + 7;
        }
        return index;
    }

    private static int handleTypedVarCondition(int index, String criteria, MatchVariableConstraint constraint) {
        int length = criteria.length();
        char ch = criteria.charAt(index);
        if (ch == '+' || ch == '*') {
            switch (ch) {
                case '+': {
                    constraint.setStrictlyWithinHierarchy(true);
                    break;
                }
                case '*': {
                    constraint.setWithinHierarchy(true);
                }
            }
            if (++index >= length) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", Character.valueOf(ch)));
            }
            ch = criteria.charAt(index);
        }
        if (ch == '[') {
            boolean quoted = false;
            int endIndex = index++;
            while (++endIndex < length) {
                if (criteria.charAt(endIndex - 1) == '\\') continue;
                ch = criteria.charAt(endIndex);
                if (ch == '\"') {
                    quoted = !quoted;
                    continue;
                }
                if (ch != ']' || quoted) continue;
            }
            if (quoted) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.value", "\""));
            }
            if (ch != ']') {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition.or.bracket", new Object[0]));
            }
            StringToConstraintsTransformer.parseCondition(constraint, criteria.substring(index, endIndex));
            return endIndex + 1;
        }
        return StringToConstraintsTransformer.handleRegExp(index, criteria, constraint);
    }

    private static int handleRegExp(int index, String criteria, MatchVariableConstraint constraint) {
        int endIndex;
        int length = criteria.length();
        for (endIndex = index; endIndex < length && !Character.isWhitespace(criteria.charAt(endIndex)); ++endIndex) {
        }
        if (endIndex == index) {
            if (criteria.charAt(index - 1) == ':') {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", ":"));
            }
            return endIndex;
        }
        String regexp = criteria.substring(index, endIndex);
        if (constraint.getRegExp() != null && !constraint.getRegExp().isEmpty() && !constraint.getRegExp().equals(regexp)) {
            throw new MalformedPatternException(SSRBundle.message("error.two.different.type.constraints", new Object[0]));
        }
        StringToConstraintsTransformer.checkRegex(regexp);
        constraint.setRegExp(regexp);
        return endIndex;
    }

    private static void parseCondition(MatchVariableConstraint constraint, String condition2) {
        int length = condition2.length();
        StringBuilder text2 = new StringBuilder();
        boolean invert = false;
        boolean optionExpected = true;
        for (int i = 0; i < length; ++i) {
            char c = condition2.charAt(i);
            if (Character.isWhitespace(c)) {
                if (text2.length() == 0) continue;
                StringToConstraintsTransformer.handleOption(constraint, text2.toString(), "", invert);
                optionExpected = false;
                continue;
            }
            if (c == '(') {
                if (text2.length() == 0) {
                    throw new MalformedPatternException(SSRBundle.message("error.expected.condition.name", new Object[0]));
                }
                String option = text2.toString();
                text2.setLength(0);
                int spaces = 0;
                while (++i < length && condition2.charAt(i) == ' ') {
                    ++spaces;
                }
                --i;
                boolean quoted = false;
                boolean closed = false;
                while (++i < length) {
                    c = condition2.charAt(i);
                    if (condition2.charAt(i - 1) != '\\') {
                        if (c == '\"') {
                            quoted = !quoted;
                        } else if (c == ')' && !quoted) {
                            int j;
                            for (j = 1; j <= spaces && condition2.charAt(i - j) == ' '; ++j) {
                            }
                            if (j - 1 == spaces) {
                                closed = true;
                                break;
                            }
                        }
                    }
                    text2.append(c);
                }
                if (quoted) {
                    throw new MalformedPatternException(SSRBundle.message("error.expected.value", "\""));
                }
                if (!closed) {
                    throw new MalformedPatternException(SSRBundle.message("error.expected.value", StringUtil.repeatSymbol((char)' ', (int)spaces) + ")"));
                }
                StringToConstraintsTransformer.handleOption(constraint, option, text2.toString(), invert);
                text2.setLength(0);
                invert = false;
                optionExpected = false;
                continue;
            }
            if (c == '&') {
                if (text2.length() != 0) {
                    StringToConstraintsTransformer.handleOption(constraint, text2.toString(), "", invert);
                    optionExpected = false;
                }
                if (++i == length || condition2.charAt(i) != '&' || optionExpected) {
                    throw new MalformedPatternException(SSRBundle.message("error.unexpected.value", "&"));
                }
                text2.setLength(0);
                invert = false;
                optionExpected = true;
                continue;
            }
            if (!optionExpected) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.value", "&&"));
            }
            if (c == '!') {
                if (text2.length() != 0) {
                    throw new MalformedPatternException(SSRBundle.message("error.unexpected.value", "!"));
                }
                invert = !invert;
                continue;
            }
            text2.append(c);
        }
        if (text2.length() != 0) {
            StringToConstraintsTransformer.handleOption(constraint, text2.toString(), "", invert);
        } else {
            if (invert) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", "!"));
            }
            if (optionExpected) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", "&&"));
            }
        }
    }

    private static void handleOption(@NotNull MatchVariableConstraint constraint, @NotNull String option, @NotNull String argument, boolean invert) {
        if (constraint == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(0);
        }
        if (option == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(1);
        }
        if (argument == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(2);
        }
        argument = argument.trim();
        if (option.equalsIgnoreCase(REF)) {
            if (argument.isEmpty()) {
                throw new MalformedPatternException(SSRBundle.message("error.pattern.argument.expected", option));
            }
            constraint.setReferenceConstraint(argument);
            constraint.setInvertReference(invert);
        } else if (option.equalsIgnoreCase(REGEX) || option.equalsIgnoreCase(REGEXW)) {
            if (argument.isEmpty()) {
                throw new MalformedPatternException(SSRBundle.message("error.regular.expression.argument.expected", option));
            }
            if (argument.charAt(0) == '*') {
                argument = argument.substring(1);
                constraint.setWithinHierarchy(true);
            }
            StringToConstraintsTransformer.checkRegex(argument);
            constraint.setRegExp(argument);
            constraint.setInvertRegExp(invert);
            if (option.equalsIgnoreCase(REGEXW)) {
                constraint.setWholeWordsOnly(true);
            }
        } else if (option.equalsIgnoreCase(EXPRTYPE)) {
            if (argument.isEmpty()) {
                throw new MalformedPatternException(SSRBundle.message("error.regular.expression.argument.expected", option));
            }
            if (argument.charAt(0) == '*') {
                argument = argument.substring(1);
                constraint.setExprTypeWithinHierarchy(true);
            }
            StringToConstraintsTransformer.checkRegex(argument);
            constraint.setNameOfExprType(argument);
            constraint.setInvertExprType(invert);
        } else if (option.equalsIgnoreCase(FORMAL)) {
            if (argument.isEmpty()) {
                throw new MalformedPatternException(SSRBundle.message("error.regular.expression.argument.expected", option));
            }
            if (argument.charAt(0) == '*') {
                argument = argument.substring(1);
                constraint.setFormalArgTypeWithinHierarchy(true);
            }
            StringToConstraintsTransformer.checkRegex(argument);
            constraint.setNameOfFormalArgType(argument);
            constraint.setInvertFormalType(invert);
        } else if (option.equalsIgnoreCase(SCRIPT)) {
            if (argument.isEmpty()) {
                throw new MalformedPatternException(SSRBundle.message("error.script.argument.expected", option));
            }
            if (invert) {
                throw new MalformedPatternException(SSRBundle.message("error.cannot.invert", option));
            }
            constraint.setScriptCodeConstraint(argument);
        } else if (option.equalsIgnoreCase(CONTAINS)) {
            if (argument.isEmpty()) {
                throw new MalformedPatternException(SSRBundle.message("error.pattern.argument.expected", option));
            }
            constraint.setContainsConstraint(argument);
            constraint.setInvertContainsConstraint(invert);
        } else if (option.equalsIgnoreCase(WITHIN)) {
            if (!"__context__".equals(constraint.getName())) {
                throw new MalformedPatternException(SSRBundle.message("error.only.applicable.to.complete.match", option));
            }
            if (argument.isEmpty()) {
                throw new MalformedPatternException(SSRBundle.message("error.pattern.argument.expected", option));
            }
            constraint.setWithinConstraint(argument);
            constraint.setInvertWithinConstraint(invert);
        } else {
            throw new UnsupportedPatternException(SSRBundle.message("option.is.not.recognized.error.message", option));
        }
    }

    private static void checkRegex(@NotNull String regex) {
        if (regex == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(3);
        }
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new MalformedPatternException(SSRBundle.message("invalid.regular.expression", e.getMessage()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = REGEX;
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/StringToConstraintsTransformer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleOption";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRegex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

