/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExprTypePredicate
extends MatchPredicate {
    private final RegExpPredicate delegate;
    private final boolean withinHierarchy;
    private final boolean needsTypeParameters;
    private final boolean needsFullyQualified;
    private final boolean needsArrayType;

    public ExprTypePredicate(String type2, String baseName, boolean _withinHierarchy, boolean caseSensitiveMatch, boolean target2) {
        this.delegate = new RegExpPredicate(type2, caseSensitiveMatch, baseName, false, target2);
        this.withinHierarchy = _withinHierarchy;
        this.needsTypeParameters = type2.indexOf(60) >= 0;
        this.needsFullyQualified = type2.indexOf(46) >= 0;
        this.needsArrayType = type2.indexOf(91) >= 0;
    }

    @Override
    public boolean match(PsiElement match, int start, int end, MatchContext context) {
        if (match instanceof PsiIdentifier) {
            match = match.getParent();
        } else if (match instanceof PsiExpressionStatement) {
            match = ((PsiExpressionStatement)match).getExpression();
        }
        if (!(match instanceof PsiExpression)) {
            return false;
        }
        PsiType type2 = this.evalType((PsiExpression)match, context);
        return type2 != null && this.doMatchWithTheType(type2, context, match, null);
    }

    protected PsiType evalType(PsiExpression match, MatchContext context) {
        PsiElement parent;
        if (match instanceof PsiReferenceExpression && (parent = match.getParent()) instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)parent).getType();
        }
        return match.getType();
    }

    private boolean doMatchWithTheType(PsiType type2, MatchContext context, PsiElement matchedNode, Set<PsiType> visited) {
        List<String> permutations = this.getTextPermutations(type2);
        for (String permutation : permutations) {
            if (!this.delegate.doMatch(permutation, context, matchedNode)) continue;
            return true;
        }
        if (this.withinHierarchy) {
            if (visited == null) {
                visited = new THashSet();
                visited.add(type2);
            }
            for (PsiType superType : type2.getSuperTypes()) {
                if (!visited.add(superType) || !this.doMatchWithTheType(superType, context, matchedNode, (Set<PsiType>)visited)) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getTextPermutations(PsiType type2) {
        String dimensions;
        if (type2 instanceof PsiArrayType) {
            if (!this.needsArrayType) {
                return Collections.emptyList();
            }
            dimensions = StringUtil.repeat((String)"[]", (int)type2.getArrayDimensions());
            type2 = type2.getDeepComponentType();
        } else {
            dimensions = "";
        }
        SmartList result2 = new SmartList();
        if (type2 instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type2;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            StringBuilder typeText = new StringBuilder();
            if (aClass != null) {
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                ExprTypePredicate.buildText(aClass, substitutor, true, typeText);
                typeText.append(dimensions);
                String unqualified = typeText.toString();
                if (this.needsTypeParameters) {
                    result2.add(unqualified);
                }
                ExprTypePredicate.addWithoutTypeParameters(unqualified, dimensions, (List<String>)result2);
                if (typeText.indexOf(".") >= 0) {
                    typeText.setLength(0);
                    ExprTypePredicate.buildText(aClass, substitutor, false, typeText);
                    typeText.append(dimensions);
                    String outerClassQualified = typeText.toString();
                    if (this.needsTypeParameters) {
                        result2.add(outerClassQualified);
                    }
                    ExprTypePredicate.addWithoutTypeParameters(outerClassQualified, dimensions, (List<String>)result2);
                }
                if (!this.needsFullyQualified) {
                    return result2;
                }
            }
        }
        String fullyQualified = type2.getCanonicalText() + dimensions;
        if (this.needsTypeParameters) {
            result2.add(fullyQualified);
        }
        ExprTypePredicate.addWithoutTypeParameters(fullyQualified, dimensions, (List<String>)result2);
        return result2;
    }

    private static void addWithoutTypeParameters(String typeText, String suffix, List<String> result2) {
        int lt = typeText.indexOf("<");
        if (lt >= 0) {
            result2.add(typeText.substring(0, lt) + suffix);
        } else if (result2.isEmpty() || !result2.get(result2.size() - 1).equals(typeText)) {
            result2.add(typeText);
        }
    }

    private static void buildText(PsiClass aClass, PsiSubstitutor substitutor, boolean qualifyInnerClasses, StringBuilder text2) {
        PsiTypeParameter[] parameters2;
        PsiElement parent;
        if (aClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)aClass).getBaseClassType();
            PsiClassType.ClassResolveResult baseResolveResult = baseClassType.resolveGenerics();
            PsiClass baseClass = baseResolveResult.getElement();
            if (baseClass != null) {
                ExprTypePredicate.buildText(baseClass, substitutor == null ? null : baseResolveResult.getSubstitutor(), qualifyInnerClasses, text2);
            } else {
                text2.append(baseClassType.getCanonicalText());
            }
            return;
        }
        if (qualifyInnerClasses && (parent = aClass.getParent()) instanceof PsiClass && !(parent instanceof PsiAnonymousClass)) {
            ExprTypePredicate.buildText((PsiClass)parent, substitutor, true, text2);
            text2.append('.');
        }
        text2.append(aClass.getName());
        if (substitutor != null && (parameters2 = aClass.getTypeParameters()).length > 0) {
            int pos = text2.length();
            text2.append('<');
            Map substitutionMap = substitutor.getSubstitutionMap();
            int length = parameters2.length;
            for (int i = 0; i < length; ++i) {
                PsiClassType classType;
                PsiClassType.ClassResolveResult result2;
                PsiClass aClass1;
                PsiTypeParameter parameter2 = parameters2[i];
                PsiType parameterType = (PsiType)substitutionMap.get(parameter2);
                if (parameterType == null) {
                    text2.setLength(pos);
                    return;
                }
                if (i > 0) {
                    text2.append(',');
                }
                if (parameterType instanceof PsiClassType && (aClass1 = (result2 = (classType = (PsiClassType)parameterType).resolveGenerics()).getElement()) != null) {
                    ExprTypePredicate.buildText(aClass1, result2.getSubstitutor(), qualifyInnerClasses, text2);
                    continue;
                }
                text2.append(parameterType.getPresentableText());
            }
            text2.append('>');
        }
    }
}

