/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Convertor;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ExistingTemplatesComponent {
    private final Tree patternTree;
    private final DefaultTreeModel patternTreeModel;
    private final DefaultMutableTreeNode userTemplatesNode;
    private final JComponent panel;
    private final CollectionListModel<Configuration> historyModel;
    private final JList<Configuration> historyList;
    private final JComponent historyPanel;
    private DialogWrapper owner;
    private final Project project;
    private final SmartList<Runnable> queuedActions = new SmartList();

    private ExistingTemplatesComponent(final Project project2) {
        this.project = project2;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(null);
        this.patternTreeModel = new DefaultTreeModel(root);
        this.patternTree = ExistingTemplatesComponent.createTree(this.patternTreeModel);
        DefaultMutableTreeNode parent = null;
        String lastCategory = null;
        ArrayList<DefaultMutableTreeNode> nodesToExpand = new ArrayList<DefaultMutableTreeNode>();
        List<Configuration> predefined = StructuralSearchUtil.getPredefinedTemplates();
        for (Configuration info : predefined) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(info);
            if (lastCategory == null || !lastCategory.equals(info.getCategory())) {
                if (info.getCategory().length() > 0) {
                    parent = new DefaultMutableTreeNode(info.getCategory());
                    root.add(parent);
                    nodesToExpand.add(parent);
                    lastCategory = info.getCategory();
                } else {
                    root.add(node);
                    continue;
                }
            }
            parent.add(node);
        }
        this.userTemplatesNode = new DefaultMutableTreeNode(SSRBundle.message("user.defined.category", new Object[0]));
        root.add(this.userTemplatesNode);
        for (DefaultMutableTreeNode nodeToExpand : nodesToExpand) {
            this.patternTree.expandPath(new TreePath(new Object[]{root, nodeToExpand}));
        }
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)this.patternTree);
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        this.panel = ToolbarDecorator.createDecorator((JTree)this.patternTree).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int[] rows;
                Object selection = ExistingTemplatesComponent.this.patternTree.getLastSelectedPathComponent();
                if (!(selection instanceof DefaultMutableTreeNode)) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selection;
                if (!(node.getUserObject() instanceof Configuration)) {
                    return;
                }
                Configuration configuration = (Configuration)node.getUserObject();
                if (configuration.isPredefined()) {
                    return;
                }
                String configurationName = configuration.getName();
                for (Configuration otherConfiguration : ConfigurationManager.getInstance(project2).getConfigurations()) {
                    String within;
                    MatchVariableConstraint constraint = otherConfiguration.getMatchOptions().getVariableConstraint("__context__");
                    if (constraint == null || !configurationName.equals(within = constraint.getWithinConstraint())) continue;
                    if (2 != Messages.showOkCancelDialog((Project)project2, (String)SSRBundle.message("template.in.use.message", configurationName, otherConfiguration.getName()), (String)SSRBundle.message("template.in.use.title", configurationName), (String)CommonBundle.message((String)"button.remove", (Object[])new Object[0]), (String)Messages.CANCEL_BUTTON, (Icon)AllIcons.General.WarningDialog)) break;
                    return;
                }
                if ((rows = ExistingTemplatesComponent.this.patternTree.getSelectionRows()) != null && rows.length > 0) {
                    ExistingTemplatesComponent.this.patternTree.addSelectionRow(rows[0] - 1);
                }
                ExistingTemplatesComponent.this.patternTreeModel.removeNodeFromParent(node);
                ExistingTemplatesComponent.this.queuedActions.add(() -> ConfigurationManager.getInstance(project2).removeConfiguration(configuration));
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                DefaultMutableTreeNode node;
                Object userObject;
                Object selection = ExistingTemplatesComponent.this.patternTree.getLastSelectedPathComponent();
                if (selection instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)selection).getUserObject()) instanceof Configuration) {
                    Configuration configuration = (Configuration)userObject;
                    return !configuration.isPredefined();
                }
                return false;
            }
        }).addExtraAction(AnActionButton.fromAction((AnAction)actionManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)this.patternTree))).addExtraAction(AnActionButton.fromAction((AnAction)actionManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)this.patternTree))).createPanel();
        new JPanel(new BorderLayout());
        this.configureSelectTemplateAction((JComponent)this.patternTree);
        this.historyModel = new CollectionListModel((Object[])new Configuration[0]);
        this.historyPanel = new JPanel(new BorderLayout());
        this.historyPanel.add("North", new JLabel(SSRBundle.message("used.templates", new Object[0])));
        this.historyList = new JBList(this.historyModel);
        this.historyPanel.add("Center", ScrollPaneFactory.createScrollPane(this.historyList));
        this.historyList.setSelectionMode(0);
        ListSpeedSearch<Configuration> speedSearch = new ListSpeedSearch<Configuration>(this.historyList, Configuration::getName);
        this.historyList.setCellRenderer((ListCellRenderer<Configuration>)((Object)new ExistingTemplatesListCellRenderer(speedSearch)));
        this.configureSelectTemplateAction(this.historyList);
    }

    public void selectConfiguration(String name2) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.patternTreeModel.getRoot();
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultMutableTreeNode category = (DefaultMutableTreeNode)root.getChildAt(i);
            int count1 = category.getChildCount();
            for (int j = 0; j < count1; ++j) {
                DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)category.getChildAt(j);
                Configuration configuration = (Configuration)leaf.getUserObject();
                if (!name2.equals(configuration.getName())) continue;
                TreeUtil.selectInTree((DefaultMutableTreeNode)leaf, (boolean)false, (JTree)this.patternTree, (boolean)false);
                return;
            }
        }
    }

    private void initialize() {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance(this.project);
        this.userTemplatesNode.removeAllChildren();
        for (Configuration config : configurationManager.getConfigurations()) {
            this.userTemplatesNode.add(new DefaultMutableTreeNode(config));
        }
        this.patternTreeModel.reload(this.userTemplatesNode);
        this.patternTree.expandPath(new TreePath(new Object[]{this.patternTreeModel.getRoot(), this.userTemplatesNode}));
        this.historyModel.replaceAll(configurationManager.getHistoryConfigurations());
        this.historyList.setSelectedIndex(0);
    }

    private void configureSelectTemplateAction(JComponent component) {
        component.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ExistingTemplatesComponent.this.owner.close(0);
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                ExistingTemplatesComponent.this.owner.close(0);
                return true;
            }
        }.installOn((Component)component);
    }

    private static Tree createTree(TreeModel treeModel) {
        Tree tree = new Tree(treeModel);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setDragEnabled(false);
        tree.setEditable(false);
        tree.getSelectionModel().setSelectionMode(1);
        TreeSpeedSearch speedSearch = new TreeSpeedSearch(tree, (Convertor<TreePath, String>)((Convertor)object -> {
            Object userObject = ((DefaultMutableTreeNode)object.getLastPathComponent()).getUserObject();
            return userObject instanceof Configuration ? ((Configuration)userObject).getName() : userObject.toString();
        }));
        tree.setCellRenderer((TreeCellRenderer)((Object)new ExistingTemplatesTreeCellRenderer(speedSearch)));
        return tree;
    }

    public JTree getPatternTree() {
        return this.patternTree;
    }

    public JComponent getTemplatesPanel() {
        return this.panel;
    }

    public static ExistingTemplatesComponent getInstance(Project project2) {
        ExistingTemplatesComponent existingTemplatesComponent = (ExistingTemplatesComponent)ServiceManager.getService((Project)project2, ExistingTemplatesComponent.class);
        existingTemplatesComponent.initialize();
        return existingTemplatesComponent;
    }

    public JList<Configuration> getHistoryList() {
        return this.historyList;
    }

    public JComponent getHistoryPanel() {
        return this.historyPanel;
    }

    public void setOwner(DialogWrapper owner2) {
        this.owner = owner2;
    }

    public void finish(boolean performQueuedActions) {
        if (performQueuedActions) {
            this.queuedActions.forEach(a -> a.run());
        }
        this.queuedActions.clear();
    }

    private static class ExistingTemplatesTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final TreeSpeedSearch mySpeedSearch;

        ExistingTemplatesTreeCellRenderer(TreeSpeedSearch speedSearch) {
            this.mySpeedSearch = speedSearch;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            int style;
            String text2;
            Color foreground;
            DefaultMutableTreeNode treeNode;
            Object userObject;
            if (tree == null) {
                ExistingTemplatesTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if ((userObject = (treeNode = (DefaultMutableTreeNode)value2).getUserObject()) == null) {
                return;
            }
            Color background = selected ? UIUtil.getTreeSelectionBackground((boolean)hasFocus) : UIUtil.getTreeTextBackground();
            Color color = foreground = selected && hasFocus ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeTextForeground();
            if (userObject instanceof Configuration) {
                text2 = ((Configuration)userObject).getName();
                style = 0;
            } else {
                text2 = userObject.toString();
                style = 1;
            }
            SearchUtil.appendFragments(this.mySpeedSearch.getEnteredPrefix(), text2, style, foreground, background, (SimpleColoredComponent)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent$ExistingTemplatesTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private static class ExistingTemplatesListCellRenderer
    extends ColoredListCellRenderer<Configuration> {
        private final ListSpeedSearch mySpeedSearch;

        public ExistingTemplatesListCellRenderer(ListSpeedSearch speedSearch) {
            this.mySpeedSearch = speedSearch;
        }

        protected void customizeCellRenderer(@NotNull JList list2, Configuration value2, int index, boolean selected, boolean focus) {
            if (list2 == null) {
                ExistingTemplatesListCellRenderer.$$$reportNull$$$0(0);
            }
            Color background = selected && !focus ? UIUtil.getListUnfocusedSelectionBackground() : UIUtil.getListBackground((boolean)selected);
            Color foreground = UIUtil.getListForeground((boolean)selected);
            this.setPaintFocusBorder(false);
            SearchUtil.appendFragments(this.mySpeedSearch.getEnteredPrefix(), value2.getName(), 0, foreground, background, (SimpleColoredComponent)this);
            long created = value2.getCreated();
            if (created > 0L) {
                String createdString = DateFormatUtil.formatPrettyDateTime((long)created);
                this.append(" (" + createdString + ')', selected ? new SimpleTextAttributes(0, foreground) : SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent$ExistingTemplatesListCellRenderer", "customizeCellRenderer"));
        }
    }
}

