/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.idea.Bombed;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.testFramework.CpuUsageData;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.SkipInHeadlessEnvironment;
import com.intellij.testFramework.SkipSlowTestLocally;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.containers.HashMap;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.ref.GCUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.Equality;
import java.awt.AWTEvent;
import java.awt.GraphicsEnvironment;
import java.awt.event.InvocationEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import junit.framework.AssertionFailedError;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.junit.Assert;

public class PlatformTestUtil {
    public static final boolean COVERAGE_ENABLED_BUILD = "true".equals(System.getProperty("idea.coverage.enabled.build"));
    public static final boolean SKIP_HEADLESS = GraphicsEnvironment.isHeadless();
    public static final boolean SKIP_SLOW = Boolean.getBoolean("skip.slow.tests.locally");
    private static final List<Runnable> ourProjectCleanups = new CopyOnWriteArrayList<Runnable>();
    private static final OutputStream NULL = new OutputStream(){

        @Override
        public void write(int b) {
        }
    };

    @NotNull
    public static String getTestName(@NotNull String name2, boolean lowercaseFirstLetter) {
        if (name2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(0);
        }
        String string = StringUtil.isEmpty((String)(name2 = StringUtil.trimStart((String)name2, (String)"test"))) ? "" : PlatformTestUtil.lowercaseFirstLetter(name2, lowercaseFirstLetter);
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String lowercaseFirstLetter(@NotNull String name2, boolean lowercaseFirstLetter) {
        if (name2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(2);
        }
        if (lowercaseFirstLetter && !PlatformTestUtil.isAllUppercaseName(name2)) {
            name2 = Character.toLowerCase(name2.charAt(0)) + name2.substring(1);
        }
        String string = name2;
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static boolean isAllUppercaseName(@NotNull String name2) {
        if (name2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(4);
        }
        int uppercaseChars = 0;
        for (int i = 0; i < name2.length(); ++i) {
            if (Character.isLowerCase(name2.charAt(i))) {
                return false;
            }
            if (!Character.isUpperCase(name2.charAt(i))) continue;
            ++uppercaseChars;
        }
        return uppercaseChars >= 3;
    }

    public static <T> void registerExtension(@NotNull ExtensionPointName<T> name2, @NotNull T t, @NotNull Disposable parentDisposable) {
        if (name2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(5);
        }
        if (t == null) {
            PlatformTestUtil.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            PlatformTestUtil.$$$reportNull$$$0(7);
        }
        PlatformTestUtil.registerExtension(Extensions.getRootArea(), name2, t, parentDisposable);
    }

    public static <T> void registerExtension(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> name2, @NotNull T t, @NotNull Disposable parentDisposable) {
        if (area == null) {
            PlatformTestUtil.$$$reportNull$$$0(8);
        }
        if (name2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(9);
        }
        if (t == null) {
            PlatformTestUtil.$$$reportNull$$$0(10);
        }
        if (parentDisposable == null) {
            PlatformTestUtil.$$$reportNull$$$0(11);
        }
        ExtensionPoint extensionPoint = area.getExtensionPoint(name2.getName());
        extensionPoint.registerExtension(t);
        Disposer.register((Disposable)parentDisposable, () -> {
            if (t == null) {
                PlatformTestUtil.$$$reportNull$$$0(42);
            }
            extensionPoint.unregisterExtension(t);
        });
    }

    @Nullable
    public static String toString(@Nullable Object node, @Nullable Queryable.PrintInfo printInfo) {
        if (node instanceof AbstractTreeNode) {
            if (printInfo != null) {
                return ((AbstractTreeNode)node).toTestString(printInfo);
            }
            String presentation = ((AbstractTreeNode)node).getTestPresentation();
            return presentation;
        }
        return String.valueOf(node);
    }

    public static String print(JTree tree, boolean withSelection) {
        return PlatformTestUtil.print(tree, tree.getModel().getRoot(), withSelection, null, null);
    }

    public static String print(JTree tree, Object root, @Nullable Queryable.PrintInfo printInfo, boolean withSelection) {
        return PlatformTestUtil.print(tree, root, withSelection, printInfo, null);
    }

    public static String print(JTree tree, boolean withSelection, @Nullable Condition<String> nodePrintCondition) {
        return PlatformTestUtil.print(tree, tree.getModel().getRoot(), withSelection, null, nodePrintCondition);
    }

    private static String print(JTree tree, Object root, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, @Nullable Condition<String> nodePrintCondition) {
        StringBuilder buffer = new StringBuilder();
        Collection<String> strings = PlatformTestUtil.printAsList(tree, root, withSelection, printInfo, nodePrintCondition);
        for (String string : strings) {
            buffer.append(string).append("\n");
        }
        return buffer.toString();
    }

    private static Collection<String> printAsList(JTree tree, Object root, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, Condition<String> nodePrintCondition) {
        ArrayList<String> strings = new ArrayList<String>();
        PlatformTestUtil.printImpl(tree, root, strings, 0, withSelection, printInfo, nodePrintCondition);
        return strings;
    }

    private static void printImpl(JTree tree, Object root, Collection<String> strings, int level, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, @Nullable Condition<String> nodePrintCondition) {
        DefaultMutableTreeNode dmt = (DefaultMutableTreeNode)root;
        Object userObject = dmt.getUserObject();
        String nodeText = PlatformTestUtil.toString(userObject, printInfo);
        if (nodePrintCondition != null && !nodePrintCondition.value((Object)nodeText)) {
            return;
        }
        StringBuilder buff = new StringBuilder();
        StringUtil.repeatSymbol((Appendable)buff, (char)' ', (int)level);
        boolean expanded = tree.isExpanded(new TreePath(dmt.getPath()));
        if (!dmt.isLeaf() && (tree.isRootVisible() || dmt != tree.getModel().getRoot() || dmt.getChildCount() > 0)) {
            buff.append(expanded ? "-" : "+");
        }
        boolean selected = tree.getSelectionModel().isPathSelected(new TreePath(dmt.getPath()));
        if (withSelection && selected) {
            buff.append("[");
        }
        buff.append(nodeText);
        if (withSelection && selected) {
            buff.append("]");
        }
        strings.add(buff.toString());
        int childCount = tree.getModel().getChildCount(root);
        if (expanded) {
            for (int i = 0; i < childCount; ++i) {
                PlatformTestUtil.printImpl(tree, tree.getModel().getChild(root, i), strings, level + 1, withSelection, printInfo, nodePrintCondition);
            }
        }
    }

    public static void assertTreeEqual(JTree tree, @NonNls String expected) {
        PlatformTestUtil.assertTreeEqual(tree, expected, false);
    }

    public static void assertTreeEqualIgnoringNodesOrder(JTree tree, @NonNls String expected) {
        Collection<String> actualNodesPresentation = PlatformTestUtil.printAsList(tree, tree.getModel().getRoot(), false, null, null);
        List expectedNodes = StringUtil.split((String)expected, (String)"\n");
        UsefulTestCase.assertSameElements(actualNodesPresentation, expectedNodes);
    }

    public static void assertTreeEqual(JTree tree, String expected, boolean checkSelected) {
        String treeStringPresentation = PlatformTestUtil.print(tree, checkSelected);
        Assert.assertEquals((Object)expected, (Object)treeStringPresentation);
    }

    @Nullable
    public static <T> T waitForPromise(@NotNull Promise<T> promise2) {
        if (promise2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(12);
        }
        Application app = ApplicationManager.getApplication();
        assert (!app.isWriteAccessAllowed()) : "It's a bad idea to wait for a promise under the write action. Somebody creates an alarm which requires read action and you are deadlocked.";
        assert (app.isDispatchThread());
        AtomicBoolean complete = new AtomicBoolean(false);
        promise2.processed(ignore -> complete.set(true));
        Object result2 = null;
        long start = System.currentTimeMillis();
        do {
            UIUtil.dispatchAllInvocationEvents();
            try {
                result2 = promise2.blockingGet(20, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start > 100000L) {
                throw new AssertionError((Object)"The promise takes too long... aborting");
            }
        } while (!complete.get());
        UIUtil.dispatchAllInvocationEvents();
        return (T)result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForAlarm(int delay) {
        Application app = ApplicationManager.getApplication();
        assert (!app.isWriteAccessAllowed()) : "It's a bad idea to wait for an alarm under the write action. Somebody creates an alarm which requires read action and you are deadlocked.";
        assert (app.isDispatchThread());
        Disposable tempDisposable = Disposer.newDisposable();
        AtomicBoolean runnableInvoked = new AtomicBoolean();
        AtomicBoolean pooledRunnableInvoked = new AtomicBoolean();
        AtomicBoolean alarmInvoked1 = new AtomicBoolean();
        AtomicBoolean alarmInvoked2 = new AtomicBoolean();
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        Alarm pooledAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, tempDisposable);
        ModalityState initialModality = ModalityState.current();
        alarm.addRequest(() -> {
            alarmInvoked1.set(true);
            app.invokeLater(() -> {
                runnableInvoked.set(true);
                alarm.addRequest(() -> alarmInvoked2.set(true), delay);
            });
        }, delay);
        pooledAlarm.addRequest(() -> pooledRunnableInvoked.set(true), delay);
        UIUtil.dispatchAllInvocationEvents();
        long start = System.currentTimeMillis();
        try {
            boolean sleptAlready = false;
            while (!alarmInvoked2.get()) {
                AtomicBoolean laterInvoked = new AtomicBoolean();
                ApplicationManager.getApplication().invokeLater(() -> laterInvoked.set(true));
                UIUtil.dispatchAllInvocationEvents();
                Assert.assertTrue((boolean)laterInvoked.get());
                TimeoutUtil.sleep((long)(sleptAlready ? 10L : (long)delay));
                sleptAlready = true;
                if (System.currentTimeMillis() - start > 100000L) {
                    throw new AssertionError((Object)("Couldn't await alarm; alarm passed=" + alarmInvoked1.get() + "; modality1=" + initialModality + "; modality2=" + ModalityState.current() + "; non-modal=" + (initialModality == ModalityState.NON_MODAL) + "; invokeLater passed=" + runnableInvoked.get() + "; pooled alarm passed=" + pooledRunnableInvoked.get() + "; app.disposed=" + app.isDisposed() + "; alarm.disposed=" + alarm.isDisposed() + "; alarm.requests=" + alarm.getActiveRequestCount() + "\n delayQueue=" + StringUtil.trimLog((String)((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).dumpQueue(), (int)1000) + "\n invocatorQueue=" + LaterInvocator.getLaterInvocatorQueue()));
                }
            }
        }
        finally {
            Disposer.dispose((Disposable)tempDisposable);
        }
        UIUtil.dispatchAllInvocationEvents();
    }

    public static void dispatchAllInvocationEventsInIdeEventQueue() throws InterruptedException {
        AWTEvent event;
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        while ((event = eventQueue.peekEvent()) != null) {
            AWTEvent event1 = eventQueue.getNextEvent();
            if (!(event1 instanceof InvocationEvent)) continue;
            eventQueue.dispatchEvent(event1);
        }
    }

    public static void dispatchAllEventsInIdeEventQueue() throws InterruptedException {
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        while (PlatformTestUtil.dispatchNextEventIfAny(eventQueue) != null) {
        }
    }

    public static AWTEvent dispatchNextEventIfAny(@NotNull IdeEventQueue eventQueue) throws InterruptedException {
        if (eventQueue == null) {
            PlatformTestUtil.$$$reportNull$$$0(13);
        }
        assert (SwingUtilities.isEventDispatchThread()) : Thread.currentThread();
        AWTEvent event = eventQueue.peekEvent();
        if (event == null) {
            return null;
        }
        AWTEvent event1 = eventQueue.getNextEvent();
        eventQueue.dispatchEvent(event1);
        return event1;
    }

    private static Date raidDate(Bombed bombed) {
        Calendar instance2 = Calendar.getInstance();
        instance2.set(1, bombed.year());
        instance2.set(2, bombed.month());
        instance2.set(5, bombed.day());
        instance2.set(11, bombed.time());
        instance2.set(12, 0);
        return instance2.getTime();
    }

    public static boolean bombExplodes(Bombed bombedAnnotation) {
        Date now = new Date();
        return now.after(PlatformTestUtil.raidDate(bombedAnnotation));
    }

    public static StringBuilder print(AbstractTreeStructure structure, Object node, int currentLevel, @Nullable Comparator comparator2, int maxRowCount, char paddingChar, @Nullable Queryable.PrintInfo printInfo) {
        return PlatformTestUtil.print(structure, node, currentLevel, comparator2, maxRowCount, paddingChar, (Object o) -> PlatformTestUtil.toString(o, printInfo));
    }

    public static String print(AbstractTreeStructure structure, Object node, Function<Object, String> nodePresenter) {
        return PlatformTestUtil.print(structure, node, 0, Comparator.comparing(nodePresenter), -1, ' ', nodePresenter).toString();
    }

    private static StringBuilder print(AbstractTreeStructure structure, Object node, int currentLevel, @Nullable Comparator comparator2, int maxRowCount, char paddingChar, Function<Object, String> nodePresenter) {
        StringBuilder buffer = new StringBuilder();
        PlatformTestUtil.doPrint(buffer, currentLevel, node, structure, comparator2, maxRowCount, 0, paddingChar, nodePresenter);
        return buffer;
    }

    private static int doPrint(StringBuilder buffer, int currentLevel, Object node, AbstractTreeStructure structure, @Nullable Comparator comparator2, int maxRowCount, int currentLine, char paddingChar, Function<Object, String> nodePresenter) {
        if (currentLine >= maxRowCount && maxRowCount != -1) {
            return currentLine;
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)paddingChar, (int)currentLevel);
        buffer.append(nodePresenter.apply(node)).append("\n");
        ++currentLine;
        Object[] children2 = structure.getChildElements(node);
        if (comparator2 != null) {
            ArrayList<Object> list2 = new ArrayList<Object>(Arrays.asList(children2));
            Comparator c = comparator2;
            Collections.sort(list2, c);
            children2 = ArrayUtil.toObjectArray(list2);
        }
        for (Object child : children2) {
            currentLine = PlatformTestUtil.doPrint(buffer, currentLevel + 1, child, structure, comparator2, maxRowCount, currentLine, paddingChar, nodePresenter);
        }
        return currentLine;
    }

    public static String print(Object[] objects) {
        return PlatformTestUtil.print(Arrays.asList(objects));
    }

    public static String print(Collection c) {
        StringBuilder result2 = new StringBuilder();
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            Object each = iterator.next();
            result2.append(PlatformTestUtil.toString(each, null));
            if (!iterator.hasNext()) continue;
            result2.append("\n");
        }
        return result2.toString();
    }

    public static String print(ListModel model) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < model.getSize(); ++i) {
            result2.append(PlatformTestUtil.toString(model.getElementAt(i), null));
            result2.append("\n");
        }
        return result2.toString();
    }

    public static String print(JTree tree) {
        return PlatformTestUtil.print(tree, false);
    }

    public static void assertTreeStructureEquals(@NotNull TreeModel treeModel, @NotNull String expected) {
        if (treeModel == null) {
            PlatformTestUtil.$$$reportNull$$$0(14);
        }
        if (expected == null) {
            PlatformTestUtil.$$$reportNull$$$0(15);
        }
        Assert.assertEquals((Object)expected.trim(), (Object)PlatformTestUtil.print(PlatformTestUtil.createStructure(treeModel), treeModel.getRoot(), 0, null, -1, ' ', (Queryable.PrintInfo)null).toString().trim());
    }

    @NotNull
    protected static AbstractTreeStructure createStructure(final @NotNull TreeModel treeModel) {
        if (treeModel == null) {
            PlatformTestUtil.$$$reportNull$$$0(16);
        }
        AbstractTreeStructure abstractTreeStructure = new AbstractTreeStructure(){

            public Object getRootElement() {
                return treeModel.getRoot();
            }

            public Object[] getChildElements(Object element) {
                return TreeUtil.nodeChildren((Object)element, (TreeModel)treeModel).toList().toArray();
            }

            @Nullable
            public Object getParentElement(Object element) {
                return ((AbstractTreeNode)element).getParent();
            }

            @NotNull
            public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
                throw new UnsupportedOperationException();
            }

            public void commit() {
                throw new UnsupportedOperationException();
            }

            public boolean hasSomethingToCommit() {
                throw new UnsupportedOperationException();
            }
        };
        if (abstractTreeStructure == null) {
            PlatformTestUtil.$$$reportNull$$$0(17);
        }
        return abstractTreeStructure;
    }

    public static void invokeNamedAction(String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        Assert.assertNotNull((Object)action);
        Presentation presentation = new Presentation();
        DataContext context = DataManager.getInstance().getDataContext();
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)context);
        action.beforeActionPerformedUpdate(event);
        Assert.assertTrue((boolean)presentation.isEnabled());
        action.actionPerformed(event);
    }

    public static void assertTiming(String message2, long expectedMs, long actual) {
        if (COVERAGE_ENABLED_BUILD) {
            return;
        }
        long expectedOnMyMachine = Math.max(1L, expectedMs * Timings.CPU_TIMING / 200L);
        String logMessage = message2;
        if (actual > expectedOnMyMachine) {
            int percentage = (int)(100.0 * (double)(actual - expectedOnMyMachine) / (double)expectedOnMyMachine);
            logMessage = logMessage + ". Operation took " + percentage + "% longer than expected";
        }
        logMessage = logMessage + ". Expected on my machine: " + expectedOnMyMachine + ". Actual: " + actual + ". Expected on Standard machine: " + expectedMs + "; Timings: CPU=" + Timings.CPU_TIMING + ", I/O=" + Timings.IO_TIMING + ".";
        double acceptableChangeFactor = 1.1;
        if (actual < expectedOnMyMachine) {
            System.out.println(logMessage);
            TeamCityLogger.info(logMessage);
        } else if ((double)actual < (double)expectedOnMyMachine * 1.1) {
            TeamCityLogger.warning(logMessage, null);
        } else {
            throw new AssertionFailedError(logMessage);
        }
    }

    @Contract(pure=true)
    public static TestInfo startPerformanceTest(@NonNls @NotNull String what, int expectedMs, @NotNull ThrowableRunnable test) {
        if (what == null) {
            PlatformTestUtil.$$$reportNull$$$0(18);
        }
        if (test == null) {
            PlatformTestUtil.$$$reportNull$$$0(19);
        }
        return new TestInfo(test, expectedMs, what);
    }

    public static boolean canRunTest(@NotNull Class testCaseClass) {
        if (testCaseClass == null) {
            PlatformTestUtil.$$$reportNull$$$0(20);
        }
        if (!SKIP_SLOW && !SKIP_HEADLESS) {
            return true;
        }
        for (Class clazz = testCaseClass; clazz != null; clazz = clazz.getSuperclass()) {
            if (SKIP_HEADLESS && clazz.getAnnotation(SkipInHeadlessEnvironment.class) != null) {
                System.out.println("Class '" + testCaseClass.getName() + "' is skipped because it requires working UI environment");
                return false;
            }
            if (!SKIP_SLOW || clazz.getAnnotation(SkipSlowTestLocally.class) == null) continue;
            System.out.println("Class '" + testCaseClass.getName() + "' is skipped because it is dog slow");
            return false;
        }
        return true;
    }

    public static void assertPathsEqual(@Nullable String expected, @Nullable String actual) {
        if (expected != null) {
            expected = FileUtil.toSystemIndependentName((String)expected);
        }
        if (actual != null) {
            actual = FileUtil.toSystemIndependentName((String)actual);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @NotNull
    public static String getJavaExe() {
        String string = SystemProperties.getJavaHome() + (SystemInfo.isWindows ? "\\bin\\java.exe" : "/bin/java");
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static String getRtJarPath() {
        String home = SystemProperties.getJavaHome();
        String string = SystemInfo.isAppleJvm ? FileUtil.toCanonicalPath((String)(home + "/../Classes/classes.jar")) : home + "/lib/rt.jar";
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    public static void saveProject(@NotNull Project project2) {
        if (project2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(23);
        }
        ProjectManagerEx.getInstanceEx().flushChangedProjectFileAlarm();
        StoreUtil.save(ServiceKt.getStateStore((ComponentManager)project2), project2);
    }

    static void waitForAllBackgroundActivityToCalmDown() {
        CpuUsageData data;
        for (int i = 0; i < 50 && (data = CpuUsageData.measureCpuUsage(() -> TimeoutUtil.sleep((long)100L))).hasAnyActivityBesides(Thread.currentThread()); ++i) {
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void assertTiming(String message2, long expected, @NotNull Runnable runnable2) {
        void actionToMeasure;
        if (runnable2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(24);
        }
        PlatformTestUtil.assertTiming(message2, expected, 4, (Runnable)actionToMeasure);
    }

    private static long measure(@NotNull Runnable actionToMeasure) {
        if (actionToMeasure == null) {
            PlatformTestUtil.$$$reportNull$$$0(25);
        }
        PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
        long start = System.currentTimeMillis();
        actionToMeasure.run();
        long finish = System.currentTimeMillis();
        return finish - start;
    }

    /*
     * WARNING - void declaration
     */
    public static void assertTiming(String message2, long expected, int attempts, @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(26);
        }
        while (true) {
            void actionToMeasure;
            --attempts;
            long duration = PlatformTestUtil.measure((Runnable)actionToMeasure);
            try {
                PlatformTestUtil.assertTiming(message2, expected, duration);
            }
            catch (AssertionFailedError e) {
                if (attempts == 0) {
                    throw e;
                }
                System.gc();
                System.gc();
                System.gc();
                String s = e.getMessage() + "\n  " + attempts + " attempts remain";
                TeamCityLogger.warning(s, null);
                System.err.println(s);
                continue;
            }
            break;
        }
    }

    private static HashMap<String, VirtualFile> buildNameToFileMap(VirtualFile[] files, @Nullable VirtualFileFilter filter2) {
        HashMap map = new HashMap();
        for (VirtualFile file2 : files) {
            if (filter2 != null && !filter2.accept(file2)) continue;
            map.put((Object)file2.getName(), (Object)file2);
        }
        return map;
    }

    public static void assertDirectoriesEqual(VirtualFile dirAfter, VirtualFile dirBefore) throws IOException {
        PlatformTestUtil.assertDirectoriesEqual(dirAfter, dirBefore, null);
    }

    public static void assertDirectoriesEqual(VirtualFile dirAfter, VirtualFile dirBefore, @Nullable VirtualFileFilter fileFilter) throws IOException {
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile[] childrenAfter = dirAfter.getChildren();
        if (dirAfter.isInLocalFileSystem() && dirAfter.getFileSystem() != TempFileSystem.getInstance()) {
            File[] ioAfter = new File(dirAfter.getPath()).listFiles();
            PlatformTestUtil.shallowCompare(childrenAfter, ioAfter);
        }
        VirtualFile[] childrenBefore = dirBefore.getChildren();
        if (dirBefore.isInLocalFileSystem() && dirBefore.getFileSystem() != TempFileSystem.getInstance()) {
            File[] ioBefore = new File(dirBefore.getPath()).listFiles();
            PlatformTestUtil.shallowCompare(childrenBefore, ioBefore);
        }
        HashMap<String, VirtualFile> mapAfter = PlatformTestUtil.buildNameToFileMap(childrenAfter, fileFilter);
        HashMap<String, VirtualFile> mapBefore = PlatformTestUtil.buildNameToFileMap(childrenBefore, fileFilter);
        Set keySetAfter = mapAfter.keySet();
        Set keySetBefore = mapBefore.keySet();
        Assert.assertEquals((String)dirAfter.getPath(), (Object)keySetAfter, (Object)keySetBefore);
        for (String name2 : keySetAfter) {
            VirtualFile fileAfter = (VirtualFile)mapAfter.get((Object)name2);
            VirtualFile fileBefore = (VirtualFile)mapBefore.get((Object)name2);
            if (fileAfter.isDirectory()) {
                PlatformTestUtil.assertDirectoriesEqual(fileAfter, fileBefore, fileFilter);
                continue;
            }
            PlatformTestUtil.assertFilesEqual(fileAfter, fileBefore);
        }
    }

    private static void shallowCompare(VirtualFile[] vfs, @Nullable File[] io) {
        ArrayList<String> vfsPaths = new ArrayList<String>();
        for (VirtualFile file2 : vfs) {
            vfsPaths.add(file2.getPath());
        }
        ArrayList<String> ioPaths = new ArrayList<String>();
        if (io != null) {
            for (File file3 : io) {
                ioPaths.add(file3.getPath().replace(File.separatorChar, '/'));
            }
        }
        Assert.assertEquals((Object)PlatformTestUtil.sortAndJoin(vfsPaths), (Object)PlatformTestUtil.sortAndJoin(ioPaths));
    }

    private static String sortAndJoin(List<String> strings) {
        Collections.sort(strings);
        StringBuilder buf = new StringBuilder();
        for (String string : strings) {
            buf.append(string);
            buf.append('\n');
        }
        return buf.toString();
    }

    public static void assertFilesEqual(VirtualFile fileAfter, VirtualFile fileBefore) throws IOException {
        try {
            PlatformTestUtil.assertJarFilesEqual(VfsUtilCore.virtualToIoFile((VirtualFile)fileAfter), VfsUtilCore.virtualToIoFile((VirtualFile)fileBefore));
        }
        catch (IOException e) {
            String textA;
            boolean canLoadAfterText;
            boolean canLoadBeforeText;
            FileDocumentManager manager = FileDocumentManager.getInstance();
            Document docBefore = manager.getDocument(fileBefore);
            boolean bl = canLoadBeforeText = !fileBefore.getFileType().isBinary() || fileBefore.getFileType() == FileTypes.UNKNOWN;
            String textB = docBefore != null ? docBefore.getText() : (!canLoadBeforeText ? null : LoadTextUtil.getTextByBinaryPresentation(fileBefore.contentsToByteArray(false), fileBefore).toString());
            Document docAfter = manager.getDocument(fileAfter);
            boolean bl2 = canLoadAfterText = !fileBefore.getFileType().isBinary() || fileBefore.getFileType() == FileTypes.UNKNOWN;
            String string = docAfter != null ? docAfter.getText() : (textA = !canLoadAfterText ? null : LoadTextUtil.getTextByBinaryPresentation(fileAfter.contentsToByteArray(false), fileAfter).toString());
            if (textA != null && textB != null) {
                Assert.assertEquals((String)fileAfter.getPath(), (Object)textA, (Object)textB);
            }
            Assert.assertArrayEquals((String)fileAfter.getPath(), (byte[])fileAfter.contentsToByteArray(), (byte[])fileBefore.contentsToByteArray());
        }
    }

    public static void assertJarFilesEqual(File file1, File file2) throws IOException {
        File tempDirectory2;
        File tempDirectory1;
        try (JarFile jarFile1 = new JarFile(file1);
             JarFile jarFile2 = new JarFile(file2);){
            tempDirectory1 = PlatformTestCase.createTempDir("tmp1");
            tempDirectory2 = PlatformTestCase.createTempDir("tmp2");
            ZipUtil.extract((ZipFile)jarFile1, (File)tempDirectory1, null);
            ZipUtil.extract((ZipFile)jarFile2, (File)tempDirectory2, null);
        }
        VirtualFile dirAfter = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempDirectory1);
        Assert.assertNotNull((String)tempDirectory1.toString(), (Object)dirAfter);
        VirtualFile dirBefore = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempDirectory2);
        Assert.assertNotNull((String)tempDirectory2.toString(), (Object)dirBefore);
        ApplicationManager.getApplication().runWriteAction(() -> {
            dirAfter.refresh(false, true);
            dirBefore.refresh(false, true);
        });
        PlatformTestUtil.assertDirectoriesEqual(dirAfter, dirBefore);
    }

    @Deprecated
    public static void assertElementsEqual(Element expected, Element actual) {
        if (!JDOMUtil.areElementsEqual((Element)expected, (Element)actual)) {
            Assert.assertEquals((Object)JDOMUtil.writeElement((Element)expected), (Object)JDOMUtil.writeElement((Element)actual));
        }
    }

    @Deprecated
    public static void assertElementEquals(String expected, Element actual) {
        try {
            PlatformTestUtil.assertElementsEqual(JdomKt.loadElement((CharSequence)expected), actual);
        }
        catch (IOException | JDOMException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String getCommunityPath() {
        String homePath = PathManager.getHomePath();
        if (new File(homePath, "community/.idea").isDirectory()) {
            return homePath + File.separatorChar + "community";
        }
        return homePath;
    }

    public static String getPlatformTestDataPath() {
        return PlatformTestUtil.getCommunityPath().replace(File.separatorChar, '/') + "/platform/platform-tests/testData/";
    }

    public static Comparator<AbstractTreeNode> createComparator(Queryable.PrintInfo printInfo) {
        return (o1, o2) -> {
            String displayText1 = o1.toTestString(printInfo);
            String displayText2 = o2.toTestString(printInfo);
            return Comparing.compare((Comparable)((Object)displayText1), (Comparable)((Object)displayText2));
        };
    }

    @NotNull
    public static <T> T notNull(@Nullable T t) {
        Assert.assertNotNull(t);
        T t2 = t;
        if (t2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(27);
        }
        return t2;
    }

    @NotNull
    public static String loadFileText(@NotNull String fileName) throws IOException {
        if (fileName == null) {
            PlatformTestUtil.$$$reportNull$$$0(28);
        }
        String string = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)new File(fileName)));
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    public static void tryGcSoftlyReachableObjects() {
        GCUtil.tryGcSoftlyReachableObjects();
    }

    public static void withEncoding(@NotNull String encoding, @NotNull ThrowableRunnable r) {
        if (encoding == null) {
            PlatformTestUtil.$$$reportNull$$$0(30);
        }
        if (r == null) {
            PlatformTestUtil.$$$reportNull$$$0(31);
        }
        try {
            Charset oldCharset = Charset.defaultCharset();
            try {
                PlatformTestUtil.patchSystemFileEncoding(encoding);
                r.run();
            }
            finally {
                PlatformTestUtil.patchSystemFileEncoding(oldCharset.name());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void patchSystemFileEncoding(String encoding) {
        ReflectionUtil.resetField(Charset.class, Charset.class, (String)"defaultCharset");
        System.setProperty("file.encoding", encoding);
    }

    public static void withStdErrSuppressed(@NotNull Runnable r) {
        if (r == null) {
            PlatformTestUtil.$$$reportNull$$$0(32);
        }
        PrintStream std = System.err;
        System.setErr(new PrintStream(NULL));
        try {
            r.run();
        }
        finally {
            System.setErr(std);
        }
    }

    public static void assertSuccessful(@NotNull GeneralCommandLine command) {
        if (command == null) {
            PlatformTestUtil.$$$reportNull$$$0(33);
        }
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)command.withRedirectErrorStream(true));
            Assert.assertEquals((String)output.getStdout(), (long)0L, (long)output.getExitCode());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static List<WebReference> collectWebReferences(@NotNull PsiElement element) {
        if (element == null) {
            PlatformTestUtil.$$$reportNull$$$0(34);
        }
        final ArrayList<WebReference> refs = new ArrayList<WebReference>();
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                for (PsiReference ref : element.getReferences()) {
                    if (!(ref instanceof WebReference)) continue;
                    refs.add((WebReference)ref);
                }
                super.visitElement(element);
            }
        });
        ArrayList<WebReference> arrayList = refs;
        if (arrayList == null) {
            PlatformTestUtil.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    public static void registerProjectCleanup(@NotNull Runnable cleanup) {
        if (cleanup == null) {
            PlatformTestUtil.$$$reportNull$$$0(36);
        }
        ourProjectCleanups.add(cleanup);
    }

    public static void cleanupAllProjects() {
        for (Runnable each : ourProjectCleanups) {
            each.run();
        }
        ourProjectCleanups.clear();
    }

    public static <T> void assertComparisonContractNotViolated(@NotNull List<T> values, @NotNull Comparator<T> comparator2, @NotNull Equality<T> equality) {
        if (values == null) {
            PlatformTestUtil.$$$reportNull$$$0(37);
        }
        if (comparator2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(38);
        }
        if (equality == null) {
            PlatformTestUtil.$$$reportNull$$$0(39);
        }
        for (int i1 = 0; i1 < values.size(); ++i1) {
            for (int i2 = i1; i2 < values.size(); ++i2) {
                T value1 = values.get(i1);
                T value2 = values.get(i2);
                int result12 = comparator2.compare(value1, value2);
                int result21 = comparator2.compare(value2, value1);
                if (equality.equals(value1, value2)) {
                    Assert.assertEquals((String)String.format("Equal, but not 0: '%s' - '%s'", value1, value2), (long)0L, (long)result12);
                    Assert.assertEquals((String)String.format("Equal, but not 0: '%s' - '%s'", value2, value1), (long)0L, (long)result21);
                } else {
                    if (result12 == 0) {
                        Assert.fail((String)String.format("Not equal, but 0: '%s' - '%s'", value1, value2));
                    }
                    if (result21 == 0) {
                        Assert.fail((String)String.format("Not equal, but 0: '%s' - '%s'", value2, value1));
                    }
                    if (Integer.signum(result12) == Integer.signum(result21)) {
                        Assert.fail((String)String.format("Not symmetrical: '%s' - '%s'", value1, value2));
                    }
                }
                for (int i3 = i2; i3 < values.size(); ++i3) {
                    int result31;
                    T value3 = values.get(i3);
                    int result23 = comparator2.compare(value2, value3);
                    if (PlatformTestUtil.isTransitive(result12, result23, result31 = comparator2.compare(value3, value1))) continue;
                    Assert.fail((String)String.format("Not transitive: '%s' - '%s' - '%s'", value1, value2, value3));
                }
            }
        }
    }

    private static boolean isTransitive(int result12, int result23, int result31) {
        if (result12 == 0 && result23 == 0 && result31 == 0) {
            return true;
        }
        if (result12 > 0 && result23 > 0 && result31 > 0) {
            return false;
        }
        if (result12 < 0 && result23 < 0 && result31 < 0) {
            return false;
        }
        if (result12 == 0 && Integer.signum(result23) * Integer.signum(result31) >= 0) {
            return false;
        }
        if (result23 == 0 && Integer.signum(result12) * Integer.signum(result31) >= 0) {
            return false;
        }
        return result31 != 0 || Integer.signum(result23) * Integer.signum(result12) < 0;
    }

    public static void setLongMeaninglessFileIncludeTemplateTemporarilyFor(@NotNull Project project2, @NotNull Disposable parentDisposable) {
        if (project2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(40);
        }
        if (parentDisposable == null) {
            PlatformTestUtil.$$$reportNull$$$0(41);
        }
        FileTemplateManagerImpl templateManager = (FileTemplateManagerImpl)FileTemplateManager.getInstance(project2);
        templateManager.setDefaultFileIncludeTemplateTextTemporarilyForTest("File Header", "/**\n * Created by ${USER} on ${DATE}.\n */\n", parentDisposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 17: 
            case 21: 
            case 22: 
            case 27: 
            case 29: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 17: 
            case 21: 
            case 22: 
            case 27: 
            case 29: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 17: 
            case 21: 
            case 22: 
            case 27: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PlatformTestUtil";
                break;
            }
            case 6: 
            case 10: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 7: 
            case 11: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventQueue";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseClass";
                break;
            }
            case 23: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionToMeasure";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanup";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PlatformTestUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "lowercaseFirstLetter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructure";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaExe";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRtJarPath";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "notNull";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileText";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "collectWebReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTestName";
                break;
            }
            case 1: 
            case 3: 
            case 17: 
            case 21: 
            case 22: 
            case 27: 
            case 29: 
            case 35: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "lowercaseFirstLetter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAllUppercaseName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "waitForPromise";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "dispatchNextEventIfAny";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "assertTreeStructureEquals";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createStructure";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "startPerformanceTest";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "canRunTest";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "saveProject";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "assertTiming";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "measure";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "loadFileText";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "withEncoding";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "withStdErrSuppressed";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "assertSuccessful";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "collectWebReferences";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "registerProjectCleanup";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "assertComparisonContractNotViolated";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setLongMeaninglessFileIncludeTemplateTemporarilyFor";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerExtension$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 17: 
            case 21: 
            case 22: 
            case 27: 
            case 29: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TestInfo {
        private final ThrowableRunnable test;
        private final int expectedMs;
        private ThrowableRunnable setup;
        private int usedReferenceCpuCores;
        private int attempts;
        private final String what;
        private boolean adjustForIO;
        private boolean adjustForCPU;
        private boolean useLegacyScaling;

        private TestInfo(@NotNull ThrowableRunnable test, int expectedMs, @NotNull String what) {
            if (test == null) {
                TestInfo.$$$reportNull$$$0(0);
            }
            if (what == null) {
                TestInfo.$$$reportNull$$$0(1);
            }
            this.usedReferenceCpuCores = 1;
            this.attempts = 4;
            this.adjustForIO = false;
            this.adjustForCPU = true;
            this.test = test;
            this.expectedMs = expectedMs;
            assert (expectedMs > 0) : "Expected must be > 0. Was: " + expectedMs;
            this.what = what;
        }

        @Contract(pure=true)
        public TestInfo setup(@NotNull ThrowableRunnable setup) {
            if (setup == null) {
                TestInfo.$$$reportNull$$$0(2);
            }
            assert (this.setup == null);
            this.setup = setup;
            return this;
        }

        @Contract(pure=true)
        public TestInfo usesAllCPUCores() {
            return this.usesMultipleCPUCores(8);
        }

        @Contract(pure=true)
        public TestInfo usesMultipleCPUCores(int maxCores) {
            assert (this.adjustForCPU) : "This test configured to be io-bound, it cannot use all cores";
            this.usedReferenceCpuCores = maxCores;
            return this;
        }

        @Deprecated
        @Contract(pure=true)
        public TestInfo cpuBound() {
            this.adjustForIO = false;
            this.adjustForCPU = true;
            return this;
        }

        @Contract(pure=true)
        public TestInfo ioBound() {
            this.adjustForIO = true;
            this.adjustForCPU = false;
            return this;
        }

        @Contract(pure=true)
        public TestInfo attempts(int attempts) {
            this.attempts = attempts;
            return this;
        }

        @Contract(pure=true)
        public TestInfo useLegacyScaling() {
            this.useLegacyScaling = true;
            return this;
        }

        public void assertTiming() {
            assert (this.expectedMs != 0) : "Must call .expect() before run test";
            if (COVERAGE_ENABLED_BUILD) {
                return;
            }
            Timings.getStatistics();
            if (this.attempts == 1) {
                System.gc();
            }
            while (true) {
                CpuUsageData data;
                --this.attempts;
                try {
                    if (this.setup != null) {
                        this.setup.run();
                    }
                    PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
                    data = CpuUsageData.measureCpuUsage(this.test);
                }
                catch (Error | RuntimeException throwable) {
                    throw throwable;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                long duration = data.durationMs;
                int expectedOnMyMachine = this.expectedMs;
                if (this.adjustForCPU) {
                    int coreCountUsedHere = this.usedReferenceCpuCores < 8 ? Math.min(JobSchedulerImpl.CORES_COUNT, this.usedReferenceCpuCores) : JobSchedulerImpl.CORES_COUNT;
                    expectedOnMyMachine *= this.usedReferenceCpuCores;
                    expectedOnMyMachine = TestInfo.adjust(expectedOnMyMachine, Timings.CPU_TIMING, 200L, this.useLegacyScaling);
                    expectedOnMyMachine /= coreCountUsedHere;
                }
                if (this.adjustForIO) {
                    expectedOnMyMachine = TestInfo.adjust(expectedOnMyMachine, Timings.IO_TIMING, 100L, this.useLegacyScaling);
                }
                double acceptableChangeFactor = 1.1;
                int percentage = (int)(100.0 * (double)(duration - (long)expectedOnMyMachine) / (double)expectedOnMyMachine);
                String colorCode = duration < (long)expectedOnMyMachine ? "32;1m" : ((double)duration < (double)expectedOnMyMachine * acceptableChangeFactor ? "33;1m" : "31;1m");
                String logMessage = String.format("%s took \u001b[%s%d%% %s time\u001b[0m than expected\n  Expected: %sms (%s)\n  Actual:   %sms (%s)\n  Timings:  %s\n  Threads:  %s\n  GC stats: %s", this.what, colorCode, Math.abs(percentage), percentage > 0 ? "more" : "less", expectedOnMyMachine, StringUtil.formatDuration((long)expectedOnMyMachine), duration, StringUtil.formatDuration((long)duration), Timings.getStatistics(), data.getThreadStats(), data.getGcStats());
                if (duration < (long)expectedOnMyMachine) {
                    TeamCityLogger.info(logMessage);
                    System.out.println("\nSUCCESS: " + logMessage);
                    break;
                }
                if ((double)duration < (double)expectedOnMyMachine * acceptableChangeFactor) {
                    TeamCityLogger.warning(logMessage, null);
                    System.out.println("\nWARNING: " + logMessage);
                    break;
                }
                if (this.attempts == 0) {
                    throw new AssertionFailedError(logMessage);
                }
                System.gc();
                System.gc();
                System.gc();
                String s = logMessage + "\n  " + this.attempts + " attempts remain";
                TeamCityLogger.warning(s, null);
                if (!UsefulTestCase.IS_UNDER_TEAMCITY) continue;
                System.err.println(s);
            }
        }

        private static int adjust(int expectedOnMyMachine, long thisTiming, long referenceTiming, boolean useLegacyScaling) {
            if (useLegacyScaling) {
                double speed = 1.0 * (double)thisTiming / (double)referenceTiming;
                double delta = speed < 1.0 ? 0.9 + Math.pow(speed - 0.7, 2.0) : 0.45 + Math.pow(speed - 0.25, 2.0);
                expectedOnMyMachine = (int)((double)expectedOnMyMachine * delta);
                return expectedOnMyMachine;
            }
            return (int)((long)expectedOnMyMachine * thisTiming / referenceTiming);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "test";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "what";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "setup";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/testFramework/PlatformTestUtil$TestInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

