/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.Function;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.junit.Assert;

public class PsiTestUtil {
    public static VirtualFile createTestProjectStructure(Project project2, Module module2, String rootPath, Collection<File> filesToDelete) throws Exception {
        return PsiTestUtil.createTestProjectStructure(project2, module2, rootPath, filesToDelete, true);
    }

    public static VirtualFile createTestProjectStructure(Project project2, Module module2, Collection<File> filesToDelete) throws IOException {
        return PsiTestUtil.createTestProjectStructure(project2, module2, null, filesToDelete, true);
    }

    public static VirtualFile createTestProjectStructure(Project project2, Module module2, String rootPath, Collection<File> filesToDelete, boolean addProjectRoots) throws IOException {
        VirtualFile vDir = PsiTestUtil.createTestProjectStructure(module2, rootPath, filesToDelete, addProjectRoots);
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        return vDir;
    }

    public static VirtualFile createTestProjectStructure(Module module2, String rootPath, Collection<File> filesToDelete, boolean addProjectRoots) throws IOException {
        return PsiTestUtil.createTestProjectStructure("unitTest", module2, rootPath, filesToDelete, addProjectRoots);
    }

    public static VirtualFile createTestProjectStructure(String tempName, Module module2, String rootPath, Collection<File> filesToDelete, boolean addProjectRoots) throws IOException {
        File dir = FileUtil.createTempDirectory((String)tempName, null, (boolean)false);
        filesToDelete.add(dir);
        VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(dir.getCanonicalPath().replace(File.separatorChar, '/'));
        assert (vDir != null && vDir.isDirectory()) : dir;
        PlatformTestCase.synchronizeTempDirVfs(vDir);
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> WriteAction.run(() -> {
            if (rootPath != null) {
                VirtualFile vDir1 = LocalFileSystem.getInstance().findFileByPath(rootPath.replace(File.separatorChar, '/'));
                if (vDir1 == null) {
                    throw new Exception(rootPath + " not found");
                }
                VfsUtil.copyDirectory(null, (VirtualFile)vDir1, (VirtualFile)vDir, null);
            }
            if (addProjectRoots) {
                PsiTestUtil.addSourceContentToRoots(module2, vDir);
            }
        })));
        return vDir;
    }

    public static void removeAllRoots(@NotNull Module module2, Sdk jdk) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(0);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            model.clear();
            model.setSdk(jdk);
        });
    }

    public static void addSourceContentToRoots(Module module2, @NotNull VirtualFile vDir) {
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(1);
        }
        PsiTestUtil.addSourceContentToRoots(module2, vDir, false);
    }

    public static void addSourceContentToRoots(Module module2, @NotNull VirtualFile vDir, boolean testSource) {
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(2);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            if (vDir == null) {
                PsiTestUtil.$$$reportNull$$$0(24);
            }
            model.addContentEntry(vDir).addSourceFolder(vDir, testSource);
        });
    }

    public static void addSourceRoot(Module module2, VirtualFile vDir) {
        PsiTestUtil.addSourceRoot(module2, vDir, false);
    }

    public static void addSourceRoot(Module module2, VirtualFile vDir, boolean isTestSource) {
        PsiTestUtil.addSourceRoot(module2, vDir, isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE);
    }

    public static <P extends JpsElement> void addSourceRoot(Module module2, VirtualFile vDir, @NotNull JpsModuleSourceRootType<P> rootType) {
        if (rootType == null) {
            PsiTestUtil.$$$reportNull$$$0(3);
        }
        PsiTestUtil.addSourceRoot(module2, vDir, rootType, (JpsElement)rootType.createDefaultProperties());
    }

    public static <P extends JpsElement> void addSourceRoot(Module module2, VirtualFile vDir, @NotNull JpsModuleSourceRootType<P> rootType, P properties) {
        if (rootType == null) {
            PsiTestUtil.$$$reportNull$$$0(4);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            ContentEntry entry;
            if (rootType == null) {
                PsiTestUtil.$$$reportNull$$$0(23);
            }
            if ((entry = PsiTestUtil.findContentEntry((ModuleRootModel)model, vDir)) == null) {
                entry = model.addContentEntry(vDir);
            }
            entry.addSourceFolder(vDir, rootType, properties);
        });
    }

    @Nullable
    private static ContentEntry findContentEntry(ModuleRootModel rootModel, VirtualFile file2) {
        return (ContentEntry)ContainerUtil.find((Object[])rootModel.getContentEntries(), object -> {
            VirtualFile entryRoot = object.getFile();
            return entryRoot != null && VfsUtilCore.isAncestor((VirtualFile)entryRoot, (VirtualFile)file2, (boolean)false);
        });
    }

    public static ContentEntry addContentRoot(Module module2, VirtualFile vDir) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> model.addContentEntry(vDir));
        for (ContentEntry entry : ModuleRootManager.getInstance((Module)module2).getContentEntries()) {
            if (!Comparing.equal((Object)entry.getFile(), (Object)vDir)) continue;
            Assert.assertFalse((boolean)((ContentEntryImpl)entry).isDisposed());
            return entry;
        }
        return null;
    }

    public static void addExcludedRoot(Module module2, VirtualFile dir) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> ApplicationManager.getApplication().runReadAction(() -> PsiTestUtil.findContentEntryWithAssertion(model, dir).addExcludeFolder(dir)));
    }

    @NotNull
    private static ContentEntry findContentEntryWithAssertion(ModifiableRootModel model, VirtualFile dir) {
        ContentEntry entry = PsiTestUtil.findContentEntry((ModuleRootModel)model, dir);
        if (entry == null) {
            throw new RuntimeException(dir + " is not under content roots: " + Arrays.toString(model.getContentRoots()));
        }
        ContentEntry contentEntry = entry;
        if (contentEntry == null) {
            PsiTestUtil.$$$reportNull$$$0(5);
        }
        return contentEntry;
    }

    public static void removeContentEntry(Module module2, VirtualFile contentRoot) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> model.removeContentEntry(PsiTestUtil.findContentEntryWithAssertion(model, contentRoot)));
    }

    public static void removeSourceRoot(@NotNull Module module2, @NotNull VirtualFile root) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(6);
        }
        if (root == null) {
            PsiTestUtil.$$$reportNull$$$0(7);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            if (root == null) {
                PsiTestUtil.$$$reportNull$$$0(22);
            }
            ContentEntry entry = PsiTestUtil.findContentEntryWithAssertion(model, root);
            for (SourceFolder sourceFolder : entry.getSourceFolders()) {
                if (!root.equals(sourceFolder.getFile())) continue;
                entry.removeSourceFolder(sourceFolder);
                break;
            }
        });
    }

    public static void removeExcludedRoot(Module module2, VirtualFile root) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            ContentEntry entry = PsiTestUtil.findContentEntryWithAssertion(model, root);
            entry.removeExcludeFolder(root.getUrl());
        });
    }

    public static void checkFileStructure(PsiFile file2) {
        PsiTestUtil.compareFromAllRoots(file2, (Function<PsiFile, String>)((Function)f -> DebugUtil.psiTreeToString((PsiElement)f, false)));
    }

    private static void compareFromAllRoots(PsiFile file2, Function<PsiFile, String> fun) {
        String reparsedTree;
        PsiFile dummyFile = PsiTestUtil.createDummyCopy(file2);
        String psiTree = StringUtil.join((Collection)file2.getViewProvider().getAllFiles(), fun, (String)"\n");
        if (!psiTree.equals(reparsedTree = StringUtil.join((Collection)dummyFile.getViewProvider().getAllFiles(), fun, (String)"\n"))) {
            Assert.assertEquals((Object)("Re-created from text:\n" + reparsedTree), (Object)("PSI structure:\n" + psiTree));
        }
    }

    @NotNull
    private static PsiFile createDummyCopy(PsiFile file2) {
        LightVirtualFile copy = new LightVirtualFile(file2.getName(), (CharSequence)file2.getText());
        copy.setOriginalFile(file2.getViewProvider().getVirtualFile());
        PsiFile psiFile = Objects.requireNonNull(file2.getManager().findFile((VirtualFile)copy));
        if (psiFile == null) {
            PsiTestUtil.$$$reportNull$$$0(8);
        }
        return psiFile;
    }

    public static void checkPsiMatchesTextIgnoringNonCode(PsiFile file2) {
        PsiTestUtil.compareFromAllRoots(file2, (Function<PsiFile, String>)((Function)f -> DebugUtil.psiToStringIgnoringNonCode((PsiElement)f)));
    }

    public static void addLibrary(Module module2, String libPath) {
        File file2 = new File(libPath);
        String libName = file2.getName();
        PsiTestUtil.addLibrary(module2, libName, file2.getParent(), libName);
    }

    public static void addLibrary(Module module2, String libName, String libPath, String ... jarArr) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> PsiTestUtil.addLibrary(module2, model, libName, libPath, jarArr));
    }

    public static void addLibrary(@NotNull Disposable parent, Module module2, String libName, String libPath, String ... jarArr) {
        if (parent == null) {
            PsiTestUtil.$$$reportNull$$$0(9);
        }
        Ref ref = new Ref();
        ModuleRootModificationUtil.updateModel((Module)module2, model -> ref.set((Object)PsiTestUtil.addLibrary(module2, model, libName, libPath, jarArr)));
        Disposer.register((Disposable)parent, () -> {
            Library library = (Library)ref.get();
            ModuleRootModificationUtil.updateModel((Module)module2, model -> model.removeOrderEntry((OrderEntry)model.findLibraryOrderEntry(library)));
            WriteCommandAction.runWriteCommandAction(null, () -> {
                LibraryTable table = ProjectLibraryTable.getInstance(module2.getProject());
                LibraryTable.ModifiableModel model = table.getModifiableModel();
                model.removeLibrary(library);
                model.commit();
            });
        });
    }

    public static void addProjectLibrary(Module module2, String libName, List<String> classesRootPaths) {
        List<VirtualFile> roots = PsiTestUtil.getLibraryRoots(classesRootPaths);
        PsiTestUtil.addProjectLibrary(module2, libName, roots, Collections.emptyList());
    }

    @NotNull
    private static List<VirtualFile> getLibraryRoots(List<String> classesRootPaths) {
        List list2 = ContainerUtil.map(classesRootPaths, path -> VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot((File)new File((String)path))));
        if (list2 == null) {
            PsiTestUtil.$$$reportNull$$$0(10);
        }
        return list2;
    }

    public static void addProjectLibrary(ModifiableRootModel model, String libName, List<String> classesRootPaths) {
        List<VirtualFile> roots = PsiTestUtil.getLibraryRoots(classesRootPaths);
        PsiTestUtil.addProjectLibrary(model, libName, roots, Collections.emptyList());
    }

    public static void addProjectLibrary(Module module2, String libName, VirtualFile ... classesRoots) {
        PsiTestUtil.addProjectLibrary(module2, libName, Arrays.asList(classesRoots), Collections.emptyList());
    }

    public static Library addProjectLibrary(Module module2, String libName, List<VirtualFile> classesRoots, List<VirtualFile> sourceRoots) {
        Ref result2 = Ref.create();
        ModuleRootModificationUtil.updateModel((Module)module2, model -> result2.set((Object)PsiTestUtil.addProjectLibrary(model, libName, classesRoots, sourceRoots)));
        return (Library)result2.get();
    }

    @NotNull
    private static Library addProjectLibrary(final ModifiableRootModel model, final String libName, final List<VirtualFile> classesRoots, final List<VirtualFile> sourceRoots) {
        final LibraryTable libraryTable = ProjectLibraryTable.getInstance(model.getProject());
        RunResult result2 = new WriteAction<Library>(){

            protected void run(@NotNull Result<Library> result2) {
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                Library library = libraryTable.createLibrary(libName);
                Library.ModifiableModel libraryModel = library.getModifiableModel();
                try {
                    for (VirtualFile root : classesRoots) {
                        libraryModel.addRoot(root, OrderRootType.CLASSES);
                    }
                    for (VirtualFile root : sourceRoots) {
                        libraryModel.addRoot(root, OrderRootType.SOURCES);
                    }
                    libraryModel.commit();
                }
                catch (Throwable t) {
                    libraryModel.dispose();
                    throw t;
                }
                model.addLibraryEntry(library);
                OrderEntry[] orderEntries = model.getOrderEntries();
                OrderEntry last = orderEntries[orderEntries.length - 1];
                System.arraycopy(orderEntries, 0, orderEntries, 1, orderEntries.length - 1);
                orderEntries[0] = last;
                model.rearrangeOrderEntries(orderEntries);
                result2.setResult((Object)library);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PsiTestUtil$1", "run"));
            }
        }.execute();
        result2.throwException();
        Library library = (Library)result2.getResultObject();
        if (library == null) {
            PsiTestUtil.$$$reportNull$$$0(11);
        }
        return library;
    }

    @NotNull
    public static Library addLibrary(Module module2, ModifiableRootModel model, String libName, String libPath, String ... jarArr) {
        ArrayList<VirtualFile> classesRoots = new ArrayList<VirtualFile>();
        for (String jar : jarArr) {
            String path;
            if (!libPath.endsWith("/") && !jar.startsWith("/")) {
                jar = "/" + jar;
            }
            VirtualFile root = (path = libPath + jar).endsWith(".jar") ? JarFileSystem.getInstance().refreshAndFindFileByPath(path + "!/") : LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
            assert (root != null) : "Library root folder not found: " + path + "!/";
            classesRoots.add(root);
        }
        Library library = PsiTestUtil.addProjectLibrary(model, libName, classesRoots, Collections.emptyList());
        if (library == null) {
            PsiTestUtil.$$$reportNull$$$0(12);
        }
        return library;
    }

    public static void addLibrary(Module module2, String libName, String libDir, String[] classRoots, String[] sourceRoots) {
        String proto = (classRoots.length > 0 ? classRoots[0] : sourceRoots[0]).endsWith(".jar!/") ? "jar" : "file";
        String parentUrl = VirtualFileManager.constructUrl((String)proto, (String)libDir);
        ArrayList<String> classesUrls = new ArrayList<String>();
        ArrayList<String> sourceUrls = new ArrayList<String>();
        for (String classRoot : classRoots) {
            classesUrls.add(parentUrl + classRoot);
        }
        for (String sourceRoot : sourceRoots) {
            sourceUrls.add(parentUrl + sourceRoot);
        }
        ModuleRootModificationUtil.addModuleLibrary((Module)module2, (String)libName, classesUrls, sourceUrls);
    }

    public static Module addModule(final Project project2, final ModuleType type2, final String name2, final VirtualFile root) {
        return (Module)new WriteCommandAction<Module>(project2, new PsiFile[0]){

            protected void run(@NotNull Result<Module> result2) {
                String moduleName;
                if (result2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)project2).getModifiableModel();
                try {
                    moduleName = moduleModel.newModule(root.getPath() + "/" + name2 + ".iml", type2.getId()).getName();
                    moduleModel.commit();
                }
                catch (Throwable t) {
                    moduleModel.dispose();
                    throw t;
                }
                Module dep = ModuleManager.getInstance((Project)project2).findModuleByName(moduleName);
                assert (dep != null) : moduleName;
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)dep).getModifiableModel();
                try {
                    model.addContentEntry(root).addSourceFolder(root, false);
                    model.commit();
                }
                catch (Throwable t) {
                    model.dispose();
                    throw t;
                }
                result2.setResult((Object)dep);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PsiTestUtil$2", "run"));
            }
        }.execute().getResultObject();
    }

    public static void setCompilerOutputPath(Module module2, String url, boolean forTests) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            CompilerModuleExtension extension = (CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class);
            extension.inheritCompilerOutputPath(false);
            if (forTests) {
                extension.setCompilerOutputPathForTests(url);
            } else {
                extension.setCompilerOutputPath(url);
            }
        });
    }

    public static void setExcludeCompileOutput(Module module2, boolean exclude) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> ((CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class)).setExcludeOutput(exclude));
    }

    public static void setJavadocUrls(Module module2, String ... urls) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> ((JavaModuleExternalPaths)model.getModuleExtension(JavaModuleExternalPaths.class)).setJavadocUrls(urls));
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addJdkAnnotations(@NotNull Sdk sdk) {
        if (sdk == null) {
            PsiTestUtil.$$$reportNull$$$0(13);
        }
        String path = FileUtil.toSystemIndependentName((String)PlatformTestUtil.getCommunityPath()) + "/java/jdkAnnotations";
        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path);
        Sdk sdk2 = PsiTestUtil.addRootsToJdk(sdk, AnnotationOrderRootType.getInstance(), root);
        if (sdk2 == null) {
            PsiTestUtil.$$$reportNull$$$0(14);
        }
        return sdk2;
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addRootsToJdk(@NotNull Sdk sdk, @NotNull OrderRootType rootType, VirtualFile ... roots) {
        Sdk clone;
        if (sdk == null) {
            PsiTestUtil.$$$reportNull$$$0(15);
        }
        if (rootType == null) {
            PsiTestUtil.$$$reportNull$$$0(16);
        }
        if (roots == null) {
            PsiTestUtil.$$$reportNull$$$0(17);
        }
        try {
            clone = (Sdk)sdk.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        SdkModificator sdkModificator = clone.getSdkModificator();
        for (VirtualFile root : roots) {
            sdkModificator.addRoot(root, rootType);
        }
        sdkModificator.commitChanges();
        Sdk sdk2 = clone;
        if (sdk2 == null) {
            PsiTestUtil.$$$reportNull$$$0(18);
        }
        return sdk2;
    }

    public static void checkStubsMatchText(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiTestUtil.$$$reportNull$$$0(19);
        }
        try {
            StubTextInconsistencyException.checkStubTextConsistency(file2);
        }
        catch (StubTextInconsistencyException e) {
            PsiTestUtil.compareStubTexts(e);
        }
    }

    public static void compareStubTexts(@NotNull StubTextInconsistencyException e) {
        if (e == null) {
            PsiTestUtil.$$$reportNull$$$0(20);
        }
        Assert.assertEquals((Object)("Re-created from text:\n" + e.getStubsFromText()), (Object)("Stubs from PSI structure:\n" + e.getStubsFromPsi()));
        throw e;
    }

    public static void checkPsiStructureWithCommit(@NotNull PsiFile psiFile, Consumer<PsiFile> checker) {
        if (psiFile == null) {
            PsiTestUtil.$$$reportNull$$$0(21);
        }
        checker.accept(psiFile);
        Document document = psiFile.getViewProvider().getDocument();
        Project project2 = psiFile.getProject();
        if (document != null && PsiDocumentManager.getInstance((Project)project2).isUncommited(document)) {
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
            checker.accept(psiFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vDir";
                break;
            }
            case 3: 
            case 4: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PsiTestUtil";
                break;
            }
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PsiTestUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findContentEntryWithAssertion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyCopy";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRoots";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addProjectLibrary";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addLibrary";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addJdkAnnotations";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "addRootsToJdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeAllRoots";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addSourceContentToRoots";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSourceRoot";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceRoot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addLibrary";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addJdkAnnotations";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addRootsToJdk";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkStubsMatchText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "compareStubTexts";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiStructureWithCommit";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeSourceRoot$10";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addSourceRoot$4";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addSourceContentToRoots$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

