/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration.createTest;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Template;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.ui.MemberSelectionTable;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class MissedTestsDialog
extends DialogWrapper {
    private final PsiClass mySourceClass;
    private final PsiClass myTestClass;
    private final TestFramework myDescriptor;
    private MemberSelectionTable myTable;
    private final JBCheckBox myIncludeInheritedCb = new JBCheckBox(CodeInsightBundle.message((String)"intention.create.test.dialog.show.inherited", (Object[])new Object[0]));

    public MissedTestsDialog(@Nullable Project project2, PsiClass sourceClass, PsiClass testClass, TestFramework descriptor2) {
        super(project2, true);
        this.mySourceClass = sourceClass;
        this.myTestClass = testClass;
        this.myDescriptor = descriptor2;
        this.setTitle("Create Missed Tests");
        this.init();
    }

    public Collection<MemberInfo> getSelectedMethods() {
        return this.myTable.getSelectedMemberInfos();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        List<MemberInfo> info = TestIntegrationUtils.extractClassMethods(this.mySourceClass, false);
        this.disableMethodsWithTests(info);
        JPanel panel2 = new JPanel(new BorderLayout());
        this.myTable = new MemberSelectionTable(info, null);
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTable)), "Center");
        panel2.add((Component)this.myIncludeInheritedCb, "North");
        this.myIncludeInheritedCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MissedTestsDialog.this.updateMethodsTable();
            }
        });
        return panel2;
    }

    private void disableMethodsWithTests(List<MemberInfo> info) {
        HashSet<String> existingNames = new HashSet<String>();
        String prefix = this.getTestPrefix(existingNames);
        existingNames.addAll(ContainerUtil.map((Object[])this.myTestClass.getMethods(), method -> StringUtil.decapitalize((String)StringUtil.trimStart((String)method.getName(), (String)prefix))));
        Iterator<MemberInfo> iterator = info.iterator();
        while (iterator.hasNext()) {
            MemberInfo memberInfo;
            PsiMember member = (PsiMember)(memberInfo = iterator.next()).getMember();
            memberInfo.setChecked(!(member instanceof PsiMethod) || !existingNames.contains(member.getName()));
        }
    }

    private String getTestPrefix(Set<String> existingNames) {
        Template template = TestIntegrationUtils.createTestMethodTemplate(TestIntegrationUtils.MethodKind.TEST, this.myDescriptor, this.myTestClass, null, true, existingNames);
        try {
            return JavaPsiFacade.getElementFactory((Project)this.myTestClass.getProject()).createMethodFromText(template.getTemplateText(), (PsiElement)this.myTestClass).getName();
        }
        catch (IncorrectOperationException e) {
            return "";
        }
    }

    private void updateMethodsTable() {
        List<MemberInfo> infos = TestIntegrationUtils.extractClassMethods(this.mySourceClass, this.myIncludeInheritedCb.isSelected());
        HashSet<PsiElement> selectedMethods = new HashSet<PsiElement>();
        for (MemberInfo each : this.myTable.getSelectedMemberInfos()) {
            selectedMethods.add(each.getMember());
        }
        for (MemberInfo each : infos) {
            each.setChecked(selectedMethods.contains(each.getMember()));
        }
        this.myTable.setMemberInfos(infos);
    }
}

