/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.CommonBundle;
import com.intellij.execution.filters.InvalidExpressionException;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.ToolsBundle;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;

class FilterDialog
extends DialogWrapper {
    private final JTextField myRegexpField = new JTextField();
    private final JTextField myNameField = new JTextField();
    private final JTextField myDescriptionField = new JTextField();
    private JPopupMenu myPopup;

    private FilterDialog(Component component) {
        super(component, true);
        this.init();
        this.setOKActionEnabled(true);
        this.myRegexpField.setToolTipText(ToolsBundle.message("tools.filters.add.macro.tooltip", new Object[0]));
    }

    public static boolean editFilter(FilterInfo filterInfo, JComponent parentComponent, String title) throws InvalidExpressionException {
        FilterDialog dialog2 = new FilterDialog(parentComponent);
        dialog2.setTitle(title);
        dialog2.myNameField.setText(filterInfo.getName());
        dialog2.myDescriptionField.setText(filterInfo.getDescription());
        dialog2.myRegexpField.setText(filterInfo.getRegExp());
        if (!dialog2.showAndGet()) {
            return false;
        }
        filterInfo.setName(dialog2.myNameField.getText());
        filterInfo.setDescription(dialog2.myDescriptionField.getText());
        filterInfo.setRegExp(dialog2.myRegexpField.getText());
        return true;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRegexpField;
    }

    protected JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.anchor = 17;
        constr.weighty = 0.0;
        constr.gridwidth = 1;
        constr.insets = new Insets(5, 0, 0, 0);
        panel2.add((Component)new JLabel(ToolsBundle.message("tools.filters.add.name.label", new Object[0])), constr);
        constr.gridx = 0;
        constr.gridy = 1;
        constr.weightx = 1.0;
        constr.gridwidth = 3;
        constr.fill = 2;
        panel2.add((Component)this.myNameField, constr);
        constr.gridx = 0;
        constr.gridy = 2;
        constr.weightx = 0.0;
        panel2.add((Component)new JLabel(ToolsBundle.message("tools.filters.add.description.label", new Object[0])), constr);
        constr.gridx = 0;
        constr.gridy = 3;
        constr.gridwidth = 2;
        constr.weightx = 1.0;
        panel2.add((Component)this.myDescriptionField, constr);
        constr.gridy = 4;
        constr.gridx = 0;
        constr.gridwidth = 2;
        constr.weightx = 0.0;
        panel2.add((Component)new JLabel(ToolsBundle.message("tools.filters.add.regex.label", new Object[0])), constr);
        constr.gridx = 0;
        constr.gridy = 5;
        constr.gridwidth = 3;
        panel2.add((Component)this.myRegexpField, constr);
        this.makePopup();
        panel2.setPreferredSize((Dimension)JBUI.size((int)335, (int)160));
        mainPanel.add((Component)panel2, "North");
        return mainPanel;
    }

    private void makePopup() {
        this.myPopup = new JBPopupMenu();
        String[] macrosName = RegexpFilter.getMacrosName();
        JMenuItem[] items = new JMenuItem[macrosName.length];
        for (int i = 0; i < macrosName.length; ++i) {
            items[i] = this.myPopup.add(macrosName[i]);
            items[i].addActionListener(new MenuItemListener(macrosName[i]));
        }
        this.myRegexpField.addMouseListener((MouseListener)((Object)new PopupListener()));
    }

    protected void doOKAction() {
        String errorMessage = null;
        if (this.noText(this.myNameField.getText())) {
            errorMessage = ToolsBundle.message("tools.filters.add.name.required.error", new Object[0]);
        } else if (this.noText(this.myRegexpField.getText())) {
            errorMessage = ToolsBundle.message("tools.filters.add.regex.required.error", new Object[0]);
        }
        if (errorMessage != null) {
            Messages.showMessageDialog((Component)this.getContentPane(), (String)errorMessage, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        try {
            this.checkRegexp(this.myRegexpField.getText());
        }
        catch (InvalidExpressionException | PatternSyntaxException e) {
            Messages.showMessageDialog((Component)this.getContentPane(), (String)e.getMessage(), (String)ToolsBundle.message("tools.filters.add.regex.invalid.title", new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        super.doOKAction();
    }

    private void checkRegexp(String regexpText) {
        RegexpFilter.validate((String)regexpText);
    }

    private boolean noText(String text2) {
        return "".equals(text2);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.tools.FilterDialog";
    }

    protected String getHelpId() {
        return "reference.settings.ide.settings.external.tools.output.filters.add.filter";
    }

    private class PopupListener
    extends PopupHandler {
        private PopupListener() {
        }

        public void invokePopup(Component comp, int x, int y) {
            FilterDialog.this.myPopup.show(comp, x, y);
        }
    }

    private class MenuItemListener
    implements ActionListener {
        private final String myMacrosName;

        private MenuItemListener(String macrosName) {
            this.myMacrosName = macrosName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int position = FilterDialog.this.myRegexpField.getCaretPosition();
            try {
                if (FilterDialog.this.myRegexpField.getText().indexOf(this.myMacrosName) == -1) {
                    FilterDialog.this.myRegexpField.getDocument().insertString(position, this.myMacrosName, null);
                    FilterDialog.this.myRegexpField.setCaretPosition(position + this.myMacrosName.length());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)FilterDialog.this.myRegexpField, true));
        }
    }
}

