/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextAccessor;
import javax.swing.JComponent;

public class EditorTextFieldWithBrowseButton
extends ComponentWithBrowseButton<EditorTextField>
implements TextAccessor {
    public EditorTextFieldWithBrowseButton(Project project2, boolean isClassAccepted) {
        this(project2, isClassAccepted, JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
    }

    public EditorTextFieldWithBrowseButton(Project project2, boolean isClassAccepted, JavaCodeFragment.VisibilityChecker visibilityChecker) {
        super((JComponent)((Object)EditorTextFieldWithBrowseButton.createEditorTextField(project2, isClassAccepted, visibilityChecker)), null);
    }

    public EditorTextFieldWithBrowseButton(Project project2, boolean isClassAccepted, JavaCodeFragment.VisibilityChecker visibilityChecker, FileType fileType) {
        super((JComponent)((Object)EditorTextFieldWithBrowseButton.createEditorTextField(project2, isClassAccepted, visibilityChecker, fileType)), null);
    }

    private static EditorTextField createEditorTextField(Project project2, boolean isClassAccepted, JavaCodeFragment.VisibilityChecker visibilityChecker) {
        return EditorTextFieldWithBrowseButton.createEditorTextField(project2, isClassAccepted, visibilityChecker, (FileType)StdFileTypes.JAVA);
    }

    private static EditorTextField createEditorTextField(Project project2, boolean isClassAccepted, JavaCodeFragment.VisibilityChecker visibilityChecker, FileType fileType) {
        if (project2.isDefault()) {
            return new EditorTextField();
        }
        return new EditorTextField(EditorTextFieldWithBrowseButton.createDocument("", project2, isClassAccepted, visibilityChecker), project2, fileType);
    }

    private static Document createDocument(String text2, Project project2, boolean isClassesAccepted, JavaCodeFragment.VisibilityChecker visibilityChecker) {
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)project2).findPackage("");
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project2);
        PsiJavaCodeReferenceCodeFragment fragment = factory.createReferenceCodeFragment(text2, (PsiElement)defaultPackage, true, isClassesAccepted);
        fragment.setVisibilityChecker(visibilityChecker);
        return PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)fragment);
    }

    public void setText(String text2) {
        if (text2 == null) {
            text2 = "";
        }
        ((EditorTextField)((Object)this.getChildComponent())).setText(text2);
    }

    public String getText() {
        return ((EditorTextField)((Object)this.getChildComponent())).getText();
    }
}

